/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkFramebufferCreateInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int RENDERPASS;
    public static final int ATTACHMENTCOUNT;
    public static final int PATTACHMENTS;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int LAYERS;

    VkFramebufferCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkFramebufferCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkFramebufferCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkFramebufferCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkFramebufferCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkFramebufferCreateInfo.nflags(this.address());
    }

    public long renderPass() {
        return VkFramebufferCreateInfo.nrenderPass(this.address());
    }

    public int attachmentCount() {
        return VkFramebufferCreateInfo.nattachmentCount(this.address());
    }

    public LongBuffer pAttachments() {
        return VkFramebufferCreateInfo.npAttachments(this.address());
    }

    public int width() {
        return VkFramebufferCreateInfo.nwidth(this.address());
    }

    public int height() {
        return VkFramebufferCreateInfo.nheight(this.address());
    }

    public int layers() {
        return VkFramebufferCreateInfo.nlayers(this.address());
    }

    public VkFramebufferCreateInfo sType(int value) {
        VkFramebufferCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo pNext(long value) {
        VkFramebufferCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo flags(int value) {
        VkFramebufferCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo renderPass(long value) {
        VkFramebufferCreateInfo.nrenderPass(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo pAttachments(LongBuffer value) {
        VkFramebufferCreateInfo.npAttachments(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo width(int value) {
        VkFramebufferCreateInfo.nwidth(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo height(int value) {
        VkFramebufferCreateInfo.nheight(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo layers(int value) {
        VkFramebufferCreateInfo.nlayers(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo set(int sType, long pNext, int flags, long renderPass, LongBuffer pAttachments, int width, int height, int layers) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.renderPass(renderPass);
        this.pAttachments(pAttachments);
        this.width(width);
        this.height(height);
        this.layers(layers);
        return this;
    }

    public VkFramebufferCreateInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkFramebufferCreateInfo set(VkFramebufferCreateInfo src) {
        return this.nset(src.address());
    }

    public static VkFramebufferCreateInfo malloc() {
        return VkFramebufferCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkFramebufferCreateInfo calloc() {
        return VkFramebufferCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkFramebufferCreateInfo create() {
        return new VkFramebufferCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkFramebufferCreateInfo create(long address) {
        return address == 0L ? null : new VkFramebufferCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkFramebufferCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkFramebufferCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkFramebufferCreateInfo mallocStack() {
        return VkFramebufferCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkFramebufferCreateInfo callocStack() {
        return VkFramebufferCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkFramebufferCreateInfo mallocStack(MemoryStack stack) {
        return VkFramebufferCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkFramebufferCreateInfo callocStack(MemoryStack stack) {
        return VkFramebufferCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkFramebufferCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkFramebufferCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkFramebufferCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkFramebufferCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long nrenderPass(long struct) {
        return MemoryUtil.memGetLong(struct + (long)RENDERPASS);
    }

    public static int nattachmentCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ATTACHMENTCOUNT);
    }

    public static LongBuffer npAttachments(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PATTACHMENTS), VkFramebufferCreateInfo.nattachmentCount(struct));
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHT);
    }

    public static int nlayers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYERS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nrenderPass(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)RENDERPASS, value);
    }

    public static void nattachmentCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ATTACHMENTCOUNT, value);
    }

    public static void npAttachments(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PATTACHMENTS, MemoryUtil.memAddressSafe(value));
        VkFramebufferCreateInfo.nattachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nwidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HEIGHT, value);
    }

    public static void nlayers(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LAYERS, value);
    }

    public static void validate(long struct) {
        if (VkFramebufferCreateInfo.nattachmentCount(struct) != 0) {
            Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PATTACHMENTS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkFramebufferCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkFramebufferCreateInfo.__struct(VkFramebufferCreateInfo.__member(4), VkFramebufferCreateInfo.__member(POINTER_SIZE), VkFramebufferCreateInfo.__member(4), VkFramebufferCreateInfo.__member(8), VkFramebufferCreateInfo.__member(4), VkFramebufferCreateInfo.__member(POINTER_SIZE), VkFramebufferCreateInfo.__member(4), VkFramebufferCreateInfo.__member(4), VkFramebufferCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        RENDERPASS = layout.offsetof(3);
        ATTACHMENTCOUNT = layout.offsetof(4);
        PATTACHMENTS = layout.offsetof(5);
        WIDTH = layout.offsetof(6);
        HEIGHT = layout.offsetof(7);
        LAYERS = layout.offsetof(8);
    }

    public static final class Buffer
    extends StructBuffer<VkFramebufferCreateInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkFramebufferCreateInfo newInstance(long address) {
            return new VkFramebufferCreateInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkFramebufferCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkFramebufferCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkFramebufferCreateInfo.nflags(this.address());
        }

        public long renderPass() {
            return VkFramebufferCreateInfo.nrenderPass(this.address());
        }

        public int attachmentCount() {
            return VkFramebufferCreateInfo.nattachmentCount(this.address());
        }

        public LongBuffer pAttachments() {
            return VkFramebufferCreateInfo.npAttachments(this.address());
        }

        public int width() {
            return VkFramebufferCreateInfo.nwidth(this.address());
        }

        public int height() {
            return VkFramebufferCreateInfo.nheight(this.address());
        }

        public int layers() {
            return VkFramebufferCreateInfo.nlayers(this.address());
        }

        public Buffer sType(int value) {
            VkFramebufferCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkFramebufferCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkFramebufferCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer renderPass(long value) {
            VkFramebufferCreateInfo.nrenderPass(this.address(), value);
            return this;
        }

        public Buffer pAttachments(LongBuffer value) {
            VkFramebufferCreateInfo.npAttachments(this.address(), value);
            return this;
        }

        public Buffer width(int value) {
            VkFramebufferCreateInfo.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(int value) {
            VkFramebufferCreateInfo.nheight(this.address(), value);
            return this;
        }

        public Buffer layers(int value) {
            VkFramebufferCreateInfo.nlayers(this.address(), value);
            return this;
        }
    }
}

