/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImageSubresourceLayers
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ASPECTMASK;
    public static final int MIPLEVEL;
    public static final int BASEARRAYLAYER;
    public static final int LAYERCOUNT;

    VkImageSubresourceLayers(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkImageSubresourceLayers(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImageSubresourceLayers.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int aspectMask() {
        return VkImageSubresourceLayers.naspectMask(this.address());
    }

    public int mipLevel() {
        return VkImageSubresourceLayers.nmipLevel(this.address());
    }

    public int baseArrayLayer() {
        return VkImageSubresourceLayers.nbaseArrayLayer(this.address());
    }

    public int layerCount() {
        return VkImageSubresourceLayers.nlayerCount(this.address());
    }

    public VkImageSubresourceLayers aspectMask(int value) {
        VkImageSubresourceLayers.naspectMask(this.address(), value);
        return this;
    }

    public VkImageSubresourceLayers mipLevel(int value) {
        VkImageSubresourceLayers.nmipLevel(this.address(), value);
        return this;
    }

    public VkImageSubresourceLayers baseArrayLayer(int value) {
        VkImageSubresourceLayers.nbaseArrayLayer(this.address(), value);
        return this;
    }

    public VkImageSubresourceLayers layerCount(int value) {
        VkImageSubresourceLayers.nlayerCount(this.address(), value);
        return this;
    }

    public VkImageSubresourceLayers set(int aspectMask, int mipLevel, int baseArrayLayer, int layerCount) {
        this.aspectMask(aspectMask);
        this.mipLevel(mipLevel);
        this.baseArrayLayer(baseArrayLayer);
        this.layerCount(layerCount);
        return this;
    }

    public VkImageSubresourceLayers nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkImageSubresourceLayers set(VkImageSubresourceLayers src) {
        return this.nset(src.address());
    }

    public static VkImageSubresourceLayers malloc() {
        return VkImageSubresourceLayers.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkImageSubresourceLayers calloc() {
        return VkImageSubresourceLayers.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkImageSubresourceLayers create() {
        return new VkImageSubresourceLayers(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImageSubresourceLayers create(long address) {
        return address == 0L ? null : new VkImageSubresourceLayers(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkImageSubresourceLayers.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageSubresourceLayers.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkImageSubresourceLayers mallocStack() {
        return VkImageSubresourceLayers.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageSubresourceLayers callocStack() {
        return VkImageSubresourceLayers.callocStack(MemoryStack.stackGet());
    }

    public static VkImageSubresourceLayers mallocStack(MemoryStack stack) {
        return VkImageSubresourceLayers.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageSubresourceLayers callocStack(MemoryStack stack) {
        return VkImageSubresourceLayers.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageSubresourceLayers.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageSubresourceLayers.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageSubresourceLayers.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageSubresourceLayers.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int naspectMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ASPECTMASK);
    }

    public static int nmipLevel(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MIPLEVEL);
    }

    public static int nbaseArrayLayer(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BASEARRAYLAYER);
    }

    public static int nlayerCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYERCOUNT);
    }

    public static void naspectMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ASPECTMASK, value);
    }

    public static void nmipLevel(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MIPLEVEL, value);
    }

    public static void nbaseArrayLayer(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BASEARRAYLAYER, value);
    }

    public static void nlayerCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LAYERCOUNT, value);
    }

    static {
        Struct.Layout layout = VkImageSubresourceLayers.__struct(VkImageSubresourceLayers.__member(4), VkImageSubresourceLayers.__member(4), VkImageSubresourceLayers.__member(4), VkImageSubresourceLayers.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ASPECTMASK = layout.offsetof(0);
        MIPLEVEL = layout.offsetof(1);
        BASEARRAYLAYER = layout.offsetof(2);
        LAYERCOUNT = layout.offsetof(3);
    }

    public static final class Buffer
    extends StructBuffer<VkImageSubresourceLayers, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImageSubresourceLayers newInstance(long address) {
            return new VkImageSubresourceLayers(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int aspectMask() {
            return VkImageSubresourceLayers.naspectMask(this.address());
        }

        public int mipLevel() {
            return VkImageSubresourceLayers.nmipLevel(this.address());
        }

        public int baseArrayLayer() {
            return VkImageSubresourceLayers.nbaseArrayLayer(this.address());
        }

        public int layerCount() {
            return VkImageSubresourceLayers.nlayerCount(this.address());
        }

        public Buffer aspectMask(int value) {
            VkImageSubresourceLayers.naspectMask(this.address(), value);
            return this;
        }

        public Buffer mipLevel(int value) {
            VkImageSubresourceLayers.nmipLevel(this.address(), value);
            return this;
        }

        public Buffer baseArrayLayer(int value) {
            VkImageSubresourceLayers.nbaseArrayLayer(this.address(), value);
            return this;
        }

        public Buffer layerCount(int value) {
            VkImageSubresourceLayers.nlayerCount(this.address(), value);
            return this;
        }
    }
}

