/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkOffset2D;

public class VkRect2D
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int EXTENT;

    VkRect2D(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkRect2D(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkRect2D.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkOffset2D offset() {
        return VkRect2D.noffset(this.address());
    }

    public VkExtent2D extent() {
        return VkRect2D.nextent(this.address());
    }

    public VkRect2D offset(VkOffset2D value) {
        VkRect2D.noffset(this.address(), value);
        return this;
    }

    public VkRect2D extent(VkExtent2D value) {
        VkRect2D.nextent(this.address(), value);
        return this;
    }

    public VkRect2D set(VkOffset2D offset, VkExtent2D extent) {
        this.offset(offset);
        this.extent(extent);
        return this;
    }

    public VkRect2D nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkRect2D set(VkRect2D src) {
        return this.nset(src.address());
    }

    public static VkRect2D malloc() {
        return VkRect2D.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkRect2D calloc() {
        return VkRect2D.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkRect2D create() {
        return new VkRect2D(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkRect2D create(long address) {
        return address == 0L ? null : new VkRect2D(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkRect2D.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkRect2D.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkRect2D mallocStack() {
        return VkRect2D.mallocStack(MemoryStack.stackGet());
    }

    public static VkRect2D callocStack() {
        return VkRect2D.callocStack(MemoryStack.stackGet());
    }

    public static VkRect2D mallocStack(MemoryStack stack) {
        return VkRect2D.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRect2D callocStack(MemoryStack stack) {
        return VkRect2D.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkRect2D.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkRect2D.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRect2D.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRect2D.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkOffset2D noffset(long struct) {
        return VkOffset2D.create(struct + (long)OFFSET);
    }

    public static VkExtent2D nextent(long struct) {
        return VkExtent2D.create(struct + (long)EXTENT);
    }

    public static void noffset(long struct, VkOffset2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)OFFSET, VkOffset2D.SIZEOF);
    }

    public static void nextent(long struct, VkExtent2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EXTENT, VkExtent2D.SIZEOF);
    }

    static {
        Struct.Layout layout = VkRect2D.__struct(VkRect2D.__member(VkOffset2D.SIZEOF, VkOffset2D.ALIGNOF), VkRect2D.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        EXTENT = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<VkRect2D, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkRect2D newInstance(long address) {
            return new VkRect2D(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public VkOffset2D offset() {
            return VkRect2D.noffset(this.address());
        }

        public VkExtent2D extent() {
            return VkRect2D.nextent(this.address());
        }

        public Buffer offset(VkOffset2D value) {
            VkRect2D.noffset(this.address(), value);
            return this;
        }

        public Buffer extent(VkExtent2D value) {
            VkRect2D.nextent(this.address(), value);
            return this;
        }
    }
}

