/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;

public class VkSparseImageFormatProperties
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ASPECTMASK;
    public static final int IMAGEGRANULARITY;
    public static final int FLAGS;

    VkSparseImageFormatProperties(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkSparseImageFormatProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSparseImageFormatProperties.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int aspectMask() {
        return VkSparseImageFormatProperties.naspectMask(this.address());
    }

    public VkExtent3D imageGranularity() {
        return VkSparseImageFormatProperties.nimageGranularity(this.address());
    }

    public int flags() {
        return VkSparseImageFormatProperties.nflags(this.address());
    }

    public static VkSparseImageFormatProperties malloc() {
        return VkSparseImageFormatProperties.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkSparseImageFormatProperties calloc() {
        return VkSparseImageFormatProperties.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkSparseImageFormatProperties create() {
        return new VkSparseImageFormatProperties(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSparseImageFormatProperties create(long address) {
        return address == 0L ? null : new VkSparseImageFormatProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkSparseImageFormatProperties.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSparseImageFormatProperties.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkSparseImageFormatProperties mallocStack() {
        return VkSparseImageFormatProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageFormatProperties callocStack() {
        return VkSparseImageFormatProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkSparseImageFormatProperties mallocStack(MemoryStack stack) {
        return VkSparseImageFormatProperties.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseImageFormatProperties callocStack(MemoryStack stack) {
        return VkSparseImageFormatProperties.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSparseImageFormatProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSparseImageFormatProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseImageFormatProperties.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseImageFormatProperties.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int naspectMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ASPECTMASK);
    }

    public static VkExtent3D nimageGranularity(long struct) {
        return VkExtent3D.create(struct + (long)IMAGEGRANULARITY);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    static {
        Struct.Layout layout = VkSparseImageFormatProperties.__struct(VkSparseImageFormatProperties.__member(4), VkSparseImageFormatProperties.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF), VkSparseImageFormatProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ASPECTMASK = layout.offsetof(0);
        IMAGEGRANULARITY = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static final class Buffer
    extends StructBuffer<VkSparseImageFormatProperties, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSparseImageFormatProperties newInstance(long address) {
            return new VkSparseImageFormatProperties(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int aspectMask() {
            return VkSparseImageFormatProperties.naspectMask(this.address());
        }

        public VkExtent3D imageGranularity() {
            return VkSparseImageFormatProperties.nimageGranularity(this.address());
        }

        public int flags() {
            return VkSparseImageFormatProperties.nflags(this.address());
        }
    }
}

