/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.prefs.Preferences;
import opennlp.ccg.TextCCG;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.ngrams.FactoredNgramModelFamily;
import opennlp.ccg.ngrams.NgramPrecisionModel;
import opennlp.ccg.ngrams.NgramScorer;
import opennlp.ccg.ngrams.StandardNgramModel;
import opennlp.ccg.realize.Chart;
import opennlp.ccg.realize.Hypertagger;
import opennlp.ccg.realize.PruningStrategy;
import opennlp.ccg.realize.Realizer;
import opennlp.ccg.realize.hypertagger.ZLMaxentHypertagger;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.SignScorer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Realize {
    private static PrintWriter out;

    public static void main(String[] args) throws Exception {
        Element htModelElt;
        SignScorer ngramScorer;
        String usage = "Usage: java opennlp.ccg.Realize (-g <grammarfile>) (-exactmatches) (-ngramorder N) <inputfile> (<outputfile>)";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println(usage);
            System.exit(0);
        }
        String grammarfile = "grammar.xml";
        String inputfile = null;
        String outputfile = null;
        boolean exactMatches = false;
        int ngramOrder = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-D")) {
                String prop = args[i].substring(2);
                int equalpos = prop.indexOf("=");
                String key = prop.substring(0, equalpos);
                String val = prop.substring(equalpos + 1);
                System.setProperty(key, val);
                continue;
            }
            if (args[i].equals("-g")) {
                grammarfile = args[++i];
                continue;
            }
            if (args[i].equals("-exactmatches")) {
                exactMatches = true;
                continue;
            }
            if (args[i].equals("-ngramorder")) {
                ngramOrder = Integer.parseInt(args[++i]);
                continue;
            }
            if (inputfile == null) {
                inputfile = args[i];
                continue;
            }
            outputfile = args[i];
        }
        if (inputfile == null) {
            System.out.println(usage);
            System.exit(0);
        }
        out = outputfile != null ? new PrintWriter(new BufferedWriter(new FileWriter(outputfile))) : new PrintWriter(System.out);
        Preferences prefs = Preferences.userNodeForPackage(TextCCG.class);
        boolean oldShowCompleteness = prefs.getBoolean("Show Completeness", false);
        boolean oldShowBitset = prefs.getBoolean("Show Bitset", false);
        prefs.putBoolean("Show Completeness", true);
        prefs.putBoolean("Show Bitset", true);
        URL grammarURL = new File(grammarfile).toURI().toURL();
        out.println("Loading grammar from URL: " + grammarURL);
        Grammar grammar = new Grammar(grammarURL);
        Realizer realizer = new Realizer(grammar);
        out.println();
        out.println("Request:");
        out.println();
        Document doc = grammar.loadFromXml(inputfile);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        out.flush();
        outputter.output(doc, (Writer)out);
        out.flush();
        LF lf = Realizer.getLfFromDoc(doc);
        out.println();
        out.println("** Initial run");
        out.println();
        out.println("Input LF: " + lf);
        Element root = doc.getRootElement();
        Element ngramModelElt = root.getChild("ngram-model");
        if (ngramModelElt == null) {
            List targetElts = root.getChildren("target");
            String[] targets = new String[targetElts.size()];
            out.println();
            out.println("Targets:");
            for (int i = 0; i < targetElts.size(); ++i) {
                Element ex = (Element)targetElts.get(i);
                String target = ex.getText();
                out.println(target);
                targets[i] = target;
            }
            if (ngramOrder > 0) {
                out.println();
                out.println("Using order " + ngramOrder + " in n-gram precision.");
                ngramScorer = new NgramPrecisionModel(targets, ngramOrder);
            } else {
                ngramScorer = new NgramPrecisionModel(targets);
            }
            if (exactMatches) {
                out.println();
                out.println("Only counting exact matches in n-gram precision.");
                ((NgramPrecisionModel)ngramScorer).setExactMatches(exactMatches);
            }
        } else if (ngramModelElt.getAttributeValue("class") != null) {
            String scorerClass = ngramModelElt.getAttributeValue("class");
            out.println();
            out.println("Instantiating scorer from class: " + scorerClass);
            ngramScorer = (SignScorer)Class.forName(scorerClass).newInstance();
        } else {
            String filename = ngramModelElt.getAttributeValue("file");
            String reverseStr = ngramModelElt.getAttributeValue("reverse");
            boolean reverse = reverseStr != null ? reverseStr.equals("true") : false;
            String factoredStr = ngramModelElt.getAttributeValue("factored");
            boolean factored = factoredStr != null ? factoredStr.equals("true") : false;
            String semClassesStr = ngramModelElt.getAttributeValue("sem-classes");
            boolean useSemClasses = semClassesStr != null ? semClassesStr.equals("true") : true;
            int order = 3;
            String orderStr = ngramModelElt.getAttributeValue("order");
            if (orderStr != null) {
                order = Integer.parseInt(orderStr);
            }
            if (ngramOrder > 0) {
                order = ngramOrder;
            }
            out.println();
            String msg = "Loading ";
            if (reverse) {
                msg = msg + "reversed ";
            }
            if (factored) {
                msg = msg + "factored ";
            }
            msg = msg + "n-gram model ";
            if (!factored) {
                msg = msg + "of order " + order + " ";
            }
            if (useSemClasses) {
                msg = msg + "with semantic class replacement ";
            }
            msg = msg + "from: " + filename;
            out.println(msg);
            ngramScorer = factored ? new FactoredNgramModelFamily(filename, useSemClasses) : new StandardNgramModel(order, filename, useSemClasses);
            if (reverse) {
                ((NgramScorer)ngramScorer).setReverse(true);
            }
        }
        Element pruningStrategyElt = root.getChild("pruning-strategy");
        if (pruningStrategyElt != null) {
            String pruningStrategyClass = pruningStrategyElt.getAttributeValue("class");
            out.println();
            out.println("Instantiating pruning strategy from class: " + pruningStrategyClass);
            realizer.pruningStrategy = (PruningStrategy)Class.forName(pruningStrategyClass).newInstance();
        }
        if ((htModelElt = root.getChild("ht-model")) != null) {
            String htconfig = htModelElt.getAttributeValue("config");
            if (htconfig != null) {
                out.println();
                out.println("Instantiating hypertagger from: " + htconfig);
                realizer.hypertagger = ZLMaxentHypertagger.ZLMaxentHypertaggerFactory(htconfig);
            } else {
                String htModelClass = htModelElt.getAttributeValue("class");
                out.println();
                out.println("Instantiating hypertagger from class: " + htModelClass);
                realizer.hypertagger = (Hypertagger)Class.forName(htModelClass).newInstance();
            }
        }
        realizer.realize(lf, ngramScorer);
        Chart chart = realizer.getChart();
        chart.out = out;
        out.println();
        out.println("Preds:");
        chart.printEPs();
        out.println();
        out.println("LF chunks:");
        chart.printLfChunks();
        out.println();
        out.println("LF alts:");
        chart.printLfAlts();
        out.println();
        out.println("LF optional parts:");
        chart.printLfOpts();
        out.println();
        out.println("Initial Edges:");
        chart.printInitialEdges();
        out.println();
        out.println("Marked Edges:");
        chart.printMarkedEdges();
        out.println();
        out.println("Instantiated Semantically Null Edges:");
        chart.printInstantiatedNoSemEdges();
        out.println();
        out.println("Uninstantiated Semantically Null Edges:");
        chart.printNoSemEdges();
        out.println();
        out.println("Rule Instances:");
        chart.printRuleInstances();
        out.println();
        out.println("All Edges:");
        chart.printEdges();
        out.println();
        out.println("Complete Edges (unsorted):");
        chart.printEdges(true);
        out.println();
        out.println("Complete Edges (sorted):");
        chart.printEdges(true, true);
        out.println();
        out.println("Best Edge:");
        chart.printBestEdge();
        out.println();
        out.println("Best Edge Derivation:");
        out.println(chart.bestEdge.getSign().getDerivationHistory());
        out.flush();
        if (chart.bestJoinedEdge != null) {
            out.println();
            out.println("Best Joined Edge:");
            chart.printBestJoinedEdge();
            out.println();
            out.println("Best Joined Edge Derivation:");
            out.println(chart.bestJoinedEdge.getSign().getDerivationHistory());
            out.flush();
        }
        prefs.putBoolean("Show Completeness", oldShowCompleteness);
        prefs.putBoolean("Show Bitset", oldShowBitset);
    }
}

