/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.alignment;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import opennlp.ccg.alignment.Alignments;
import opennlp.ccg.alignment.Mapping;
import opennlp.ccg.alignment.Phrase;
import opennlp.ccg.alignment.PhrasePosition;
import opennlp.ccg.util.DelegatedFilter;
import opennlp.ccg.util.Filter;
import opennlp.ccg.util.FilteredSet;
import opennlp.ccg.util.VisitedFilter;

public class Alignment
extends AbstractSet<Mapping>
implements Comparable<Alignment> {
    final Phrase a;
    final Phrase b;
    final Set<Mapping> mappings;

    public Alignment(Phrase a, Phrase b, Collection<? extends Mapping> mappings) {
        this.checkPhrases(a, b);
        if (mappings == null) {
            throw new IllegalArgumentException("mappings is null");
        }
        this.a = a;
        this.b = b;
        for (Mapping mapping : mappings) {
            this.checkMapping(mapping);
        }
        this.mappings = new LinkedHashSet<Mapping>(mappings);
    }

    public static Alignment fromMap(Phrase a, Phrase b, Map<Integer, Set<Integer>> map) {
        Set ms = map.isEmpty() ? Collections.EMPTY_SET : new LinkedHashSet();
        for (Integer k : map.keySet()) {
            for (Integer v : map.get(k)) {
                ms.add(new Mapping(a.getNumber(), k, v));
            }
        }
        return new Alignment(a, b, ms);
    }

    public Alignment reverse() {
        Alignment r = new Alignment(this.getB(), this.getA(), Collections.EMPTY_SET);
        for (Mapping m : this.mappings) {
            r.add(m.reverse());
        }
        return r;
    }

    public Integer getNumber() {
        return this.a.number;
    }

    public Phrase getA() {
        return this.get(PhrasePosition.A);
    }

    public Phrase getB() {
        return this.get(PhrasePosition.B);
    }

    public Phrase get(PhrasePosition pos) {
        return pos == PhrasePosition.A ? this.a : this.b;
    }

    @Override
    public boolean add(Mapping m) {
        this.checkMapping(m);
        return this.mappings.add(m);
    }

    @Override
    public Iterator<Mapping> iterator() {
        return this.mappings.iterator();
    }

    @Override
    public int size() {
        return this.mappings.size();
    }

    @Override
    public int compareTo(Alignment o) {
        return this.getNumber().compareTo(o.getNumber());
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Alignment) {
            Alignment al = (Alignment)o;
            return super.equals(o) && this.a.equals(al.a) && this.b.equals(al.b);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 37 * super.hashCode() + this.a.hashCode() + this.b.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(PhrasePosition.A.name());
        sb.append(": ");
        sb.append(this.a.toString());
        sb.append(", ");
        sb.append(PhrasePosition.B.name());
        sb.append(": ");
        sb.append(this.b.toString());
        sb.append(", mappings: ");
        sb.append(super.toString());
        return sb.toString();
    }

    public Set<Integer> getTargets(Integer source) {
        return this.getTargets(source, PhrasePosition.A);
    }

    public Set<Integer> getTargets(Integer source, PhrasePosition sourcePosition) {
        return new LinkedHashSet<Integer>(new ValueView(source, sourcePosition));
    }

    public Set<Integer> getIndices(PhrasePosition position) {
        return new LinkedHashSet<Integer>(new KeyView(position));
    }

    public Map<Integer, Set<Integer>> asMap() {
        return this.asMap(Alignments.DEFAULT_PHRASE_POSITION);
    }

    public Map<Integer, Set<Integer>> asMap(PhrasePosition keyPosition) {
        return new LinkedHashMap<Integer, Set<Integer>>(new MapView(keyPosition));
    }

    void checkPhrases(Phrase ap, Phrase bp) {
        if (ap == null) {
            throw new IllegalArgumentException(PhrasePosition.A.name() + " phrase is null");
        }
        if (bp == null) {
            throw new IllegalArgumentException(PhrasePosition.B.name() + " phrase is null");
        }
        if (!ap.number.equals(bp.number)) {
            throw new IllegalArgumentException("phrases have different numbers");
        }
    }

    void checkMapping(Mapping m) {
        if (m == null) {
            throw new IllegalArgumentException("attempt to add null mapping");
        }
        if (m.phraseNumber != null && !m.phraseNumber.equals(this.a.number)) {
            throw new IllegalArgumentException("mapping's phrase number does not match: expected " + this.a.number + ", but was " + m.phraseNumber);
        }
        for (PhrasePosition pos : PhrasePosition.values()) {
            this.checkIndex(m.get(pos), pos);
        }
    }

    void checkIndex(Integer index, PhrasePosition intendedPosition) {
        if (index == null) {
            throw new IllegalArgumentException("attempt to add null index in position " + intendedPosition.name());
        }
        if (index < -1 || this.get(intendedPosition).size() <= index) {
            throw new IndexOutOfBoundsException(intendedPosition.name() + " index out of bounds: " + index);
        }
    }

    class ValueView
    extends IndexView {
        ValueView(final Integer key, final PhrasePosition keyPosition) {
            super(keyPosition.opposite(), new Filter<Mapping>(){

                @Override
                public boolean allows(Mapping m) {
                    return key.equals(m.get(keyPosition));
                }
            });
        }
    }

    class KeyView
    extends IndexView {
        KeyView(final PhrasePosition keyPosition) {
            super(keyPosition, (Filter<Mapping>)new DelegatedFilter<Mapping, Integer>(new VisitedFilter()){

                @Override
                public Integer delegateValueFor(Mapping e) {
                    return e.get(keyPosition);
                }
            });
        }
    }

    abstract class IndexView
    extends AbstractSet<Integer> {
        PhrasePosition indexPosition;
        Filter<Mapping> indexFilter;
        private Set<Mapping> indices;

        IndexView(PhrasePosition indexPosition, Filter<Mapping> indexFilter) {
            this.indexPosition = indexPosition;
            this.indexFilter = indexFilter;
        }

        Set<Mapping> indices() {
            return this.indices == null ? (this.indices = new FilteredSet<Mapping>(Alignment.this.mappings, this.indexFilter)) : this.indices;
        }

        @Override
        public int size() {
            return this.indices().size();
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                private Iterator<Mapping> i;
                {
                    this.i = IndexView.this.indices().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public Integer next() {
                    return this.i.next().get(IndexView.this.indexPosition);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    class MapView
    extends AbstractMap<Integer, Set<Integer>> {
        PhrasePosition keyPosition;

        MapView(PhrasePosition keyPosition) {
            this.keyPosition = keyPosition;
        }

        @Override
        public Set<Map.Entry<Integer, Set<Integer>>> entrySet() {
            return new AbstractSet<Map.Entry<Integer, Set<Integer>>>(){
                private Set<Integer> keys;
                {
                    this.keys = new KeyView(MapView.this.keyPosition);
                }

                @Override
                public int size() {
                    return this.keys.size();
                }

                @Override
                public Iterator<Map.Entry<Integer, Set<Integer>>> iterator() {
                    return new Iterator<Map.Entry<Integer, Set<Integer>>>(){
                        private Iterator<Integer> i;
                        {
                            this.i = keys.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public Map.Entry<Integer, Set<Integer>> next() {
                            Integer key = this.i.next();
                            return new AbstractMap.SimpleImmutableEntry<Integer, Set<Integer>>(key, new LinkedHashSet<Integer>(new ValueView(key, MapView.this.keyPosition)));
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }
            };
        }
    }
}

