/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.alignment;

public class MappingGroup
implements Comparable<MappingGroup> {
    Integer phraseNumber;
    int length;

    public MappingGroup(Integer phraseNumber, int length) {
        if (phraseNumber == null) {
            throw new IllegalArgumentException("phraseNumber is null");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length < 0: " + length);
        }
        this.phraseNumber = phraseNumber;
        this.length = length;
    }

    public Integer getPhraseNumber() {
        return this.phraseNumber;
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MappingGroup) {
            MappingGroup ag = (MappingGroup)obj;
            return this.phraseNumber.equals(ag.phraseNumber) && this.length == ag.length;
        }
        return false;
    }

    @Override
    public int compareTo(MappingGroup ag) {
        int i = this.phraseNumber.compareTo(ag.phraseNumber);
        if (i == 0) {
            i = this.length == ag.length ? 0 : (this.length < ag.length ? -1 : 1);
        }
        return i;
    }

    public int hashCode() {
        return 37 * (1 + this.phraseNumber + this.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Group ");
        sb.append(this.phraseNumber);
        sb.append(" (");
        sb.append(this.length);
        sb.append(" mappings)");
        return sb.toString();
    }
}

