/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.grammar;

import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import opennlp.ccg.TextCCG;
import opennlp.ccg.grammar.AbstractApplicationRule;
import opennlp.ccg.synsem.Arg;
import opennlp.ccg.synsem.ArgStack;
import opennlp.ccg.synsem.AtomCat;
import opennlp.ccg.synsem.BasicArg;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.ComplexCat;
import opennlp.ccg.synsem.SetArg;
import opennlp.ccg.synsem.Slash;
import opennlp.ccg.synsem.TargetCat;
import opennlp.ccg.unify.GSubstitution;
import opennlp.ccg.unify.GUnifier;
import opennlp.ccg.unify.ModFcn;
import opennlp.ccg.unify.Mutable;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.UnifyFailure;
import org.jdom.Element;

public abstract class AbstractCompositionRule
extends AbstractApplicationRule {
    private static final long serialVersionUID = 1L;
    public static final String EISNER_CONSTRAINTS = "Use Eisner Constraints";
    public static boolean useEisnerConstraints = AbstractCompositionRule.initEisnerConstraints();
    protected boolean _isHarmonic;
    protected Slash _argSlash;
    private static ModFcn INERTIZER_FCN = new ModFcn(){

        @Override
        public void modify(Mutable m) {
            if (m instanceof Slash) {
                ((Slash)m).setAbility("inert");
            }
        }
    };

    private static boolean initEisnerConstraints() {
        Preferences prefs = Preferences.userNodeForPackage(TextCCG.class);
        return prefs.getBoolean(EISNER_CONSTRAINTS, true);
    }

    @Override
    public Element toXml(String dir) {
        Element retval = new Element("composition");
        retval.setAttribute("dir", dir);
        retval.setAttribute("harmonic", Boolean.toString(this._isHarmonic));
        return retval;
    }

    protected boolean eisner() {
        return useEisnerConstraints && this._isHarmonic;
    }

    @Override
    protected List<Category> apply(Category xyCat, Category yzCat) throws UnifyFailure {
        if (xyCat instanceof ComplexCat && yzCat instanceof ComplexCat) {
            ArrayList<Category> results = new ArrayList<Category>(1);
            this._headCats.clear();
            ComplexCat xyCC = (ComplexCat)xyCat;
            ComplexCat yzCC = (ComplexCat)yzCat;
            Arg xyOuter = xyCC.getOuterArg();
            if (xyOuter instanceof BasicArg) {
                Slash xySlash = ((BasicArg)xyOuter).getSlash();
                xySlash.unifyCheck(this._functorSlash);
                if (this.eisner() && xySlash.isHarmonicCompositionResult()) {
                    throw new UnifyFailure();
                }
                Category xyOuterCat = ((BasicArg)xyOuter).getCat();
                if (xyOuterCat instanceof AtomCat) {
                    ArgStack zStack = yzCC.getArgStack();
                    zStack.slashesUnify(this._argSlash);
                    GSubstitution sub = new GSubstitution();
                    GUnifier.unify(xyOuterCat, yzCC.getTarget(), sub);
                    xySlash = (Slash)xySlash.fill(sub);
                    xySlash.unifyCheck(this._functorSlash);
                    Category outcome = this.createResult(xyCC.getResult(), zStack, xySlash, sub);
                    this.appendLFs(xyCat, yzCat, outcome, sub);
                    results.add(outcome);
                    this._headCats.add(xySlash.isModifier() ? yzCat : xyCat);
                } else if (xyOuterCat instanceof ComplexCat) {
                    GSubstitution sub = new GSubstitution();
                    ArgStack zStack = this.composeComplexY((ComplexCat)xyOuterCat, xySlash, yzCC, sub);
                    xySlash = (Slash)xySlash.fill(sub);
                    xySlash.unifyCheck(this._functorSlash);
                    Category outcome = this.createResult(xyCC.getResult(), zStack, xySlash, sub);
                    this.appendLFs(xyCat, yzCat, outcome, sub);
                    results.add(outcome);
                    this._headCats.add(xySlash.isModifier() ? yzCat : xyCat);
                }
            } else if (xyOuter instanceof SetArg) {
                SetArg xyOuterSet = (SetArg)xyOuter;
                TargetCat yzTarget = yzCC.getTarget();
                int targetIndex = xyOuterSet.indexOf(yzTarget);
                if (targetIndex > -1) {
                    Slash xySlash = xyOuterSet.get(targetIndex).getSlash();
                    xySlash.unifyCheck(this._functorSlash);
                    if (this.eisner() && xySlash.isHarmonicCompositionResult()) {
                        throw new UnifyFailure();
                    }
                    GSubstitution sub = new GSubstitution();
                    GUnifier.unify(xyOuterSet.getCat(targetIndex), yzTarget, sub);
                    Category result = xyCC.copy();
                    ((ComplexCat)result).setOuterArgument(xyOuterSet.copyWithout(targetIndex));
                    ArgStack zStack = yzCC.getArgStack();
                    zStack.slashesUnify(this._argSlash);
                    Category outcome = this.createResult(result, zStack, xySlash, sub);
                    this.appendLFs(xyCat, yzCat, outcome, sub);
                    results.add(outcome);
                    this._headCats.add(xySlash.isModifier() ? yzCat : xyCat);
                } else {
                    boolean success = false;
                    for (int i = 0; i < xyOuterSet.size(); ++i) {
                        BasicArg yInSet = xyOuterSet.get(i);
                        if (!(yInSet.getCat() instanceof ComplexCat)) continue;
                        Slash xySlash = yInSet.getSlash();
                        xySlash.unifyCheck(this._functorSlash);
                        if (this.eisner() && xySlash.isHarmonicCompositionResult()) {
                            throw new UnifyFailure();
                        }
                        ComplexCat yCat = (ComplexCat)yInSet.getCat();
                        GSubstitution sub = new GSubstitution();
                        ArgStack zStack = this.composeComplexY(yCat, xySlash, yzCC, sub);
                        xySlash = (Slash)xySlash.fill(sub);
                        xySlash.unifyCheck(this._functorSlash);
                        Category result = xyCC.copy();
                        ((ComplexCat)result).setOuterArgument(xyOuterSet.copyWithout(i));
                        Category outcome = this.createResult(result, zStack, xySlash, sub);
                        this.appendLFs(xyCat, yzCat, outcome, sub);
                        results.add(outcome);
                        this._headCats.add(xySlash.isModifier() ? yzCat : xyCat);
                        success = true;
                    }
                    if (!success) {
                        throw new UnifyFailure();
                    }
                }
            } else {
                throw new UnifyFailure();
            }
            return results;
        }
        throw new UnifyFailure();
    }

    private Category createResult(Category result, ArgStack zStack, Slash xySlash, Substitution sub) throws UnifyFailure {
        ((GSubstitution)sub).condense();
        result = (Category)result.fill(sub);
        ArgStack newStack = zStack.fill(sub);
        if (!(this._isHarmonic || xySlash.sameDirAsModality() && !zStack.containsContrarySlash())) {
            newStack.deepMap(INERTIZER_FCN);
        }
        newStack.get(0).setSlashModifier(false);
        if (this._isHarmonic && useEisnerConstraints) {
            newStack.setSlashHarmonicCompositionResult(true);
        }
        if (result instanceof ComplexCat) {
            ((ComplexCat)result).add(newStack);
        } else {
            result = new ComplexCat((TargetCat)result, newStack);
        }
        return result;
    }

    private ArgStack composeComplexY(ComplexCat xyOuterCC, Slash xySlash, ComplexCat yzCC, Substitution sub) throws UnifyFailure {
        GUnifier.unify(xyOuterCC.getTarget(), yzCC.getTarget(), sub);
        ArgStack zStack = yzCC.getArgStack();
        if (xyOuterCC.containsDollarArg()) {
            xyOuterCC.getArgStack().unifyPrefix(zStack, zStack.size() - 1, sub);
            zStack = zStack.subList(zStack.size() - 1);
            zStack.slashesUnify(this._argSlash);
            xySlash = (Slash)xySlash.fill(sub);
            xySlash.unifyCheck(this._functorSlash);
            return zStack;
        }
        if (xyOuterCC.arity() == 1) {
            ArgStack yzStack = yzCC.getArgStack();
            if (!(xyOuterCC.getArg(0) instanceof BasicArg)) {
                throw new UnifyFailure();
            }
            BasicArg xyOuterOuter = (BasicArg)xyOuterCC.getArg(0);
            Arg yzStackInner = yzStack.get(0);
            if (yzStackInner instanceof SetArg) {
                SetArg yzSetArg = (SetArg)yzStackInner;
                int iaIndex = yzSetArg.indexOf(xyOuterOuter);
                if (iaIndex == -1) {
                    throw new UnifyFailure();
                }
                xyOuterOuter.unify(yzSetArg.get(iaIndex), sub);
                xySlash = (Slash)xySlash.fill(sub);
                xySlash.unifyCheck(this._functorSlash);
                zStack = yzStack.copy();
                zStack.set(0, yzSetArg.copyWithout(iaIndex));
                zStack.slashesUnify(this._argSlash);
                return zStack;
            }
            if (yzStack.size() < 2) {
                throw new UnifyFailure();
            }
            xyOuterOuter.unify(yzStackInner, sub);
            zStack = yzStack.subList(1).copy();
            zStack.slashesUnify(this._argSlash);
            xySlash = (Slash)xySlash.fill(sub);
            xySlash.unifyCheck(this._functorSlash);
            return zStack;
        }
        if (xyOuterCC.arity() == 2) {
            ArgStack yzStack = yzCC.getArgStack();
            if (!(xyOuterCC.getArg(0) instanceof BasicArg) || !(xyOuterCC.getArg(1) instanceof BasicArg) || yzStack.size() < 3) {
                throw new UnifyFailure();
            }
            BasicArg xyOuterOuter1 = (BasicArg)xyOuterCC.getArg(0);
            BasicArg xyOuterOuter2 = (BasicArg)xyOuterCC.getArg(1);
            Arg yzStackInner1 = yzStack.get(0);
            Arg yzStackInner2 = yzStack.get(1);
            xyOuterOuter1.unify(yzStackInner1, sub);
            xyOuterOuter2.unify(yzStackInner2, sub);
            zStack = yzStack.subList(2).copy();
            zStack.slashesUnify(this._argSlash);
            xySlash = (Slash)xySlash.fill(sub);
            xySlash.unifyCheck(this._functorSlash);
            return zStack;
        }
        throw new UnifyFailure();
    }
}

