/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.lexicon;

import java.util.ArrayList;
import java.util.List;
import opennlp.ccg.lexicon.SimpleWord;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.lexicon.WordWithPitchAccent;
import opennlp.ccg.util.Interner;
import opennlp.ccg.util.Pair;

public class FullWord
extends WordWithPitchAccent {
    private static final long serialVersionUID = -3115687437782457735L;
    protected List<Pair<String, String>> attrValPairs;
    protected String stem;
    protected String POS;
    protected String supertag;
    protected String semClass;

    @Override
    protected List<Pair<String, String>> getAttrValPairsList() {
        return this.attrValPairs;
    }

    @Override
    public String getStem() {
        return this.stem;
    }

    @Override
    public String getPOS() {
        return this.POS;
    }

    @Override
    public String getSupertag() {
        return this.supertag;
    }

    @Override
    public String getSemClass() {
        return this.semClass;
    }

    protected FullWord(String form, String pitchAccent, List<Pair<String, String>> attrValPairs, String stem, String POS, String supertag, String semClass) {
        super(form, pitchAccent);
        this.attrValPairs = attrValPairs;
        this.stem = stem;
        this.POS = POS;
        this.supertag = supertag;
        this.semClass = semClass;
    }

    public static class Factory
    implements Word.WordFactory {
        private FullWord w = new FullWord(null, null, null, null, null, null, null);

        private void setW(String form, String pitchAccent, List<Pair<String, String>> attrValPairs, String stem, String POS, String supertag, String semClass) {
            this.w.form = form;
            this.w.pitchAccent = pitchAccent;
            this.w.attrValPairs = attrValPairs;
            this.w.stem = stem;
            this.w.POS = POS;
            this.w.supertag = supertag;
            this.w.semClass = semClass;
        }

        private Word getOrCreateFromW() {
            Word retval = (Word)Interner.getGlobalInterned(this.w);
            if (retval != null) {
                return retval;
            }
            retval = this.w.isSurfaceWord() && this.w.attrValPairs == null ? (this.w.pitchAccent == null ? new SimpleWord(this.w.form) : new WordWithPitchAccent(this.w.form, this.w.pitchAccent)) : new FullWord(this.w.form, this.w.pitchAccent, this.w.attrValPairs, this.w.stem, this.w.POS, this.w.supertag, this.w.semClass);
            return (Word)Interner.globalIntern(retval);
        }

        @Override
        public synchronized Word create(String form) {
            return this.create(form, null, null, null, null, null, null);
        }

        @Override
        public synchronized Word create(String attr, String val) {
            String form = null;
            String pitchAccent = null;
            ArrayList<Pair<String, String>> attrValPairs = null;
            String stem = null;
            String POS = null;
            String supertag = null;
            String semClass = null;
            if (attr == "W") {
                form = val;
            } else if (attr == "A") {
                pitchAccent = val;
            } else if (attr == "S") {
                stem = val;
            } else if (attr == "P") {
                POS = val;
            } else if (attr == "T") {
                supertag = val;
            } else if (attr == "C") {
                semClass = val;
            } else {
                attrValPairs = new ArrayList<Pair<String, String>>(1);
                attrValPairs.add(new Pair<String, String>(attr, val));
            }
            return this.create(form, pitchAccent, attrValPairs, stem, POS, supertag, semClass);
        }

        @Override
        public synchronized Word create(String form, String pitchAccent, List<Pair<String, String>> attrValPairs, String stem, String POS, String supertag, String semClass) {
            this.setW(form, pitchAccent, attrValPairs, stem, POS, supertag, semClass);
            return this.getOrCreateFromW();
        }
    }
}

