/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.ngrams;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.ccg.lexicon.DefaultTokenizer;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.ngrams.FactoredNgramModel;
import opennlp.ccg.ngrams.NgramScorer;
import opennlp.ccg.perceptron.Alphabet;
import opennlp.ccg.perceptron.FeatureMap;

public class FactoredNgramModelFamily
extends NgramScorer {
    public final ModelGroup primaryGroup;
    public final ModelGroup[] furtherGroups;
    public static int MAX_TOKENS_PER_LINE = 64;

    public FactoredNgramModelFamily(String filename) throws IOException {
        this(filename, true);
    }

    public FactoredNgramModelFamily(String filename, boolean useSemClasses) throws IOException {
        this.useSemClasses = useSemClasses;
        List<ModelGroup> modelGroups = this.readModel(filename);
        this.primaryGroup = modelGroups.get(0);
        if (modelGroups.size() == 1) {
            this.furtherGroups = null;
        } else {
            this.furtherGroups = new ModelGroup[modelGroups.size() - 1];
            for (int i = 1; i < modelGroups.size(); ++i) {
                this.furtherGroups[i - 1] = modelGroups.get(i);
            }
        }
        this.order = this.primaryGroup.primaryModel.order;
        this.openVocab = this.primaryGroup.primaryModel.openVocab;
    }

    @Override
    public void setReverse(boolean reverse) {
        super.setReverse(reverse);
        this.primaryGroup.setReverse(reverse);
        if (this.furtherGroups == null) {
            return;
        }
        for (int i = 0; i < this.furtherGroups.length; ++i) {
            this.furtherGroups[i].setReverse(reverse);
        }
    }

    @Override
    public void setDebug(boolean debugScore) {
        super.setDebug(debugScore);
        this.primaryGroup.setDebug(debugScore);
        if (this.furtherGroups == null) {
            return;
        }
        for (int i = 0; i < this.furtherGroups.length; ++i) {
            this.furtherGroups[i].setDebug(debugScore);
        }
    }

    @Override
    protected void shareWordsToScore(List<Word> wordsToScore) {
        this.wordsToScore = wordsToScore;
        this.primaryGroup.shareWordsToScore(wordsToScore);
        if (this.furtherGroups == null) {
            return;
        }
        for (int i = 0; i < this.furtherGroups.length; ++i) {
            this.furtherGroups[i].shareWordsToScore(wordsToScore);
        }
    }

    @Override
    public void setAlphabet(Alphabet alphabet) {
        super.setAlphabet(alphabet);
        this.primaryGroup.setAlphabet(alphabet);
        if (this.furtherGroups == null) {
            return;
        }
        for (int i = 0; i < this.furtherGroups.length; ++i) {
            this.furtherGroups[i].setAlphabet(alphabet);
        }
    }

    @Override
    protected void incNgrams(FeatureMap featmap, int i, int order) {
        Alphabet.Feature f;
        List<String> ngram = this.ngram(this.primaryGroup, i, order);
        if (ngram != null && (f = this.alphabet.index(ngram)) != null) {
            featmap.inc(f);
        }
        if (this.furtherGroups != null) {
            for (int j = 0; j < this.furtherGroups.length; ++j) {
                Alphabet.Feature f2;
                List<String> ngram2 = this.ngram(this.furtherGroups[j], i, order);
                if (ngram2 == null || (f2 = this.alphabet.index(ngram2)) == null) continue;
                featmap.inc(f2);
            }
        }
    }

    private List<String> ngram(ModelGroup modelGroup, int i, int order) {
        FactoredNgramModel modelToUse = modelGroup.primaryModel;
        if (order < modelToUse.order) {
            modelToUse = modelGroup.getModel(order);
        }
        return modelToUse.ngram(i, order);
    }

    @Override
    protected float logProbFromNgram(int i, int order) {
        float logProbTotal = 0.0f;
        logProbTotal += this.logProbFromNgram(this.primaryGroup, i, order);
        if (this.furtherGroups != null) {
            for (int j = 0; j < this.furtherGroups.length; ++j) {
                logProbTotal += this.logProbFromNgram(this.furtherGroups[j], i, order);
            }
        }
        return logProbTotal;
    }

    private float logProbFromNgram(ModelGroup modelGroup, int i, int order) {
        FactoredNgramModel modelToUse = modelGroup.primaryModel;
        if (order < modelToUse.order) {
            modelToUse = modelGroup.getModel(order);
            if (this.debugScore && modelToUse != modelGroup.primaryModel) {
                int modelNum = Arrays.asList(modelGroup.secondaryModels).indexOf(modelToUse);
                System.out.print("[2ndary model " + modelNum + "] ");
            }
        }
        return modelToUse.logProbFromNgram(i, order);
    }

    private List<ModelGroup> readModel(String filename) throws IOException {
        File infile = new File(filename);
        BufferedReader in = new BufferedReader(new FileReader(infile));
        StreamTokenizer tokenizer = FactoredNgramModelFamily.initTokenizer(in);
        String[] tokens = new String[MAX_TOKENS_PER_LINE];
        FactoredNgramModel[] models = null;
        int numModels = -1;
        int currentModel = 0;
        while (tokenizer.ttype != -1) {
            FactoredNgramModelFamily.readLine(tokenizer, tokens);
            if (tokens[0] == null || tokens[0].charAt(0) == '#') continue;
            if (numModels < 0) {
                numModels = Integer.parseInt(tokens[0]);
                models = new FactoredNgramModel[numModels];
                continue;
            }
            if (currentModel >= numModels) break;
            if (tokens[1] == null || !tokens[1].equals(":")) continue;
            String child = tokens[0];
            int numParents = Integer.parseInt(tokens[2]);
            String[] parents = new String[numParents];
            for (int i = 0; i < numParents; ++i) {
                parents[i] = tokens[i + 3];
            }
            String lmfn = tokens[numParents + 4];
            File lmfile = new File(infile.getParentFile(), lmfn);
            lmfn = lmfile.getPath();
            models[currentModel] = new FactoredNgramModel(child, parents, lmfn, this.useSemClasses);
            models[currentModel].shareWordsToScore(this.wordsToScore);
            ++currentModel;
        }
        if (models == null) {
            throw new IOException("No models found in: " + filename);
        }
        int actualNumModels = 0;
        for (int i = 0; i < numModels; ++i) {
            if (models[i] == null) continue;
            ++actualNumModels;
        }
        if (actualNumModels != numModels) {
            System.err.println("Warning: Only found " + actualNumModels + "/" + numModels + " in " + filename);
            numModels = actualNumModels;
        }
        ArrayList<ModelGroup> modelGroups = new ArrayList<ModelGroup>();
        int modelIndex = 0;
        while (modelIndex < numModels) {
            FactoredNgramModel primaryModel = models[modelIndex];
            String childName = primaryModel.child.name;
            ++modelIndex;
            ArrayList<FactoredNgramModel> secondaryModelsList = new ArrayList<FactoredNgramModel>();
            while (modelIndex < numModels && models[modelIndex].child.name == childName) {
                secondaryModelsList.add(models[modelIndex]);
                ++modelIndex;
            }
            FactoredNgramModel[] secondaryModels = new FactoredNgramModel[secondaryModelsList.size()];
            secondaryModelsList.toArray(secondaryModels);
            modelGroups.add(new ModelGroup(primaryModel, secondaryModels));
        }
        return modelGroups;
    }

    public static void main(String[] args) throws IOException {
        String usage = "Usage: java opennlp.ccg.ngrams.FactoredNgramModelFamily <specfile> <tokens>";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println(usage);
            System.exit(0);
        }
        String specfile = args[0];
        String tokens = args[1];
        System.out.println("Loading n-gram model family from: " + specfile);
        FactoredNgramModelFamily lmFamily = new FactoredNgramModelFamily(specfile);
        System.out.println("primary child var: " + lmFamily.primaryGroup.childName);
        if (lmFamily.furtherGroups != null) {
            for (int i = 0; i < lmFamily.furtherGroups.length; ++i) {
                System.out.println("further child var: " + lmFamily.furtherGroups[i].childName);
            }
        }
        System.out.println("order: " + lmFamily.order);
        System.out.println("openVocab: " + lmFamily.openVocab);
        System.out.println();
        DefaultTokenizer tokenizer = new DefaultTokenizer();
        List<Word> words = tokenizer.tokenize(tokens, true);
        System.out.println("scoring: ");
        for (int i = 0; i < words.size(); ++i) {
            System.out.println(words.get(i).toString());
        }
        System.out.println();
        lmFamily.setDebug(true);
        lmFamily.setWordsToScore(words, true);
        lmFamily.prepareToScoreWords();
        double logprob = lmFamily.logprob();
        double score = FactoredNgramModelFamily.convertToProb(logprob);
        System.out.println("score: " + score);
        System.out.println("logprob: " + logprob);
        System.out.println("ppl: " + NgramScorer.convertToPPL(logprob / (double)(words.size() - 1)));
    }

    public class ModelGroup {
        public final String childName;
        public final FactoredNgramModel primaryModel;
        public final FactoredNgramModel[] secondaryModels;

        public ModelGroup(FactoredNgramModel primaryModel, FactoredNgramModel[] secondaryModels) {
            this.childName = primaryModel.child.name;
            this.primaryModel = primaryModel;
            this.secondaryModels = secondaryModels;
        }

        public FactoredNgramModel getModel(int order) {
            if (this.secondaryModels == null) {
                return this.primaryModel;
            }
            for (int i = 0; i < this.secondaryModels.length; ++i) {
                if (this.secondaryModels[i].order != order) continue;
                return this.secondaryModels[i];
            }
            return this.primaryModel;
        }

        public void setReverse(boolean reverse) {
            this.primaryModel.setReverse(reverse);
            if (this.secondaryModels == null) {
                return;
            }
            for (int i = 0; i < this.secondaryModels.length; ++i) {
                this.secondaryModels[i].setReverse(reverse);
            }
        }

        public void setDebug(boolean debugScore) {
            this.primaryModel.setDebug(debugScore);
            if (this.secondaryModels == null) {
                return;
            }
            for (int i = 0; i < this.secondaryModels.length; ++i) {
                this.secondaryModels[i].setDebug(debugScore);
            }
        }

        protected void shareWordsToScore(List<Word> wordsToScore) {
            this.primaryModel.shareWordsToScore(wordsToScore);
            if (this.secondaryModels == null) {
                return;
            }
            for (int i = 0; i < this.secondaryModels.length; ++i) {
                this.secondaryModels[i].shareWordsToScore(wordsToScore);
            }
        }

        public void setAlphabet(Alphabet alphabet) {
            this.primaryModel.setAlphabet(alphabet);
            if (this.secondaryModels == null) {
                return;
            }
            for (int i = 0; i < this.secondaryModels.length; ++i) {
                this.secondaryModels[i].setAlphabet(alphabet);
            }
        }
    }
}

