/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.ngrams;

import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.ngrams.NgramFilter;
import opennlp.ccg.ngrams.NgramScorer;
import opennlp.ccg.ngrams.SelfParaphraseBiaser;
import opennlp.ccg.perceptron.FeatureVector;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.util.ArrayListWithIdentityEquals;
import opennlp.ccg.util.Interner;
import opennlp.ccg.util.SingletonList;
import opennlp.ccg.util.StructureSharingList;

public class NgramPrecisionModel
extends NgramScorer
implements SelfParaphraseBiaser {
    private Set<List<Word>> targetNgrams = new THashSet();
    private double[] weights = null;
    private boolean exactMatches = false;
    protected List<Word> reducedWords = new ArrayList<Word>();
    protected List<Word> wordList = new ArrayListWithIdentityEquals<Word>();

    public NgramPrecisionModel() {
        this(new String[0], false);
    }

    public NgramPrecisionModel(String[] targets) {
        this(targets, false);
    }

    public NgramPrecisionModel(String[] targets, int order) {
        this(targets, order, false);
    }

    public NgramPrecisionModel(String[] targets, boolean useSemClasses) {
        this(targets, 4, useSemClasses);
    }

    public NgramPrecisionModel(String[] targets, int order, boolean useSemClasses) {
        this(targets, order, useSemClasses, NgramPrecisionModel.rankOrderCentroidWeights(order));
    }

    public NgramPrecisionModel(String[] targets, int order, boolean useSemClasses, double[] weights) {
        this.useSemClasses = useSemClasses;
        this.order = order;
        this.weights = new double[order];
        for (int i = 0; i < order; ++i) {
            this.weights[order - (i + 1)] = weights[i];
        }
        this.initTargetNgrams(targets);
    }

    public void setExactMatches(boolean exactMatches) {
        this.exactMatches = exactMatches;
    }

    public boolean getExactMatches() {
        return this.exactMatches;
    }

    @Override
    protected void prepareToScoreWords() {
        this.reducedWords.clear();
        for (int i = 0; i < this.wordsToScore.size(); ++i) {
            Word w = (Word)this.wordsToScore.get(i);
            this.reducedWords.add(this.reduceWord(w));
        }
    }

    protected Word reduceWord(Word w) {
        if (this.useSemClasses && this.isReplacementSemClass(w.getSemClass())) {
            return Word.createSurfaceWordUsingSemClass(w);
        }
        return Word.createSurfaceWord(w);
    }

    @Override
    public synchronized double score(Sign sign, boolean complete) {
        List<Word> words = sign.getWords();
        if (words == null) {
            return 0.0;
        }
        this.signToScore = sign;
        this.setWordsToScore(words, complete);
        if (this.ngramFilters != null) {
            for (int i = 0; i < this.ngramFilters.size(); ++i) {
                NgramFilter filter = (NgramFilter)this.ngramFilters.get(i);
                if (!filter.filterOut(this.wordsToScore)) continue;
                return 0.0;
            }
        }
        this.prepareToScoreWords();
        double retval = 0.0;
        for (int i = 0; i < this.order; ++i) {
            retval += this.weights[i] * this.ngramPrecision(i + 1);
        }
        this.signToScore = null;
        int numWords = this.wordsToScore.size();
        if (numWords < this.order) {
            double max = 0.0;
            for (int i = 0; i < numWords; ++i) {
                max += this.weights[i];
            }
            retval /= max;
        }
        return retval;
    }

    @Override
    public FeatureVector extractFeatures(Sign sign, boolean complete) {
        return this.extractFeatureMap(sign, complete);
    }

    @Override
    protected float logProbFromNgram(int i, int order) {
        throw new UnsupportedOperationException();
    }

    private double ngramPrecision(int order) {
        int numWords = this.reducedWords.size();
        int numNgrams = numWords - (order - 1);
        if (numNgrams <= 0) {
            return 0.0;
        }
        int matches = 0;
        for (int i = 0; i < numNgrams; ++i) {
            this.setNgram(this.reducedWords, i, order);
            if (!this.targetNgrams.contains(this.wordList)) continue;
            ++matches;
        }
        if (this.exactMatches) {
            return matches == numNgrams ? 1.0 : 0.0;
        }
        return (double)matches * 1.0 / (double)numNgrams;
    }

    protected synchronized void setNgram(List<Word> words, int i, int order) {
        this.wordList.clear();
        for (int j = 0; j < order; ++j) {
            this.wordList.add(words.get(i + j));
        }
    }

    @Override
    protected boolean setKeysToNgram(int i, int order) {
        this.keysList.clear();
        for (int j = 0; j < order; ++j) {
            this.keysList.add(this.reducedWords.get(i + j).getForm());
        }
        return true;
    }

    protected List<Word> makeNgram(List<Word> words, int i, int order) {
        this.setNgram(words, i, order);
        List alreadyInterned = (List)Interner.getGlobalInterned(this.wordList);
        if (alreadyInterned != null) {
            return alreadyInterned;
        }
        if (order == 1) {
            return (List)Interner.globalIntern(new SingletonList<Word>(words.get(i)));
        }
        List<Word> firstOneList = this.makeNgram(words, i, 1);
        List<Word> suffixList = this.makeNgram(words, i + 1, order - 1);
        return (List)Interner.globalIntern(new StructureSharingList<Word>(firstOneList, suffixList));
    }

    private void initTargetNgrams(String[] targets) {
        for (int j = 0; j < targets.length; ++j) {
            if (targets[j].length() == 0) continue;
            List<Word> words = this.useSemClasses ? Grammar.theGrammar.getParsedWords(targets[j]) : Grammar.theGrammar.lexicon.tokenizer.tokenize(targets[j]);
            this.setWordsToScore(words, true);
            int numWords = this.wordsToScore.size();
            for (int i = 0; i < numWords; ++i) {
                Word w = (Word)this.wordsToScore.get(i);
                this.wordsToScore.set(i, this.reduceWord(w));
            }
            for (int k = 0; k < this.order; ++k) {
                for (int i = 0; i < numWords - k; ++i) {
                    this.targetNgrams.add(this.makeNgram(this.wordsToScore, i, k + 1));
                }
            }
        }
    }

    @Override
    public void setTargets(String[] targets) {
        this.targetNgrams = new THashSet();
        this.initTargetNgrams(targets);
    }
}

