/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.ngrams;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.lexicon.DefaultTokenizer;
import opennlp.ccg.lexicon.Tokenizer;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.ngrams.NgramFilter;
import opennlp.ccg.ngrams.Reversible;
import opennlp.ccg.perceptron.Alphabet;
import opennlp.ccg.perceptron.ComposedFeatureVector;
import opennlp.ccg.perceptron.FeatureExtractor;
import opennlp.ccg.perceptron.FeatureList;
import opennlp.ccg.perceptron.FeatureMap;
import opennlp.ccg.perceptron.FeatureVector;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.synsem.SignScorer;
import opennlp.ccg.util.TrieMap;

public abstract class NgramScorer
implements SignScorer,
Reversible,
FeatureExtractor {
    protected int order;
    protected boolean reverse = false;
    protected TrieMap<Object, NgramFloats> trieMapRoot = new TrieMap(null);
    protected int[] numNgrams = null;
    protected boolean openVocab = false;
    protected boolean debugScore = false;
    protected List<NgramFilter> ngramFilters = null;
    protected Alphabet alphabet = null;
    protected Map<List<Word>, Float> cachedLogProbs = null;
    protected Sign signToScore = null;
    protected List<Word> wordsToScore = new ArrayList<Word>();
    protected boolean tagsAdded = false;
    protected List<Object> keysList = new ArrayList<Object>();
    protected List<String> featureKeysList = new ArrayList<String>();
    protected boolean useNgramFeatures = true;
    protected boolean useSemClasses = false;
    private Tokenizer tokenizer = null;

    protected NgramScorer() {
    }

    protected NgramScorer(int order) {
        this(order, false);
    }

    protected NgramScorer(int order, boolean useSemClasses) {
        this.order = order;
        this.useSemClasses = useSemClasses;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public boolean getReverse() {
        return this.reverse;
    }

    @Override
    public void setReverse(boolean reverse) {
        this.reverse = reverse;
        if (this.ngramFilters != null) {
            for (int i = 0; i < this.ngramFilters.size(); ++i) {
                NgramFilter filter = this.ngramFilters.get(i);
                if (!(filter instanceof Reversible)) continue;
                ((Reversible)((Object)filter)).setReverse(reverse);
            }
        }
    }

    public void setDebug(boolean debugScore) {
        this.debugScore = debugScore;
    }

    public void addFilter(NgramFilter filter) {
        if (this.ngramFilters == null) {
            this.ngramFilters = new ArrayList<NgramFilter>();
        }
        this.ngramFilters.add(filter);
    }

    @Override
    public void setAlphabet(Alphabet alphabet) {
        this.alphabet = alphabet;
    }

    protected Float getCachedLogProb(List<Word> words) {
        if (this.cachedLogProbs == null) {
            return null;
        }
        return this.cachedLogProbs.get(words);
    }

    protected void putCachedLogProb(List<Word> words, Float logprob) {
        if (this.cachedLogProbs == null) {
            this.cachedLogProbs = new WeakHashMap<List<Word>, Float>();
        }
        this.cachedLogProbs.put(words, logprob);
    }

    @Override
    public synchronized double score(Sign sign, boolean complete) {
        return NgramScorer.convertToProb(this.logprob(sign, complete));
    }

    public synchronized double logprob(Sign sign, boolean complete) {
        Float logprob;
        List<Word> words = sign.getWords();
        if (words == null) {
            return 0.0;
        }
        if (!complete && (logprob = this.getCachedLogProb(words)) != null) {
            return logprob.floatValue();
        }
        this.signToScore = sign;
        this.setWordsToScore(words, complete);
        if (this.ngramFilters != null) {
            for (int i = 0; i < this.ngramFilters.size(); ++i) {
                NgramFilter filter = this.ngramFilters.get(i);
                if (!filter.filterOut(this.wordsToScore)) continue;
                return NgramScorer.convertToLogProb(0.0);
            }
        }
        this.prepareToScoreWords();
        double retval = this.logprob();
        this.signToScore = null;
        return retval;
    }

    public synchronized double score(List<Word> words) {
        return NgramScorer.convertToProb(this.logprob(words));
    }

    public synchronized double logprob(List<Word> words) {
        this.setWordsToScore(words, false);
        this.prepareToScoreWords();
        return this.logprob();
    }

    protected void shareWordsToScore(List<Word> wordsToScore) {
        this.wordsToScore = wordsToScore;
    }

    protected void setWordsToScore(List<Word> words, boolean complete) {
        this.wordsToScore.clear();
        this.tagsAdded = false;
        if (complete && (this.reverse || words.get(0).getForm() != "<s>")) {
            this.wordsToScore.add(Word.createWord("<s>"));
            this.tagsAdded = true;
        }
        if (this.reverse) {
            for (int j = words.size() - 1; j >= 0; --j) {
                Word w = words.get(j);
                if (w.getForm() == "<s>" || w.getForm() == "</s>") continue;
                this.wordsToScore.add(w);
            }
        } else {
            this.wordsToScore.addAll(words);
        }
        if (complete && (this.reverse || words.get(words.size() - 1).getForm() != "</s>")) {
            this.wordsToScore.add(Word.createWord("</s>"));
            this.tagsAdded = true;
        }
    }

    protected void prepareToScoreWords() {
    }

    public FeatureMap extractFeatureMap(Sign sign, boolean complete) {
        FeatureMap featmap = new FeatureMap();
        List<Word> words = sign.getWords();
        if (words == null) {
            return featmap;
        }
        this.signToScore = sign;
        this.setWordsToScore(words, complete);
        this.prepareToScoreWords();
        int numWords = this.wordsToScore.size();
        for (int k = 1; k <= this.order; ++k) {
            int numNgrams = numWords - (k - 1);
            if (numNgrams <= 0) continue;
            for (int i = 0; i < numNgrams; ++i) {
                this.incNgrams(featmap, i, k);
            }
        }
        this.signToScore = null;
        return featmap;
    }

    public FeatureVector extractLogProbs(Sign sign, boolean complete) {
        FeatureList retval = new FeatureList(1);
        Alphabet.Feature f = this.alphabet.index("$ngram");
        if (f != null) {
            retval.add(f, Float.valueOf((float)this.logprob(sign, complete)));
        }
        return retval;
    }

    @Override
    public FeatureVector extractFeatures(Sign sign, boolean complete) {
        FeatureVector logprob = this.extractLogProbs(sign, complete);
        if (this.useNgramFeatures) {
            FeatureMap map = this.extractFeatureMap(sign, complete);
            return new ComposedFeatureVector(logprob, map);
        }
        return logprob;
    }

    protected void incNgrams(FeatureMap featmap, int i, int order) {
        List<String> ngram = this.ngram(i, order);
        if (ngram == null) {
            return;
        }
        Alphabet.Feature f = this.alphabet.index(ngram);
        if (f != null) {
            featmap.inc(f);
        }
    }

    protected List<String> ngram(int i, int order) {
        boolean ok = this.setKeysToNgram(i, order);
        if (!ok) {
            return null;
        }
        this.featureKeysList.clear();
        for (int j = 0; j < this.keysList.size(); ++j) {
            Object key = this.keysList.get(j);
            if (!(key instanceof String)) {
                throw new RuntimeException("Feature keys must be strings!");
            }
            this.featureKeysList.add((String)key);
        }
        return this.featureKeysList;
    }

    protected double logprob() {
        Sign initialSign;
        List<Word> initialWords;
        Float logprob;
        Sign[] inputs;
        float logProbTotal = 0.0f;
        int numCached = 0;
        if (!this.tagsAdded && this.signToScore != null && (inputs = this.signToScore.getDerivationHistory().getInputs()) != null && (logprob = this.getCachedLogProb(initialWords = (initialSign = !this.reverse ? inputs[0] : inputs[inputs.length - 1]).getWords())) != null) {
            logProbTotal = logprob.floatValue();
            numCached = initialWords.size();
        }
        for (int i = numCached; i < this.wordsToScore.size(); ++i) {
            int orderToUse = Math.min(this.order, i + 1);
            int startPos = i - (orderToUse - 1);
            logProbTotal += this.logProbFromNgram(startPos, orderToUse);
        }
        if (!this.tagsAdded && this.signToScore != null) {
            this.putCachedLogProb(this.signToScore.getWords(), new Float(logProbTotal));
        }
        return logProbTotal;
    }

    protected abstract float logProbFromNgram(int var1, int var2);

    protected boolean setKeysToNgram(int i, int order) {
        float logprob = this.logProbFromNgram(i, order);
        return logprob != 0.0f;
    }

    public void setNgramFeatures(boolean useNgramFeatures) {
        this.useNgramFeatures = useNgramFeatures;
    }

    private Tokenizer getTokenizer() {
        if (this.tokenizer != null) {
            return this.tokenizer;
        }
        this.tokenizer = Grammar.theGrammar != null ? Grammar.theGrammar.lexicon.tokenizer : new DefaultTokenizer();
        return this.tokenizer;
    }

    protected boolean isReplacementSemClass(String semClass) {
        return semClass != null && this.getTokenizer().isReplacementSemClass(semClass);
    }

    protected String semClassReplacement(Word w) {
        String semClass;
        if (this.useSemClasses && this.isReplacementSemClass(semClass = w.getSemClass())) {
            return semClass.toUpperCase().intern();
        }
        return null;
    }

    protected void addTrieMapChildren(List<Object> prefix, List<Object> keys, List<TrieMap<Object, NgramFloats>> children) {
        if (!keys.isEmpty()) {
            TrieMap<Object, NgramFloats> prefixNode = this.trieMapRoot.findChildFromList(prefix);
            prefixNode.addChildren(keys, children);
        }
        prefix.clear();
        keys.clear();
        children.clear();
    }

    protected TrieMap<Object, NgramFloats> getNode(int pos, int len) {
        return this.trieMapRoot.getChildFromList(this.keysList.subList(pos, pos + len));
    }

    protected float logProb(int pos, int len) {
        TrieMap<Object, NgramFloats> node = this.getNode(pos, len);
        if (node != null && node.data != null) {
            return ((NgramFloats)node.data).logprob;
        }
        if (len == 1) {
            return -99.0f;
        }
        float retval = this.logProb(pos + 1, len - 1);
        if (this.debugScore) {
            System.out.print("(" + (len - 1) + "-gram: " + retval + ") ");
        }
        if (retval > -99.0f) {
            retval += this.backoffWeight(pos, len - 1);
        }
        return retval;
    }

    protected float backoffWeight(int pos, int len) {
        TrieMap<Object, NgramFloats> node = this.getNode(pos, len);
        if (node != null && node.data != null) {
            float retval = ((NgramFloats)node.data).bow;
            return retval;
        }
        return 0.0f;
    }

    public static double[] rankOrderCentroidWeights(int length) {
        double[] retval = new double[length];
        for (int i = 0; i < length; ++i) {
            double weight_i = 0.0;
            for (int j = i; j < length; ++j) {
                weight_i += 1.0 / (double)(j + 1);
            }
            retval[i] = weight_i /= (double)length;
        }
        return retval;
    }

    public static double convertToProb(double logProb) {
        if (logProb <= -99.0) {
            return 0.0;
        }
        return Math.pow(10.0, logProb);
    }

    public static double convertToLogProb(double prob) {
        if (prob == 0.0) {
            return -99.0;
        }
        return Math.log(prob) / Math.log(10.0);
    }

    public static double convertToPPL(double logProb) {
        return Math.exp(-logProb * Math.log(10.0));
    }

    protected static StreamTokenizer initTokenizer(Reader in) {
        StreamTokenizer tokenizer = new StreamTokenizer(in);
        tokenizer.resetSyntax();
        tokenizer.wordChars(0, 255);
        tokenizer.whitespaceChars(32, 32);
        tokenizer.whitespaceChars(9, 9);
        tokenizer.whitespaceChars(10, 10);
        tokenizer.whitespaceChars(13, 13);
        tokenizer.eolIsSignificant(true);
        return tokenizer;
    }

    protected static void readLine(StreamTokenizer tokenizer, String[] tokens) throws IOException {
        int ttype;
        int index = 0;
        while ((ttype = tokenizer.nextToken()) != -1 && ttype != 10) {
            if (index >= tokens.length || ttype != -3) continue;
            tokens[index] = tokenizer.sval;
            ++index;
        }
        for (int i = index; i < tokens.length; ++i) {
            tokens[i] = null;
        }
    }

    public static class NgramFloats {
        public float logprob;
        public float bow;

        public NgramFloats(float logprob, float bow) {
            this.logprob = logprob;
            this.bow = bow;
        }

        public String toString() {
            return "logprob: " + this.logprob + ", bow: " + this.bow;
        }
    }
}

