/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.supertagger.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import opennlp.ccg.parse.supertagger.util.STTaggerDictionary;
import opennlp.ccg.util.Pair;

public class STTaggerWordDictionary
implements STTaggerDictionary,
Serializable {
    private static final long serialVersionUID = -2474606825228545547L;
    private Map<String, Pair<Integer, Collection<String>>> dict = null;

    public STTaggerWordDictionary(Map<String, Pair<Integer, Collection<String>>> dict) {
        this.dict = dict;
    }

    @Override
    public Collection<String> getEntry(String word) {
        return this.getEntry(word, 1);
    }

    public Collection<String> getEntry(String word, int freq) {
        if (word == null) {
            return null;
        }
        Pair<Integer, Collection<String>> o = this.dict.get(word);
        if (o == null) {
            return null;
        }
        Pair<Integer, Collection<String>> p = o;
        int wfreq = (Integer)p.a;
        if (wfreq >= freq) {
            return (Collection)p.b;
        }
        return null;
    }

    @Override
    public boolean containsEntry(String word) {
        return this.dict.containsKey(word);
    }

    public Iterator<Pair<String, Pair<Integer, Collection<String>>>> getMappings() {
        Iterator<String> keyset = this.dict.keySet().iterator();
        ArrayList<Pair<String, Pair<Integer, Collection<String>>>> preRes = new ArrayList<Pair<String, Pair<Integer, Collection<String>>>>();
        String tempS = null;
        while (keyset.hasNext()) {
            tempS = keyset.next();
            preRes.add(new Pair<String, Pair<Integer, Collection<String>>>(tempS, this.dict.get(tempS)));
        }
        return preRes.iterator();
    }

    public int getCount(String word) {
        Pair<Integer, Collection<String>> o = this.dict.get(word);
        if (o == null) {
            return 0;
        }
        Pair<Integer, Collection<String>> p = o;
        return (Integer)p.a;
    }
}

