/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.tagger.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.util.Pair;

public class ResultSink {
    private int totalTags = 0;
    private int totalWords = 0;
    private int totalRight = 0;
    private Map<String, Integer> posToRight = new HashMap<String, Integer>();
    private Map<String, Integer> posTot = new HashMap<String, Integer>();
    private int sentNum = 0;
    private int sentsCorrect = 0;
    private boolean allCorrect = true;
    private ResultSinkType whatType;
    private Map<String, Integer> genPOSToRight = new HashMap<String, Integer>();
    private Map<String, Integer> genPOSTot = new HashMap<String, Integer>();

    public ResultSink() {
        this(ResultSinkType.SUPERTAG);
    }

    public ResultSink(ResultSinkType whatType) {
        this.whatType = whatType;
    }

    public void addSent(List<List<Pair<Double, String>>> sent, List<Word> goldTagging) {
        ++this.sentNum;
        this.allCorrect = true;
        Iterator<Word> gold = goldTagging.iterator();
        for (List<Pair<Double, String>> tgging : sent) {
            this.addResult(tgging, gold.next());
        }
        if (this.allCorrect) {
            ++this.sentsCorrect;
        }
    }

    public void addResult(List<Pair<Double, String>> tagging, Word goldTagging) {
        String goldTag = this.whatType == ResultSinkType.SUPERTAG ? goldTagging.getSupertag() : goldTagging.getPOS();
        this.totalTags += tagging.size();
        ++this.totalWords;
        if (goldTagging.getPOS() == null) {
            System.err.println("Warning: found null gold POS, skipping word: " + goldTagging);
            this.allCorrect = false;
            return;
        }
        String thisPOS = goldTagging.getPOS();
        String thisGenPOS = goldTagging.getPOS().substring(0, 1);
        Integer posT = this.posTot.get(thisPOS);
        Integer gPOST = this.genPOSTot.get(thisGenPOS);
        if (posT == null) {
            this.posTot.put(thisPOS, new Integer(1));
        } else {
            this.posTot.put(thisPOS, new Integer(posT + 1));
        }
        if (gPOST == null) {
            this.genPOSTot.put(thisGenPOS, new Integer(1));
        } else {
            this.genPOSTot.put(thisGenPOS, new Integer(gPOST + 1));
        }
        boolean gotIt = false;
        for (Pair<Double, String> tag : tagging) {
            if (!((String)tag.b).equals(goldTag)) continue;
            gotIt = true;
            ++this.totalRight;
            Integer posLkup = this.posToRight.get(thisPOS);
            Integer genPOSLkup = this.genPOSToRight.get(thisGenPOS);
            if (posLkup == null) {
                this.posToRight.put(thisPOS, new Integer(1));
            } else {
                this.posToRight.put(thisPOS, new Integer(posLkup + 1));
            }
            if (genPOSLkup == null) {
                this.genPOSToRight.put(thisGenPOS, new Integer(1));
                break;
            }
            this.genPOSToRight.put(thisGenPOS, new Integer(genPOSLkup + 1));
            break;
        }
        if (!gotIt) {
            this.allCorrect = false;
        }
    }

    public String report() {
        for (String post : this.posTot.keySet()) {
            if (this.posToRight.get(post) != null) continue;
            this.posToRight.put(post, new Integer(0));
        }
        for (String post : this.genPOSTot.keySet()) {
            if (this.genPOSToRight.get(post) != null) continue;
            this.genPOSToRight.put(post, new Integer(0));
        }
        String rep = "";
        rep = rep + "\n\nAccuracy by POS type:\n\n";
        for (String post : this.posTot.keySet()) {
            rep = rep + post + ": " + ((double)this.posToRight.get(post).intValue() + 0.0) / (double)this.posTot.get(post).intValue() + " <==> " + this.posToRight.get(post) + "/" + this.posTot.get(post) + " = " + 100.0 * (((double)(this.posTot.get(post) - this.posToRight.get(post)) + 0.0) / (double)(this.totalWords - this.totalRight)) + " (% of total errors) \n";
        }
        rep = rep + "\nAccuracy by general (truncated) POS type:\n\n";
        for (String post : this.genPOSTot.keySet()) {
            rep = rep + post + ": " + ((double)this.genPOSToRight.get(post).intValue() + 0.0) / (double)this.genPOSTot.get(post).intValue() + " <==> " + this.genPOSToRight.get(post) + "/" + this.genPOSTot.get(post) + " = " + 100.0 * (((double)(this.genPOSTot.get(post) - this.genPOSToRight.get(post)) + 0.0) / (double)(this.totalWords - this.totalRight)) + " (% of total errors) \n";
        }
        rep = rep + "\nTotal words: " + this.totalWords + "\nTotal sents: " + this.sentNum + "\nAggregate total tags: " + this.totalTags + "\nAve. tags/word: " + ((double)this.totalTags + 0.0) / ((double)this.totalWords + 0.0) + "\nWord accuracy: " + ((double)this.totalRight + 0.0) / (double)this.totalWords + "\n\nSent accuracy: " + ((double)this.sentsCorrect + 0.0) / (double)this.sentNum + "\n\n";
        return rep;
    }

    public static enum ResultSinkType {
        SUPERTAG,
        POSTAG;

    }
}

