/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.perceptron;

import opennlp.ccg.perceptron.Alphabet;
import opennlp.ccg.perceptron.FeatureVector;

public class ComposedFeatureVector
implements FeatureVector {
    public final FeatureVector[] featureVectors;

    public ComposedFeatureVector(FeatureVector[] featureVectors) {
        this.featureVectors = featureVectors;
    }

    public ComposedFeatureVector(FeatureVector featureVector1, FeatureVector featureVector2) {
        this.featureVectors = new FeatureVector[]{featureVector1, featureVector2};
    }

    @Override
    public int size() {
        int retval = 0;
        for (FeatureVector fv : this.featureVectors) {
            retval += fv.size();
        }
        return retval;
    }

    @Override
    public FeatureVector.Iterator iterator() {
        if (this.featureVectors.length == 0) {
            return EMPTY_ITERATOR;
        }
        return new FeatureVector.Iterator(){
            int i = 0;
            FeatureVector.Iterator it;
            {
                this.it = ComposedFeatureVector.this.featureVectors[0].iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.it.hasNext()) {
                    return true;
                }
                if (this.i == ComposedFeatureVector.this.featureVectors.length - 1) {
                    return false;
                }
                this.it = ComposedFeatureVector.this.featureVectors[++this.i].iterator();
                return this.hasNext();
            }

            @Override
            public Alphabet.Feature nextFeature() {
                return this.it.nextFeature();
            }

            @Override
            public Float nextValue() {
                return this.it.nextValue();
            }
        };
    }
}

