/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.realize;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import opennlp.ccg.TextCCG;
import opennlp.ccg.hylo.Alt;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.realize.EdgeCombos;
import opennlp.ccg.realize.Tracker;
import opennlp.ccg.synsem.Sign;

public class Edge
extends Tracker {
    public static final String SHOW_COMPLETENESS = "Show Completeness";
    public static final String SHOW_BITSET = "Show Bitset";
    protected Sign sign;
    public final float completeness;
    public final double score;
    public final BitSet incompleteLfChunk;
    protected List<Edge> altEdges = null;
    protected EdgeCombos edgeCombos = null;
    protected Edge optCompletes = null;
    private static final NumberFormat nf2 = Edge.initNF2();
    private static final NumberFormat nf3 = Edge.initNF3();
    private static final NumberFormat nfE = new DecimalFormat("0.##E0");

    public Edge(Sign sign, BitSet bitset, BitSet indices, float completeness, double score, List<List<Alt>> activeLfAlts, BitSet incompleteLfChunk) {
        super(bitset, indices, activeLfAlts);
        this.sign = sign;
        this.completeness = completeness;
        this.score = score;
        this.incompleteLfChunk = incompleteLfChunk;
    }

    public Sign getSign() {
        return this.sign;
    }

    public boolean complete() {
        return (double)this.completeness == 1.0;
    }

    public Nominal getIndexNominal() {
        return this.sign.getCategory().getIndexNominal();
    }

    public boolean meetsLfChunkConstraints(Tracker tracker) {
        if (this.incompleteLfChunk == null || tracker.bitset.isEmpty()) {
            return true;
        }
        return this.incompleteLfChunk.intersects(tracker.bitset);
    }

    public boolean isRepresentative() {
        return this.altEdges != null;
    }

    public boolean isDisjunctive() {
        return this.altEdges != null && this.altEdges.size() > 1;
    }

    public List<Edge> getAltEdges() {
        if (this.altEdges == null) {
            return Collections.emptyList();
        }
        return this.altEdges;
    }

    public void initAltEdges() {
        this.initAltEdges(3);
    }

    public void initAltEdges(int capacity) {
        if (this.altEdges != null) {
            throw new RuntimeException("Alt edges already initialized!");
        }
        this.altEdges = new ArrayList<Edge>(capacity);
        this.altEdges.add(this);
    }

    public void initEdgeCombos() {
        if (!this.isRepresentative()) {
            throw new RuntimeException("Not a representative!");
        }
        if (this.edgeCombos != null) {
            throw new RuntimeException("Edge combos already initialized!");
        }
        this.edgeCombos = new EdgeCombos();
    }

    public int hashCode() {
        int retval = this.sign.hashCode() + 31 * this.bitset.hashCode() + this.indices.hashCode();
        return retval += (int)(31000.0 * this.score);
    }

    public int surfaceWordHashCode() {
        return this.sign.surfaceWordHashCode(true) + 31 * this.bitset.hashCode() + this.indices.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge edge = (Edge)obj;
        return this.bitset.equals(edge.bitset) && this.indices.equals(edge.indices) && this.completeness == edge.completeness && this.score == edge.score && this.sign.equals(edge.sign);
    }

    public boolean surfaceWordEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge edge = (Edge)obj;
        return this.bitset.equals(edge.bitset) && this.indices.equals(edge.indices) && this.sign.surfaceWordEquals(edge.sign, true);
    }

    public String toString() {
        Preferences prefs = Preferences.userNodeForPackage(TextCCG.class);
        boolean showCompleteness = prefs.getBoolean(SHOW_COMPLETENESS, false);
        boolean showBitset = prefs.getBoolean(SHOW_BITSET, false);
        StringBuffer sbuf = new StringBuffer();
        if (showCompleteness) {
            sbuf.append("{" + nf2.format(this.completeness) + "} ");
        }
        if (this.score >= 0.001 || this.score == 0.0) {
            sbuf.append("[" + nf3.format(this.score) + "] ");
        } else {
            sbuf.append("[" + nfE.format(this.score) + "] ");
        }
        sbuf.append(this.sign.toString());
        if (showBitset) {
            sbuf.append(' ').append(Edge.toString(this.bitset));
        }
        return sbuf.toString();
    }

    private static NumberFormat initNF2() {
        NumberFormat f = NumberFormat.getInstance();
        f.setMinimumIntegerDigits(1);
        f.setMinimumFractionDigits(2);
        f.setMaximumFractionDigits(2);
        return f;
    }

    private static NumberFormat initNF3() {
        NumberFormat f = NumberFormat.getInstance();
        f.setMinimumIntegerDigits(1);
        f.setMinimumFractionDigits(3);
        f.setMaximumFractionDigits(3);
        return f;
    }

    public static String toString(BitSet bitset) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('{');
        int j = 0;
        int i = bitset.nextSetBit(0);
        while (i >= 0) {
            if (j != 0) {
                sbuf.append(',');
            }
            if ((j = bitset.nextClearBit(i)) == i + 1) {
                sbuf.append(Integer.toString(i));
            } else {
                sbuf.append(i + "-" + (j - 1));
            }
            i = bitset.nextSetBit(j + 1);
        }
        sbuf.append('}');
        return sbuf.toString();
    }
}

