/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.realize;

import java.util.List;
import java.util.prefs.Preferences;
import opennlp.ccg.TextCCG;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.realize.Chart;
import opennlp.ccg.realize.Edge;
import opennlp.ccg.realize.EdgeFactory;
import opennlp.ccg.realize.Hypertagger;
import opennlp.ccg.realize.NBestPruningStrategy;
import opennlp.ccg.realize.PruningStrategy;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.SignScorer;
import org.jdom.Document;
import org.jdom.Element;

public class Realizer {
    public final Grammar grammar;
    public boolean depthFirst = false;
    private Chart chart = null;
    public int timeLimitMS = -1;
    public boolean waitForCompleteEdge = false;
    public SignScorer signScorer = null;
    public PruningStrategy pruningStrategy = null;
    public Hypertagger hypertagger = null;
    private boolean useGluing = Boolean.getBoolean("useGluing");

    public Realizer(Grammar grammar) {
        this.grammar = grammar;
    }

    public Chart getChart() {
        return this.chart;
    }

    public static LF getLfFromDoc(Document doc) {
        Element rootElt = doc.getRootElement();
        Element lfElt = rootElt.getName().equals("lf") ? rootElt : rootElt.getChild("lf");
        return Realizer.getLfFromElt(lfElt);
    }

    public static LF getLfFromElt(Element lfElt) {
        HyloHelper.processChunks(lfElt);
        LF lf = HyloHelper.getLF(lfElt);
        return lf;
    }

    public Edge realize(LF lf) {
        return this.realize(lf, this.signScorer);
    }

    public Edge realize(LF lf, SignScorer signScorer) {
        Preferences prefs = Preferences.userNodeForPackage(TextCCG.class);
        int timeLimitToUse = this.timeLimitMS != -1 ? this.timeLimitMS : prefs.getInt("Time Limit", 0);
        return this.realize(lf, signScorer, timeLimitToUse, this.waitForCompleteEdge);
    }

    public Edge realize(LF lf, SignScorer signScorer, int timeLimitMS, boolean waitForCompleteEdge) {
        PruningStrategy strategyToUse;
        List<SatOp> preds = HyloHelper.flatten(lf);
        SignScorer scorerToUse = signScorer != null ? signScorer : SignScorer.nullScorer;
        PruningStrategy pruningStrategy = strategyToUse = this.pruningStrategy != null ? this.pruningStrategy : new NBestPruningStrategy();
        if (this.hypertagger != null) {
            return this.realizeWithHypertagger(preds, scorerToUse, strategyToUse, timeLimitMS);
        }
        long startTime = System.currentTimeMillis();
        this.chart = new Chart(new EdgeFactory(this.grammar, preds, scorerToUse), strategyToUse);
        this.chart.startTime = startTime;
        this.chart.depthFirst = this.depthFirst;
        this.chart.initialize();
        this.chart.combine(timeLimitMS, waitForCompleteEdge);
        return this.chart.bestEdge;
    }

    private Edge realizeWithHypertagger(List<SatOp> preds, SignScorer signScorer, PruningStrategy pruningStrategy, int timeLimitMS) {
        long startTime = System.currentTimeMillis();
        Preferences prefs = Preferences.userNodeForPackage(TextCCG.class);
        int edgeLimit = prefs.getInt("Edge Limit", 0);
        this.grammar.lexicon.setSupertagger(this.hypertagger);
        this.hypertagger.resetBeta();
        Edge retval = null;
        this.chart = null;
        boolean outOfBetas = false;
        boolean pastTimeLimit = false;
        boolean exceededEdgeLimit = false;
        long iterStartTime = 0L;
        long currentTime = 0L;
        int iterTime = 0;
        while (!(retval != null || outOfBetas || pastTimeLimit || exceededEdgeLimit)) {
            this.chart = new Chart(new EdgeFactory(this.grammar, preds, signScorer, this.hypertagger), pruningStrategy);
            iterStartTime = System.currentTimeMillis();
            this.chart.usePacking = true;
            this.chart.collectCombos = false;
            this.chart.doUnpacking = false;
            this.chart.joinFragments = false;
            this.chart.initialize();
            if (this.chart.noUncoveredPreds()) {
                this.chart.combine(timeLimitMS, false);
            }
            currentTime = System.currentTimeMillis();
            iterTime = (int)(currentTime - iterStartTime);
            if (timeLimitMS != 0 && iterTime >= timeLimitMS) {
                pastTimeLimit = true;
            }
            if (edgeLimit != 0 && this.chart.numEdges >= edgeLimit) {
                exceededEdgeLimit = true;
            }
            if (this.chart.bestEdge.complete()) {
                this.chart.doUnpacking = true;
                this.chart.doUnpacking();
                retval = this.chart.bestEdge;
                continue;
            }
            if (pastTimeLimit || exceededEdgeLimit) continue;
            if (this.hypertagger.hasMoreBetas()) {
                this.hypertagger.nextBeta();
                continue;
            }
            outOfBetas = true;
        }
        if (retval == null) {
            if (this.useGluing) {
                this.chart.reInitForGluing();
                this.chart.edgeLimit = edgeLimit * 2;
                this.chart.combine(timeLimitMS * 2, this.waitForCompleteEdge);
                currentTime = System.currentTimeMillis();
                iterTime = (int)(currentTime - iterStartTime);
                if (this.chart.bestEdge.complete()) {
                    this.chart.doUnpacking = true;
                    this.chart.doUnpacking();
                    retval = this.chart.bestEdge;
                }
            }
            if (retval == null) {
                this.chart = new Chart(new EdgeFactory(this.grammar, preds, signScorer, this.hypertagger), pruningStrategy);
                iterStartTime = System.currentTimeMillis();
                this.chart.usePacking = false;
                this.chart.joinFragments = true;
                this.chart.initialize();
                this.chart.combine(timeLimitMS, this.waitForCompleteEdge);
                currentTime = System.currentTimeMillis();
                iterTime = (int)(currentTime - iterStartTime);
                retval = this.chart.bestEdge;
            }
        }
        long endTime = System.currentTimeMillis();
        this.chart.timeTilDone = (int)(endTime - startTime);
        this.grammar.lexicon.setSupertagger(null);
        return retval;
    }
}

