/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.synsem;

import opennlp.ccg.parse.DerivationHistory;
import opennlp.ccg.synsem.Sign;

public abstract class DerivationHandler<T> {
    public abstract T topStep(Sign var1);

    public abstract T lexStep(Sign var1);

    public abstract T unaryStep(Sign var1, Sign var2);

    public abstract T binaryStep(Sign var1, boolean var2, Sign var3, Sign var4);

    public T checkCache(Sign sign) {
        return null;
    }

    public void cache(Sign sign, T result) {
    }

    public T handleCompleteDerivation(Sign sign) {
        return this.topStep(sign);
    }

    public T handleDerivation(Sign sign) {
        Sign siblingChild;
        Sign headChild;
        boolean left;
        T retval = this.checkCache(sign);
        if (retval != null) {
            return retval;
        }
        if (sign.isLexical()) {
            retval = this.lexStep(sign);
            this.cache(sign, retval);
            return retval;
        }
        DerivationHistory dh = sign.getDerivationHistory();
        Sign[] inputs = dh.getInputs();
        if (inputs.length == 1) {
            Sign headChild2 = inputs[0];
            retval = this.unaryStep(sign, headChild2);
            this.cache(sign, retval);
            return retval;
        }
        if (sign.getLexHead() == inputs[0].getLexHead()) {
            left = true;
            headChild = inputs[0];
            siblingChild = inputs[1];
        } else {
            left = false;
            headChild = inputs[1];
            siblingChild = inputs[0];
        }
        retval = this.binaryStep(sign, left, headChild, siblingChild);
        this.cache(sign, retval);
        return retval;
    }
}

