/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.synsem;

import gnu.trove.TObjectIntHashMap;
import java.io.Serializable;
import opennlp.ccg.synsem.Arg;
import opennlp.ccg.synsem.ArgStack;
import opennlp.ccg.synsem.CategoryFcn;
import opennlp.ccg.synsem.Slash;
import opennlp.ccg.unify.Indexed;
import opennlp.ccg.unify.ModFcn;
import opennlp.ccg.unify.Mutable;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.unify.Variable;

public final class Dollar
implements Arg,
Variable,
Mutable,
Indexed,
Serializable {
    private static final long serialVersionUID = -5936227018184772678L;
    private final Slash _slash;
    private final String _name;
    private int _index = 0;
    private boolean _hasMostGeneralSlash = false;

    public Dollar(String name) {
        this(new Slash(), name);
    }

    public Dollar(Slash s, String name) {
        this(s, name, 0);
    }

    public Dollar(Slash s, String name, int id) {
        this._slash = s;
        this._name = name;
        this._index = id;
        if (s.toString().equals("|.")) {
            this._hasMostGeneralSlash = true;
        }
    }

    @Override
    public String name() {
        return this._name;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public void setIndex(int uniqueIndex) {
        this._index = uniqueIndex;
    }

    @Override
    public Arg copy() {
        return new Dollar(this._slash.copy(), this._name, this._index);
    }

    @Override
    public void forall(CategoryFcn fcn) {
    }

    public Slash getSlash() {
        return this._slash;
    }

    @Override
    public void setSlashModifier(boolean modifier) {
        this._slash.setModifier(modifier);
    }

    @Override
    public void setSlashHarmonicCompositionResult(boolean harmonicResult) {
        this._slash.setHarmonicCompositionResult(harmonicResult);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Dollar && this._index == ((Dollar)o).getIndex() && this._slash.equals(((Dollar)o).getSlash());
    }

    public int hashCode() {
        return 31 * this._index + this._slash.hashCode();
    }

    @Override
    public boolean occurs(Variable v) {
        return v instanceof Dollar && this.equals(v);
    }

    @Override
    public Object fill(Substitution sub) throws UnifyFailure {
        Object value = sub.getValue(this);
        if (value == null) {
            return this;
        }
        if (value instanceof Dollar) {
            return value;
        }
        if (value instanceof Arg && !((Arg)value).occurs(this)) {
            return ((Arg)value).fill(sub);
        }
        if (value instanceof ArgStack && !((ArgStack)value).occurs(this)) {
            return ((ArgStack)value).fill(sub);
        }
        throw new UnifyFailure();
    }

    @Override
    public void unifySlash(Slash s) throws UnifyFailure {
        this._slash.unifyCheck(s);
    }

    @Override
    public void unifyCheck(Object u) throws UnifyFailure {
    }

    @Override
    public Object unify(Object u, Substitution sub) throws UnifyFailure {
        if (u instanceof ArgStack && !((ArgStack)u).occurs(this)) {
            ((ArgStack)u).slashesUnify(this._slash);
        } else if (u instanceof Arg && !((Arg)u).occurs(this)) {
            ((Arg)u).unifySlash(this._slash);
        } else {
            throw new UnifyFailure();
        }
        sub.makeSubstitution(this, u);
        return u;
    }

    @Override
    public void deepMap(ModFcn mf) {
        mf.modify(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this._hasMostGeneralSlash) {
            sb.append(this._slash.toString());
        }
        sb.append('$').append(this._name);
        return sb.toString();
    }

    @Override
    public String getSupertag() {
        StringBuffer sb = new StringBuffer();
        if (!this._hasMostGeneralSlash) {
            sb.append(this._slash.getSupertag());
        }
        sb.append('$');
        return sb.toString();
    }

    @Override
    public String toTeX() {
        StringBuffer sb = new StringBuffer();
        if (!this._hasMostGeneralSlash) {
            sb.append(this._slash.toTeX());
        }
        sb.append("\\$ \\subs{").append(this._name).append("}");
        return sb.toString();
    }

    @Override
    public int hashCode(TObjectIntHashMap varMap) {
        int retval = this._slash.hashCode(varMap);
        if (varMap.containsKey((Object)this)) {
            retval += varMap.get((Object)this);
        } else {
            int next = varMap.size() + 1;
            varMap.put((Object)this, next);
            retval += next;
        }
        return retval;
    }

    @Override
    public boolean equals(Object obj, TObjectIntHashMap varMap, TObjectIntHashMap varMap2) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Dollar d = (Dollar)obj;
        if (varMap.get((Object)this) != varMap2.get((Object)d)) {
            return false;
        }
        return this._slash.equals(d._slash, varMap, varMap2);
    }
}

