/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.synsem;

import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.synsem.Sign;

public class SignHash
extends THashSet {
    private static final long serialVersionUID = 1L;
    protected static TObjectHashingStrategy surfaceWordHashingStrategy = new TObjectHashingStrategy(){
        private static final long serialVersionUID = 1L;

        public int computeHashCode(Object o) {
            return ((Sign)o).surfaceWordHashCode();
        }

        public boolean equals(Object o1, Object o2) {
            return ((Sign)o1).surfaceWordEquals((Sign)o2);
        }
    };
    public static final Comparator<Sign> signComparator = new Comparator<Sign>(){

        @Override
        public int compare(Sign sign1, Sign sign2) {
            return SignHash.compareTo(sign1, sign2);
        }
    };

    public SignHash() {
        super(surfaceWordHashingStrategy);
    }

    public SignHash(Sign sign) {
        this();
        this.insert(sign);
    }

    public SignHash(Collection<Sign> c) {
        this();
        for (Sign s : c) {
            this.insert(s);
        }
    }

    public Set<Sign> asSignSet() {
        return this;
    }

    public Sign insert(Sign sign) {
        int pos = this.index(sign);
        if (pos >= 0) {
            Sign oldSign = (Sign)this._set[pos];
            if (oldSign == sign) {
                return null;
            }
            if (sign.getDerivationHistory().compareTo(oldSign.getDerivationHistory()) < 0) {
                this._set[pos] = sign;
                return oldSign;
            }
            return null;
        }
        this.add(sign);
        return sign;
    }

    public List<Sign> getSignsSorted() {
        ArrayList<Sign> retval = new ArrayList<Sign>(this.asSignSet());
        Collections.sort(retval, signComparator);
        return retval;
    }

    public static int compareTo(Sign sign1, Sign sign2) {
        int h2;
        List<Word> words2;
        int cmp = 0;
        cmp = sign1.getDerivationHistory().compareTo(sign2.getDerivationHistory());
        if (cmp != 0) {
            return cmp;
        }
        List<Word> words1 = sign1.getWords();
        cmp = SignHash.compareTo(words1, words2 = sign2.getWords());
        if (cmp != 0) {
            return cmp;
        }
        int h1 = sign1.getCategory().hashCode();
        if (h1 < (h2 = sign2.getCategory().hashCode())) {
            return -1;
        }
        if (h1 > h2) {
            return 1;
        }
        return 0;
    }

    public static int compareTo(List<Word> words1, List<Word> words2) {
        for (int i = 0; i < words1.size() || i < words2.size(); ++i) {
            Word w2;
            if (i == words1.size()) {
                return -1;
            }
            if (i == words2.size()) {
                return 1;
            }
            Word w1 = words1.get(i);
            int cmp = w1.compareTo(w2 = words2.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }
}

