/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.synsem;

import java.util.ArrayList;
import java.util.List;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.perceptron.Alphabet;
import opennlp.ccg.perceptron.FeatureExtractor;
import opennlp.ccg.perceptron.FeatureMap;
import opennlp.ccg.perceptron.FeatureVector;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.util.TrieMap;

public class SyntacticFeatureExtractor
implements FeatureExtractor {
    public static final String PREFIX = "syn";
    public boolean includeDistFeats = true;
    protected Alphabet alphabet = null;
    protected FeatureMap currentMap = null;
    protected Sign currentSign = null;
    protected Sign[] currentInputs = null;
    protected Sign currentSibling = null;
    protected List<Word> currentWords = null;
    protected int currentHeadIndex = -1;
    protected int currentSibHeadIndex = -1;
    protected String currentDistW = null;
    protected String currentDistP = null;
    protected String currentDistV = null;
    protected List<List<TrieMap.KeyExtractor<String>>> lexExtractors = new ArrayList<List<TrieMap.KeyExtractor<String>>>();
    protected List<List<TrieMap.KeyExtractor<String>>> unaryRuleExtractors = new ArrayList<List<TrieMap.KeyExtractor<String>>>();
    protected List<List<TrieMap.KeyExtractor<String>>> binaryRuleExtractors = new ArrayList<List<TrieMap.KeyExtractor<String>>>();
    protected List<List<TrieMap.KeyExtractor<String>>> distExtractors = new ArrayList<List<TrieMap.KeyExtractor<String>>>();

    public SyntacticFeatureExtractor() {
        this.lexExtractors.add(this.lexcat_word());
        this.lexExtractors.add(this.lexcat_pos());
        this.unaryRuleExtractors.add(this.unary_rule());
        this.unaryRuleExtractors.add(this.unary_rule_word());
        this.unaryRuleExtractors.add(this.unary_rule_pos());
        this.binaryRuleExtractors.add(this.binary_rule());
        this.binaryRuleExtractors.add(this.binary_rule_word());
        this.binaryRuleExtractors.add(this.binary_rule_pos());
        this.binaryRuleExtractors.add(this.rule_word_word());
        this.binaryRuleExtractors.add(this.rule_word_pos());
        this.binaryRuleExtractors.add(this.rule_pos_word());
        this.binaryRuleExtractors.add(this.rule_pos_pos());
        this.distExtractors.add(this.rule_word_dist());
        this.distExtractors.add(this.rule_pos_dist());
        this.distExtractors.add(this.rule_word_dist_puncts());
        this.distExtractors.add(this.rule_pos_dist_puncts());
        this.distExtractors.add(this.rule_word_dist_verbs());
        this.distExtractors.add(this.rule_pos_dist_verbs());
    }

    @Override
    public void setAlphabet(Alphabet alphabet) {
        this.alphabet = alphabet;
    }

    @Override
    public FeatureVector extractFeatures(Sign sign, boolean complete) {
        this.addFeatures(sign, complete);
        return this.getFeatureMap(sign);
    }

    protected void addFeatures(Sign sign, boolean complete) {
        if (this.getFeatureMap(sign) != null) {
            return;
        }
        if (sign.isLexical()) {
            this.currentSign = sign;
            this.currentMap = new FeatureMap();
            this.inc(this.lexExtractors);
        } else {
            Sign[] inputs;
            for (Sign child : inputs = sign.getDerivationHistory().getInputs()) {
                this.addFeatures(child, false);
            }
            this.currentSign = sign;
            this.currentInputs = inputs;
            if (inputs.length == 1) {
                this.currentMap = new FeatureMap(this.getFeatureMap(inputs[0]));
                this.inc(this.unaryRuleExtractors);
            } else if (inputs.length == 2) {
                this.currentMap = new FeatureMap(this.getFeatureMap(inputs[0]), this.getFeatureMap(inputs[1]));
                this.currentSibling = this.sibling(sign, inputs);
                this.inc(this.binaryRuleExtractors);
                if (this.includeDistFeats) {
                    this.currentWords = null;
                    this.currentDistW = null;
                    this.currentDistP = null;
                    this.currentDistV = null;
                    this.inc(this.distExtractors);
                }
            }
        }
        this.storeFeatureMap(sign);
    }

    protected void storeFeatureMap(Sign sign) {
        sign.addData(new FeatureMapWrapper(this.currentMap));
    }

    protected FeatureMap getFeatureMap(Sign sign) {
        FeatureMapWrapper fmw = (FeatureMapWrapper)sign.getData(FeatureMapWrapper.class);
        return fmw != null ? fmw.featureMap : null;
    }

    protected void inc(List<List<TrieMap.KeyExtractor<String>>> extractors) {
        for (List<TrieMap.KeyExtractor<String>> lazyExtractor : extractors) {
            Alphabet.Feature f = this.alphabet.indexLazy(lazyExtractor);
            if (f == null) continue;
            this.currentMap.inc(f);
        }
    }

    protected Sign sibling(Sign sign, Sign[] inputs) {
        if (sign.getLexHead() == inputs[0].getLexHead()) {
            return inputs[1];
        }
        return inputs[0];
    }

    protected void setCurrentWords() {
        if (this.currentWords != null) {
            return;
        }
        this.currentWords = this.currentSign.getWords();
        Word head = this.currentSign.getLexHead().getWords().get(0);
        Word sibHead = this.currentSibling.getLexHead().getWords().get(0);
        this.currentHeadIndex = this.find(this.currentWords, head);
        this.currentSibHeadIndex = this.find(this.currentWords, sibHead);
    }

    protected int find(List<Word> words, Word word) {
        int len = words.size();
        for (int i = 0; i < len; ++i) {
            if (words.get(i) != word) continue;
            return i;
        }
        return -1;
    }

    protected String distWords() {
        if (this.currentDistW != null) {
            return this.currentDistW;
        }
        this.setCurrentWords();
        int dist = Math.abs(this.currentHeadIndex - this.currentSibHeadIndex) - 1;
        switch (dist) {
            case 0: {
                this.currentDistW = "0w";
                return "0w";
            }
            case 1: {
                this.currentDistW = "1w";
                return "1w";
            }
            case 2: {
                this.currentDistW = "2w";
                return "2w";
            }
        }
        this.currentDistW = "3w";
        return "3w";
    }

    protected String distPuncts() {
        if (this.currentDistP != null) {
            return this.currentDistP;
        }
        this.setCurrentWords();
        int min = Math.min(this.currentHeadIndex, this.currentSibHeadIndex);
        int max = Math.max(this.currentHeadIndex, this.currentSibHeadIndex);
        int count = 0;
        for (int i = min + 1; i < max; ++i) {
            Word w = this.currentWords.get(i);
            if (!this.isPunct(w)) continue;
            ++count;
        }
        switch (count) {
            case 0: {
                this.currentDistP = "0p";
                return "0p";
            }
            case 1: {
                this.currentDistP = "1p";
                return "1p";
            }
            case 2: {
                this.currentDistP = "2p";
                return "2p";
            }
        }
        this.currentDistP = "3p";
        return "3p";
    }

    protected boolean isPunct(Word word) {
        String form = word.getForm();
        return form == "," || form == "--" || form == ";" || form == ":";
    }

    protected String distVerbs() {
        if (this.currentDistV != null) {
            return this.currentDistV;
        }
        this.setCurrentWords();
        int min = Math.min(this.currentHeadIndex, this.currentSibHeadIndex);
        int max = Math.max(this.currentHeadIndex, this.currentSibHeadIndex);
        int count = 0;
        for (int i = min + 1; i < max; ++i) {
            Word w = this.currentWords.get(i);
            if (!this.isVerb(w)) continue;
            ++count;
        }
        switch (count) {
            case 0: {
                this.currentDistV = "0v";
                return "0v";
            }
            case 1: {
                this.currentDistV = "1v";
                return "1v";
            }
        }
        this.currentDistV = "2v";
        return "2v";
    }

    protected boolean isVerb(Word word) {
        String pos = word.getPOS();
        return pos.startsWith("V");
    }

    private List<TrieMap.KeyExtractor<String>> lexcat_word() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(2);
        this.add_supertag(retval);
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return SyntacticFeatureExtractor.this.currentSign.getWordForm();
            }
        });
        return retval;
    }

    private void add_supertag(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return SyntacticFeatureExtractor.PREFIX;
            }
        });
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return SyntacticFeatureExtractor.this.currentSign.getSupertag();
            }
        });
    }

    private List<TrieMap.KeyExtractor<String>> lexcat_pos() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(2);
        this.add_supertag(retval);
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return SyntacticFeatureExtractor.this.currentSign.getPOS();
            }
        });
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> unary_rule() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(2);
        this.add_unary_rule(retval);
        return retval;
    }

    private void add_unary_rule(List<TrieMap.KeyExtractor<String>> retval) {
        this.add_supertag(retval);
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return SyntacticFeatureExtractor.this.currentInputs[0].getSupertag();
            }
        });
    }

    private List<TrieMap.KeyExtractor<String>> binary_rule() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(3);
        this.add_binary_rule(retval);
        return retval;
    }

    private void add_binary_rule(List<TrieMap.KeyExtractor<String>> retval) {
        this.add_unary_rule(retval);
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return SyntacticFeatureExtractor.this.currentInputs[1].getSupertag();
            }
        });
    }

    private List<TrieMap.KeyExtractor<String>> unary_rule_word() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(3);
        this.add_unary_rule_word(retval);
        return retval;
    }

    private void add_unary_rule_word(List<TrieMap.KeyExtractor<String>> retval) {
        this.add_unary_rule(retval);
        this.add_lex_word(retval);
    }

    private void add_lex_word(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return SyntacticFeatureExtractor.this.currentSign.getLexHead().getWordForm();
            }
        });
    }

    private List<TrieMap.KeyExtractor<String>> binary_rule_word() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(4);
        this.add_binary_rule_word(retval);
        return retval;
    }

    private void add_binary_rule_word(List<TrieMap.KeyExtractor<String>> retval) {
        this.add_binary_rule(retval);
        this.add_lex_word(retval);
    }

    private List<TrieMap.KeyExtractor<String>> unary_rule_pos() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(3);
        this.add_unary_rule_pos(retval);
        return retval;
    }

    private void add_unary_rule_pos(List<TrieMap.KeyExtractor<String>> retval) {
        this.add_unary_rule(retval);
        this.add_lex_pos(retval);
    }

    private void add_lex_pos(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return SyntacticFeatureExtractor.this.currentSign.getLexHead().getPOS();
            }
        });
    }

    private List<TrieMap.KeyExtractor<String>> binary_rule_pos() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(4);
        this.add_binary_rule_pos(retval);
        return retval;
    }

    private void add_binary_rule_pos(List<TrieMap.KeyExtractor<String>> retval) {
        this.add_binary_rule(retval);
        this.add_lex_pos(retval);
    }

    private List<TrieMap.KeyExtractor<String>> rule_word_word() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_binary_rule_word(retval);
        this.add_sibling_word(retval);
        return retval;
    }

    private void add_sibling_word(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return SyntacticFeatureExtractor.this.currentSibling.getLexHead().getWordForm();
            }
        });
    }

    private List<TrieMap.KeyExtractor<String>> rule_word_pos() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_binary_rule_word(retval);
        this.add_sibling_pos(retval);
        return retval;
    }

    private void add_sibling_pos(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return SyntacticFeatureExtractor.this.currentSibling.getLexHead().getPOS();
            }
        });
    }

    private List<TrieMap.KeyExtractor<String>> rule_pos_word() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_binary_rule_pos(retval);
        this.add_sibling_word(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> rule_pos_pos() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_binary_rule_pos(retval);
        this.add_sibling_pos(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> rule_word_dist() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_binary_rule_word(retval);
        this.add_dist_words(retval);
        return retval;
    }

    private void add_dist_words(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return SyntacticFeatureExtractor.this.distWords();
            }
        });
    }

    private List<TrieMap.KeyExtractor<String>> rule_pos_dist() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_binary_rule_pos(retval);
        this.add_dist_words(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> rule_word_dist_puncts() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_binary_rule_word(retval);
        this.add_dist_puncts(retval);
        return retval;
    }

    private void add_dist_puncts(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return SyntacticFeatureExtractor.this.distPuncts();
            }
        });
    }

    private List<TrieMap.KeyExtractor<String>> rule_pos_dist_puncts() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_binary_rule_pos(retval);
        this.add_dist_puncts(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> rule_word_dist_verbs() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_binary_rule_word(retval);
        this.add_dist_verbs(retval);
        return retval;
    }

    private void add_dist_verbs(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return SyntacticFeatureExtractor.this.distVerbs();
            }
        });
    }

    private List<TrieMap.KeyExtractor<String>> rule_pos_dist_verbs() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_binary_rule_pos(retval);
        this.add_dist_verbs(retval);
        return retval;
    }

    public static class FeatureMapWrapper {
        public FeatureMap featureMap;

        public FeatureMapWrapper(FeatureMap featureMap) {
            this.featureMap = featureMap;
        }
    }
}

