/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.Sign;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class RegressionInfo {
    private Grammar grammar;
    private TestItem[] testItems;

    public RegressionInfo(Grammar grammar, File regressionFile) throws FileNotFoundException {
        this(grammar, new FileInputStream(regressionFile), RegressionInfo.serStream(regressionFile));
    }

    public RegressionInfo(Grammar grammar, InputStream istr, ObjectInputStream serStream) {
        this.grammar = grammar;
        SAXBuilder builder = new SAXBuilder();
        try {
            Map<String, Sign> signMap = RegressionInfo.readSerStream(serStream);
            Document doc = builder.build(istr);
            Element root = doc.getRootElement();
            List items = root.getChildren("item");
            this.testItems = new TestItem[items.size()];
            for (int i = 0; i < items.size(); ++i) {
                TestItem testItem;
                Element item = (Element)items.get(i);
                this.testItems[i] = testItem = new TestItem();
                testItem.sentence = item.getAttributeValue("string");
                testItem.alt = item.getAttributeValue("alt");
                testItem.numOfParses = Integer.parseInt(item.getAttributeValue("numOfParses"));
                testItem.knownFailure = "true".equals(item.getAttributeValue("known"));
                Element fullWordsElt = item.getChild("full-words");
                if (fullWordsElt != null) {
                    testItem.fullWords = fullWordsElt.getTextNormalize();
                }
                testItem.lfElt = item.getChild("lf");
                testItem.info = item.getAttributeValue("info");
                Element predInfoElt = item.getChild("pred-info");
                if (predInfoElt != null) {
                    testItem.predInfo = predInfoElt.getAttributeValue("data");
                }
                if (signMap == null || testItem.info == null) continue;
                testItem.sign = signMap.get(testItem.info);
            }
        }
        catch (Exception e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    public static File serFile(File regressionFile) {
        String name = regressionFile.getName();
        String prefix = name.substring(0, name.lastIndexOf(46));
        return new File(regressionFile.getParentFile(), prefix + ".ser");
    }

    public static ObjectInputStream serStream(File regressionFile) {
        File serFile = RegressionInfo.serFile(regressionFile);
        if (serFile.exists()) {
            try {
                return new ObjectInputStream(new FileInputStream(serFile));
            }
            catch (FileNotFoundException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
            catch (IOException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }
        return null;
    }

    public static Map<String, Sign> readSerStream(ObjectInputStream serStream) throws IOException {
        if (serStream == null) {
            return null;
        }
        try {
            return (Map)serStream.readObject();
        }
        catch (ClassNotFoundException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    public static void writeSerFile(Map<String, Sign> signMap, File regressionFile) throws FileNotFoundException, IOException {
        File serFile = RegressionInfo.serFile(regressionFile);
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(serFile));
        oos.writeObject(signMap);
        oos.close();
    }

    public int numberOfItems() {
        return this.testItems.length;
    }

    public TestItem getItem(int i) {
        return this.testItems[i];
    }

    public static Element makeTestItem(TestItem testItem) {
        Element item = new Element("item");
        item.setAttribute("numOfParses", "" + testItem.numOfParses);
        if (testItem.knownFailure) {
            item.setAttribute("known", "true");
        }
        item.setAttribute("string", testItem.sentence);
        if (testItem.alt != null) {
            item.setAttribute("alt", testItem.alt);
        }
        if (testItem.fullWords != null) {
            Element fullWordsElt = new Element("full-words");
            item.addContent((Content)fullWordsElt);
            fullWordsElt.addContent(testItem.fullWords);
        }
        if (testItem.lfElt != null) {
            testItem.lfElt.detach();
            item.addContent((Content)testItem.lfElt);
        }
        if (testItem.info != null) {
            item.setAttribute("info", testItem.info);
        }
        return item;
    }

    public Element makeTestItem(String target, int numParses, LF lf) throws IOException {
        return RegressionInfo.makeTestItem(this.grammar, target, numParses, lf);
    }

    public static Element makeTestItem(Grammar grammar, String target, int numParses, LF lf) throws IOException {
        return RegressionInfo.makeTestItem(grammar, target, numParses, lf, null);
    }

    public static Element makeTestItem(Grammar grammar, String target, int numParses, LF lf, String info) throws IOException {
        Element item = new Element("item");
        item.setAttribute("numOfParses", "" + numParses);
        item.setAttribute("string", target);
        if (lf != null) {
            item.addContent((Content)grammar.makeLfElt(lf));
        }
        if (info != null) {
            item.setAttribute("info", info);
        }
        return item;
    }

    public static void addToTestbed(Grammar grammar, Sign sign, int numParses, LF lf, String filename) throws IOException {
        Element root;
        Document doc;
        File file = new File(filename);
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        boolean newDoc = false;
        if (file.exists()) {
            SAXBuilder builder = new SAXBuilder();
            try {
                doc = builder.build(file);
            }
            catch (JDOMException jde) {
                throw (IOException)new IOException().initCause(jde);
            }
            root = doc.getRootElement();
        } else {
            doc = new Document();
            root = new Element("regression");
            doc.setRootElement(root);
            newDoc = true;
        }
        Map<String, Sign> signMap = RegressionInfo.readSerStream(RegressionInfo.serStream(file));
        if (signMap == null) {
            signMap = new HashMap<String, Sign>();
        }
        int count = 0;
        String id = "i" + count;
        while (signMap.containsKey(id)) {
            id = "i" + ++count;
        }
        String target = sign.getOrthography();
        Element item = RegressionInfo.makeTestItem(grammar, target, numParses, lf, id);
        if (!newDoc) {
            root.addContent("  ");
        }
        root.addContent((Content)item);
        signMap.put(id, sign);
        FileOutputStream out = new FileOutputStream(file);
        grammar.serializeXml(doc, out);
        out.close();
        RegressionInfo.writeSerFile(signMap, file);
    }

    public class TestItem {
        public String sentence;
        public String alt = null;
        public int numOfParses = 1;
        public boolean knownFailure = false;
        public String fullWords = null;
        public Element lfElt = null;
        public String info = null;
        public String predInfo = null;
        public Sign sign = null;

        public String getId() {
            if (this.info == null) {
                return null;
            }
            int pos = this.info.indexOf(61);
            return pos < 0 ? this.info : this.info.substring(pos + 1);
        }
    }
}

