/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;

public class TimingMap {
    private String label;
    private List<Integer> times = new ArrayList<Integer>();
    private HashMap<Integer, List<Integer>> map = new HashMap();

    public TimingMap(String label) {
        this.label = label;
    }

    public void add(int num, int time) {
        Integer timeInt = new Integer(time);
        this.times.add(timeInt);
        Integer key = new Integer(num);
        List<Integer> timesPerNum = this.map.get(key);
        if (timesPerNum == null) {
            timesPerNum = new ArrayList<Integer>();
            this.map.put(key, timesPerNum);
        }
        timesPerNum.add(timeInt);
    }

    public double mean() {
        int total = 0;
        for (int i = 0; i < this.times.size(); ++i) {
            Integer time = this.times.get(i);
            total += time.intValue();
        }
        return 1.0 * (double)total / (double)this.times.size();
    }

    public double sigma() {
        if (this.times.size() < 2) {
            return -1.0;
        }
        double mean = this.mean();
        double numerator = 0.0;
        for (int i = 0; i < this.times.size(); ++i) {
            Integer time = this.times.get(i);
            numerator += Math.pow((double)time.intValue() - mean, 2.0);
        }
        int denominator = this.times.size() - 1;
        return Math.sqrt(numerator / (double)denominator);
    }

    public void saveTimes(Element root) {
        Element timesElt = new Element("times");
        root.addContent((Content)timesElt);
        timesElt.setAttribute("label", this.label);
        Element listElt = new Element("list");
        timesElt.addContent((Content)listElt);
        listElt.setAttribute("mean", "" + this.mean());
        listElt.setAttribute("sigma", "" + this.sigma());
        for (int i = 0; i < this.times.size(); ++i) {
            Element timeElt = new Element("time");
            listElt.addContent((Content)timeElt);
            timeElt.setAttribute("val", this.times.get(i).toString());
        }
        Element perNumsElt = new Element("per-nums");
        timesElt.addContent((Content)perNumsElt);
        Set<Integer> keys = this.map.keySet();
        ArrayList<Integer> nums = new ArrayList<Integer>(keys.size());
        nums.addAll(keys);
        Collections.sort(nums);
        int min = (Integer)nums.get(0);
        int max = (Integer)nums.get(nums.size() - 1);
        for (int num = min; num <= max; ++num) {
            Element perNumElt = new Element("per");
            perNumsElt.addContent((Content)perNumElt);
            perNumElt.setAttribute("num", "" + num);
            Integer numKey = new Integer(num);
            List<Integer> timesPer = this.map.get(numKey);
            if (timesPer == null) {
                perNumElt.setAttribute("count", "0");
                continue;
            }
            int sum = 0;
            int count = timesPer.size();
            perNumElt.setAttribute("count", "" + count);
            for (int i = 0; i < timesPer.size(); ++i) {
                Integer time = timesPer.get(i);
                sum += time.intValue();
                Element timeElt = new Element("time");
                perNumElt.addContent((Content)timeElt);
                timeElt.setAttribute("val", time.toString());
            }
            double mean = (double)sum * 1.0 / (double)count;
            perNumElt.setAttribute("mean", "" + mean);
        }
    }
}

