/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.lexicon.Tokenizer;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.test.RegressionInfo;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class UpdateTestbed {
    private Grammar grammar;

    private UpdateTestbed(URL grammarURL) throws IOException {
        System.out.println("Loading grammar from URL: " + grammarURL);
        this.grammar = new Grammar(grammarURL);
    }

    private void addFullWords(File tbFile) throws IOException {
        System.out.println("Loading testbed from: " + tbFile);
        RegressionInfo tbInfo = new RegressionInfo(this.grammar, tbFile);
        Document outDoc = new Document();
        Element outRoot = new Element("regression");
        outDoc.setRootElement(outRoot);
        int numItems = tbInfo.numberOfItems();
        Tokenizer tokenizer = this.grammar.lexicon.tokenizer;
        System.out.print("Adding full words ");
        for (int i = 0; i < numItems; ++i) {
            RegressionInfo.TestItem testItem = tbInfo.getItem(i);
            if (testItem.fullWords == null) {
                List<Word> words = testItem.sign != null ? testItem.sign.getWords() : this.grammar.getParsedWords(testItem.sentence);
                testItem.fullWords = tokenizer.format(words);
            }
            outRoot.addContent((Content)RegressionInfo.makeTestItem(testItem));
            System.out.print(".");
        }
        System.out.println();
        File tbFileBackup = new File(tbFile.getParentFile(), tbFile.getName() + "~");
        System.out.println("Backing up testbed to: " + tbFileBackup);
        tbFile.renameTo(tbFileBackup);
        System.out.println("Saving results to: " + tbFile);
        FileOutputStream out = new FileOutputStream(tbFile);
        this.grammar.serializeXml(outDoc, out);
        out.close();
    }

    public static void main(String[] args) throws IOException {
        String usage = "Usage: java opennlp.ccg.test.UpdateTestbed (-g <grammarfile>) (-add-full-words) (<testbedfile>)";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println(usage);
            System.exit(0);
        }
        String grammarfile = "grammar.xml";
        String testbedfile = "testbed.xml";
        boolean addFullWords = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-g")) {
                grammarfile = args[++i];
                continue;
            }
            if (args[i].equals("-add-full-words")) {
                addFullWords = true;
                continue;
            }
            testbedfile = args[i];
        }
        File gFile = new File(grammarfile);
        URL grammarURL = gFile.toURI().toURL();
        File tbFile = new File(testbedfile);
        if (!tbFile.exists()) {
            tbFile = new File(gFile.getParentFile(), testbedfile);
        }
        if (!tbFile.exists()) {
            System.out.println("Unable to find testbed file: " + testbedfile);
            System.exit(-1);
        }
        UpdateTestbed updater = new UpdateTestbed(grammarURL);
        if (addFullWords) {
            updater.addFullWords(tbFile);
        }
        System.out.println("Done.");
    }
}

