/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.unify;

import gnu.trove.THashMap;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.Iterator;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.Unifiable;
import opennlp.ccg.unify.Unifier;
import opennlp.ccg.unify.UnifyControl;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.unify.Variable;

public class GSubstitution
extends THashMap
implements Substitution {
    private static final long serialVersionUID = 1L;
    private TIntObjectHashMap _indexedObjects = new TIntObjectHashMap();
    private TIntIntHashMap _newFeatStrucIndexes = new TIntIntHashMap();

    @Override
    public Object makeSubstitution(Variable var, Object u) throws UnifyFailure {
        Object val1 = this.getValue(var);
        if (u instanceof Variable) {
            Variable var2 = (Variable)u;
            Object val2 = this.getValue(var2);
            if (val1 != null && val1.equals(u)) {
                return u;
            }
            if (val2 != null && val2.equals(var)) {
                return var;
            }
            if (val1 != null) {
                if (val1 instanceof Unifiable && ((Unifiable)val1).occurs(var2)) {
                    throw new UnifyFailure();
                }
                u = val2 != null ? Unifier.unify(var, val2, this) : this.makeSubstitution(var2, val1);
            } else if (val2 != null) {
                if (val2 instanceof Unifiable && ((Unifiable)val2).occurs(var)) {
                    throw new UnifyFailure();
                }
                this.makeSubstitution(var, val2);
            }
        } else if (val1 != null) {
            u = Unifier.unify(val1, u, this);
        }
        this.put(var, u);
        for (Variable v : this.keySet()) {
            Object res = this.getValue(v);
            if (res instanceof Unifiable) {
                res = ((Unifiable)res).fill(this);
            }
            this.put(v, res);
        }
        if (u instanceof Unifiable) {
            u = ((Unifiable)u).fill(this);
        }
        return u;
    }

    @Override
    public Object getValue(Variable var) {
        Object deepVal;
        Object val = this.get(var);
        if (null != val && val instanceof Variable && null != (deepVal = this.getValue((Variable)val))) {
            val = deepVal;
        }
        return val;
    }

    @Override
    public Iterator<Variable> varIterator() {
        return this.keySet().iterator();
    }

    public int makeNewIndex(int fs1Index, int fs2Index) {
        int index = UnifyControl.getUniqueFeatureStructureIndex();
        int fs1IndexUpdated = this.getUpdatedIndex(fs1Index);
        int fs2IndexUpdated = this.getUpdatedIndex(fs2Index);
        this.addReindex(fs1IndexUpdated, index);
        this.addReindex(fs2IndexUpdated, index);
        return index;
    }

    public void addReindex(int oldIndex, int newIndex) {
        if (oldIndex == newIndex) {
            return;
        }
        if (this._newFeatStrucIndexes.containsKey(newIndex)) {
            throw new RuntimeException("Whoops!  Index map already contains newIndex: " + newIndex + "\n" + this);
        }
        this._newFeatStrucIndexes.put(oldIndex, newIndex);
    }

    public int getUpdatedIndex(int oldIndex) {
        if (!this._newFeatStrucIndexes.containsKey(oldIndex)) {
            return oldIndex;
        }
        return this.getUpdatedIndex(this._newFeatStrucIndexes.get(oldIndex));
    }

    public void addIndexedObject(int index, Object o) {
        this._indexedObjects.put(index, o);
    }

    public Object getIndexedObject(int index) {
        return this._indexedObjects.get(this.getUpdatedIndex(index));
    }

    public void condense() throws UnifyFailure {
        int i;
        int[] keys = this._indexedObjects.keys();
        for (i = 0; i < keys.length; ++i) {
            Object obj = this._indexedObjects.get(keys[i]);
            if (!(obj instanceof Unifiable)) continue;
            Object filled = ((Unifiable)obj).fill(this);
            this._indexedObjects.put(keys[i], filled);
        }
        for (i = 0; i < keys.length; ++i) {
            if (!this._newFeatStrucIndexes.containsKey(keys[i])) continue;
            this._indexedObjects.remove(keys[i]);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("vars: \t");
        for (Object key : this.keySet()) {
            sb.append(key).append('=').append(this.get(key)).append('\t');
        }
        sb.append('\n');
        sb.append("indexes: \t");
        int[] indexKeys = this._newFeatStrucIndexes.keys();
        for (int i = 0; i < indexKeys.length; ++i) {
            sb.append(indexKeys[i] + "->" + this._newFeatStrucIndexes.get(indexKeys[i]) + "\t");
        }
        return sb.toString();
    }
}

