/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import opennlp.ccgbank.CCGBankTask;
import opennlp.ccgbank.TemplatesProcessor;
import opennlp.ccgbank.XMLFilterProcessor;
import opennlp.ccgbank.convert.InfoHelper;
import opennlp.ccgbank.convert.MorphLookup;
import opennlp.ccgbank.convert.XSLTTrueCaser;
import opennlp.ccgbank.parse.CCGbankDerivation;
import opennlp.ccgbank.parse.SimpleNode;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.transform.JDOMSource;
import org.xml.sax.InputSource;

public class CCGBankConvert
extends CCGBankTask {
    boolean keepPPHeads = false;
    TreeWalker treeWalker = new TreeWalker();
    CCGbankDerivation deriv = null;
    File auxFileDirectory;
    File bbnAuxDirectory;
    File wordsFile;
    File stemsFile;
    File currentDirectory = null;

    @Override
    protected void start() throws BuildException {
        InfoHelper.init(this.auxFileDirectory, this.bbnAuxDirectory);
        String trueCaseListPath = this.auxFileDirectory.getAbsolutePath() + "/truecase-list.gz";
        XSLTTrueCaser.init(trueCaseListPath);
        try {
            MorphLookup.init(this.wordsFile, this.stemsFile);
        }
        catch (IOException io) {
            throw new BuildException("problem loading words or stems", (Throwable)io, this.getLocation());
        }
        this.xsltProcessor = this.useXMLFilter ? new XMLFilterProcessor(this, this) : new TemplatesProcessor(this);
        try {
            File tmp = File.createTempFile(this.getClass().getName(), "prime");
            tmp.deleteOnExit();
            this.deriv = new CCGbankDerivation(new FileReader(tmp));
        }
        catch (IOException e) {
            throw new BuildException("Problem priming parser: " + e.getMessage(), (Throwable)e, this.getLocation());
        }
    }

    @Override
    protected void nextDirectory(File section) throws BuildException {
        this.currentDirectory = section;
        File d = new File(this.target, this.currentDirectory.getName());
        if (!d.exists() && !d.mkdirs()) {
            throw new BuildException("unable to create directory " + d);
        }
        try {
            InfoHelper.readBBNAuxfiles(section.getName());
            InfoHelper.readQuoteAuxfiles(section.getName());
            InfoHelper.readPTBAuxfiles(section.getName());
            InfoHelper.readTreeAuxfiles(section.getName());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    protected InputSource nextFile(File file) throws BuildException {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            if (this.deriv == null) {
                this.deriv = new CCGbankDerivation(reader);
            } else {
                CCGbankDerivation.ReInit(reader);
            }
            SimpleNode root = CCGbankDerivation.start();
            Element result = new Element("Derivation");
            String fileName = file.getName();
            int start2 = fileName.contains(File.separator) ? fileName.lastIndexOf(File.separatorChar) : 0;
            StringBuilder sb = new StringBuilder(fileName.substring(start2, fileName.lastIndexOf(46)));
            sb.append(".xml");
            File targetDir = new File(this.target, this.currentDirectory.getName());
            File targetFile = new File(targetDir, sb.toString());
            this.xsltProcessor.resetSerializer();
            this.xsltProcessor.setTarget(targetFile);
            Document doc = new Document(this.treeWalker.eval(root, result));
            JDOMSource s = new JDOMSource(doc);
            s.setSystemId(file.toURI().toString());
            return SAXSource.sourceToInputSource((Source)s);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    public void setKeepPPHeads(boolean keepPPHeads) {
        this.keepPPHeads = keepPPHeads;
    }

    public void setStemsFile(File stemsFile) {
        this.stemsFile = stemsFile;
    }

    public void setWordsFile(File wordsFile) {
        this.wordsFile = wordsFile;
    }

    public void setAuxFileDirectory(File auxFileDirectory) {
        this.auxFileDirectory = auxFileDirectory;
    }

    public void setBbnAuxDirectory(File bbnAuxDirectory) {
        this.bbnAuxDirectory = bbnAuxDirectory;
    }

    public static void main(String[] args) {
        File baseDir = new File(System.getProperty("user.dir"));
        File buildFile = new File(baseDir, "build.xml");
        Project project = new Project();
        project.init();
        project.setBaseDir(baseDir);
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        project.setProjectReference((Object)helper);
        helper.parse(project, (Object)buildFile);
        DefaultLogger logger = new DefaultLogger();
        logger.setErrorPrintStream(System.err);
        logger.setOutputPrintStream(System.out);
        project.addBuildListener((BuildListener)logger);
        project.executeTarget("convert-base");
    }

    private String stripPPHeads(String cat) {
        if (this.keepPPHeads) {
            return cat;
        }
        return cat.replaceAll("pp\\[[a-z]+\\]", "pp");
    }

    private String adjustRole(String role) {
        int hyph;
        role = role.replaceFirst("ARG", "Arg");
        if (!this.keepPPHeads && (hyph = role.indexOf(45)) > 0) {
            role = role.substring(0, hyph);
        }
        return role;
    }

    class TreeWalker {
        public List<String> idList = new ArrayList<String>();
        private boolean underLeaf = false;

        TreeWalker() {
        }

        public Element eval(SimpleNode node, Element root) throws Exception {
            int numC = node.jjtGetNumChildren();
            int i = 0;
            for (i = 0; i < numC; ++i) {
                SimpleNode child = (SimpleNode)node.jjtGetChild(i);
                if (child.type.equals("Redundant")) {
                    if (node.type.equals("Leafnode")) {
                        node.catRedundant = child.print();
                        continue;
                    }
                    if (node.type.equals("Treenode")) {
                        child.type = "complexcat";
                    }
                }
                if (child.type.equals("Header")) {
                    ++i;
                    String temp1 = child.getHeader();
                    int spacePos = temp1.indexOf(32);
                    if (spacePos > 0) {
                        temp1 = temp1.substring(0, spacePos);
                    }
                    child = (SimpleNode)node.jjtGetChild(i);
                    child.setHeader(temp1);
                }
                Element leaf = new Element(child.type);
                if (child.type.equals("complexcat") || child.type.equals("Treenode") || child.type.equals("Leafnode")) {
                    if (child.jjtGetNumChildren() == 1 && child.type.equals("complexcat")) {
                        child = (SimpleNode)child.jjtGetChild(0);
                        leaf = new Element("atomcat");
                        node.cat = child.print();
                    } else {
                        leaf = this.ccinserter(child, leaf);
                        if (root.getName().equals("Leafnode")) {
                            node.cat = child.print();
                        }
                        if (root.getName().equals("Treenode") && leaf.getName().equals("complexcat")) {
                            node.cat = child.print();
                        }
                        leaf = this.eval(child, leaf);
                        if (!child.type.equals("complexcat")) {
                            leaf = this.catInserter(child, leaf);
                        }
                        root.addContent((Content)leaf);
                        continue;
                    }
                }
                if (child.cat.equals("/") || child.cat.equals("\\")) {
                    leaf = this.opinserter(child);
                    root.addContent((Content)leaf);
                    continue;
                }
                leaf = this.atomcatinserter(child);
                root.addContent((Content)leaf);
            }
            return root;
        }

        public Element ccinserter(SimpleNode node, Element leaf) {
            String name = node.type;
            String h = node.getHeader();
            if (h != null) {
                leaf.setAttribute("Header", h);
            }
            if (name.equals("Treenode")) {
                leaf.setAttribute("head", node.head);
                leaf.setAttribute("dtr", node.dtr);
                this.idList.clear();
                this.underLeaf = false;
            }
            if (name.equals("Leafnode")) {
                leaf.setAttribute("lexeme", node.lex);
                leaf.setAttribute("lexeme0", node.lex);
                leaf.setAttribute("pos", node.pos);
                this.idList.clear();
                this.underLeaf = true;
            }
            if (node.nodeRoles != null) {
                String roles = "";
                for (SimpleNode.LexSenseRole lexSenseRole : node.nodeRoles) {
                    if (lexSenseRole.role.equals("rel")) {
                        leaf.setAttribute("rel", lexSenseRole.lex + "." + lexSenseRole.sense);
                        continue;
                    }
                    String role = CCGBankConvert.this.adjustRole(lexSenseRole.role);
                    roles = roles + lexSenseRole.lex + "." + lexSenseRole.sense + ":" + role + " ";
                }
                if (roles.length() > 0) {
                    leaf.setAttribute("roles", roles.trim());
                }
            }
            if (node.argRoles != null) {
                String args = "";
                for (String role : node.argRoles) {
                    role = CCGBankConvert.this.adjustRole(role);
                    args = args + role + " ";
                }
                leaf.setAttribute("argRoles", args.trim());
            }
            return leaf;
        }

        public Element atomcatinserter(SimpleNode node) throws Exception {
            StringTokenizer lex;
            Element atomcat2 = new Element("atomcat");
            Element fs = new Element("fs");
            Element feat = new Element("feat");
            String id = "NotGiven";
            String elem = node.print();
            if (elem.contains("_")) {
                lex = new StringTokenizer(elem, "_");
                elem = lex.nextToken();
                id = lex.nextToken();
                String[] x = id.split(":");
                if (x.length == 2) {
                    atomcat2.setAttribute("dep", x[1]);
                }
                id = id.replaceAll(":[A-Z]", "");
            } else {
                id = Integer.toString(this.idList.size() + 1);
                this.idList.add(id);
            }
            if (!this.idList.contains(id)) {
                this.idList.add(id);
            }
            id = Integer.toString(this.idList.indexOf(id) + 1);
            if (this.underLeaf) {
                fs.setAttribute("id", id);
            }
            elem = elem.toLowerCase();
            elem = elem.replaceAll("np\\[nb\\]", "np");
            if ((elem = CCGBankConvert.this.stripPPHeads(elem)).contains("[")) {
                lex = new StringTokenizer(elem, "[,]");
                elem = lex.nextToken();
                String form = lex.nextToken();
                feat = new Element("feat");
                feat.setAttribute("attr", "form");
                feat.setAttribute("val", form);
                fs.addContent((Content)feat);
            }
            if (this.underLeaf || fs.getContentSize() > 0) {
                atomcat2.addContent((Content)fs);
            }
            atomcat2.setAttribute("type", elem);
            return atomcat2;
        }

        public Element opinserter(SimpleNode node) {
            Element slash = new Element("slash");
            String op2 = node.cat;
            String dir = op2.equals("\\") ? "<" : ">";
            slash.setAttribute("dir", op2);
            slash.setAttribute("mode", dir);
            return slash;
        }

        public Element catInserter(SimpleNode node, Element leaf) {
            String l;
            if (this.idList.size() > 0) {
                for (int i = 0; i < this.idList.size(); ++i) {
                    node.cat = node.cat.replaceAll(this.idList.get(i), Integer.toString(i + 1));
                }
            }
            if ((l = node.getLeftover()) != null) {
                node.cat = node.cat + l;
            }
            int ind = node.cat.indexOf(")_");
            while (ind != -1) {
                String str1 = node.cat.substring(0, ind + 1);
                String str2 = node.cat.substring(ind + 1, node.cat.length());
                str2 = str2.replaceFirst("_(\\p{Digit})++", "");
                node.cat = str1 + str2;
                ind = node.cat.indexOf(")_");
            }
            node.cat = node.cat.replaceAll(":[A-Z]", "");
            String cat = node.cat.toLowerCase();
            cat = cat.replaceAll("np\\[nb\\]", "np");
            cat = CCGBankConvert.this.stripPPHeads(cat);
            leaf.setAttribute("cat", cat);
            String cat0 = "";
            cat0 = node.type.equals("Treenode") ? node.cat : node.catRedundant;
            leaf.setAttribute("cat0", cat0);
            this.idList.clear();
            return leaf;
        }
    }
}

