/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.EnumMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import opennlp.ccgbank.CCGBankTask;
import opennlp.ccgbank.CCGBankTaskTemplates;
import opennlp.ccgbank.CCGBankTaskTestbed;
import opennlp.ccgbank.TemplatesProcessor;
import opennlp.ccgbank.XMLFilterProcessor;
import opennlp.ccgbank.XSLTProcessor;
import opennlp.ccgbank.extract.FreqTally;
import opennlp.ccgbank.extract.RulesTally;
import opennlp.ccgbank.extract.Testbed;
import org.apache.tools.ant.BuildException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CCGBankExtract
extends CCGBankTask
implements URIResolver {
    static String pkgPath = null;
    static final String LEXICON_TEMPLATE = "lexicon-base.xsl";
    static final String RULES_TEMPLATE = "rules-base.xsl";
    String grammarName = "ccgbankextract";
    boolean pPheads = true;
    boolean skipUnmatched = false;
    int catFreqCutoff = 1;
    int lexFreqCutoff = 1;
    int openFreqCutoff = 100;
    int ruleFreqCutoff = 1;
    CCGBankTaskTestbed testbed = null;
    File lexiconTempFile;
    File rulesTempFile;
    TemplatesProcessor ruleProcessor;
    Map<CCGBankTaskTemplates.Type, XSLTProcessor> xsltProcessors = new EnumMap<CCGBankTaskTemplates.Type, XSLTProcessor>(CCGBankTaskTemplates.Type.class);

    public CCGBankExtract() {
        if (pkgPath == null) {
            pkgPath = this.getClass().getPackage().getName().replace('.', '/');
        }
    }

    public void setGrammarName(String grammarName) {
        this.grammarName = grammarName;
    }

    public void addConfiguredTestbed(CCGBankTaskTestbed tb) {
        this.testbed = tb;
    }

    public void setCatFreqCutoff(int catFreqCutoff) {
        this.catFreqCutoff = catFreqCutoff;
    }

    public void setLexFreqCutoff(int lexFreqCutoff) {
        this.lexFreqCutoff = lexFreqCutoff;
    }

    public void setOpenFreqCutoff(int openFreqCutoff) {
        this.openFreqCutoff = openFreqCutoff;
    }

    public void setPPheads(boolean pPheads) {
        this.pPheads = pPheads;
    }

    public void setRuleFreqCutoff(int ruleFreqCutoff) {
        this.ruleFreqCutoff = ruleFreqCutoff;
    }

    public void setSkipUnmatched(boolean skipUnmatched) {
        this.skipUnmatched = skipUnmatched;
    }

    @Override
    public Source resolve(String href, String base) {
        if (href != null && href.length() > 0 && href.startsWith(pkgPath)) {
            String lastChunk;
            String string = lastChunk = href.contains("/") && !href.endsWith("/") ? href.substring(href.lastIndexOf(47) + 1) : href;
            if (lastChunk.endsWith(LEXICON_TEMPLATE) || lastChunk.endsWith(RULES_TEMPLATE)) {
                return new StreamSource(this.getResource(href));
            }
        }
        return new StreamSource(new File(href));
    }

    @Override
    public void addConfiguredTemplates(CCGBankTaskTemplates taskTemplates) {
        if (this.xsltProcessors.containsKey((Object)taskTemplates.type)) {
            throw new BuildException((Object)((Object)taskTemplates.type) + " extraction type is multiply defined");
        }
        XSLTProcessor xp = this.useXMLFilter ? new XMLFilterProcessor(this, this) : new TemplatesProcessor(this);
        xp.addTemplates(taskTemplates);
        xp.transformerFactory.setURIResolver(this);
        this.xsltProcessors.put(taskTemplates.type, xp);
    }

    @Override
    protected void start() throws BuildException {
        this.xsltProcessor = new TemplatesProcessor(this);
        ((TemplatesProcessor)this.xsltProcessor).addTemplates(this.loadTemplates(pkgPath + "/" + LEXICON_TEMPLATE));
        this.ruleProcessor = new TemplatesProcessor(this);
        this.ruleProcessor.addTemplates(this.loadTemplates(pkgPath + "/" + RULES_TEMPLATE));
        FreqTally.reset();
        FreqTally.CAT_FREQ_CUTOFF = this.catFreqCutoff;
        FreqTally.LEX_FREQ_CUTOFF = this.lexFreqCutoff;
        FreqTally.OPEN_FREQ_CUTOFF = this.openFreqCutoff;
        RulesTally.reset();
        RulesTally.RULE_FREQ_CUTOFF = this.ruleFreqCutoff;
        RulesTally.KEEP_UNMATCHED = !this.skipUnmatched;
        try {
            this.lexiconTempFile = File.createTempFile(this.grammarName, ".xml");
            this.lexiconTempFile.deleteOnExit();
            this.xsltProcessor.setTarget(this.lexiconTempFile);
            this.rulesTempFile = File.createTempFile(this.grammarName + "-rules", ".xml");
            this.rulesTempFile.deleteOnExit();
            this.ruleProcessor.setTarget(this.rulesTempFile);
            Writer w = this.xsltProcessor.serializer.getWriter();
            w.write("<ccg-lexicon>");
            w.flush();
            Writer rw = this.ruleProcessor.serializer.getWriter();
            rw.write("<rules>");
            rw.flush();
        }
        catch (IOException io) {
            throw new BuildException((Throwable)io, this.getLocation());
        }
    }

    @Override
    protected InputSource nextFile(File file) throws BuildException {
        try {
            this.ruleProcessor.process(super.nextFile(file));
        }
        catch (IOException io) {
            throw new BuildException("I/O problem processing " + file + ": " + io.getMessage(), (Throwable)io, this.getLocation());
        }
        catch (SAXException se) {
            throw new BuildException("Problem processing " + file + ": " + se.getMessage(), (Throwable)se, this.getLocation());
        }
        catch (TransformerException te) {
            throw new BuildException("Problem processing " + file + ": " + te.getMessageAndLocation(), (Throwable)te, this.getLocation());
        }
        return super.nextFile(file);
    }

    @Override
    protected void finish() throws BuildException {
        try {
            Writer w = this.xsltProcessor.serializer.getWriter();
            w.write("</ccg-lexicon>");
            w.close();
            Writer rw = this.ruleProcessor.serializer.getWriter();
            rw.write("</rules>");
            rw.close();
        }
        catch (IOException io) {
            throw new BuildException((Throwable)io, this.getLocation());
        }
        for (CCGBankTaskTemplates.Type t : this.xsltProcessors.keySet()) {
            if (t == CCGBankTaskTemplates.Type.LEXICON) {
                try {
                    FreqTally.printTally(this.target);
                }
                catch (FileNotFoundException fnfe) {
                    throw new BuildException("problem generating frequencies", (Throwable)fnfe, this.getLocation());
                }
            }
            if (t == CCGBankTaskTemplates.Type.RULES) {
                try {
                    RulesTally.printTally(this.target);
                }
                catch (FileNotFoundException fnfe) {
                    throw new BuildException("problem generating rule frequencies", (Throwable)fnfe, this.getLocation());
                }
            }
            String fileName = t.fileName();
            this.log("Generating " + fileName);
            try {
                XSLTProcessor xp = this.xsltProcessors.get((Object)t);
                xp.setTarget(new File(this.target, fileName));
                xp.process(new InputSource(new BufferedInputStream(new FileInputStream(t == CCGBankTaskTemplates.Type.RULES ? this.rulesTempFile : this.lexiconTempFile))));
            }
            catch (IOException io) {
                throw new BuildException("I/O problem writing " + fileName, (Throwable)io, this.getLocation());
            }
            catch (TransformerException te) {
                throw new BuildException("Problem transforming " + fileName + ": " + te.getMessageAndLocation(), (Throwable)te, this.getLocation());
            }
            catch (SAXException se) {
                throw new BuildException("Problem transforming " + fileName + ": " + se.getMessage(), (Throwable)se, this.getLocation());
            }
        }
        try {
            File gramFile = new File(this.target, "grammar.xml");
            if (!gramFile.exists()) {
                this.log("Generating grammar.xml");
                PrintWriter gramOut = new PrintWriter(new FileWriter(gramFile));
                gramOut.println("<?xml version=\"1.0\"?>");
                gramOut.println("<grammar name=\"" + this.grammarName + "\"");
                gramOut.println("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                gramOut.println("  xsi:noNamespaceSchemaLocation=\"../grammar.xsd\"");
                gramOut.println(">");
                gramOut.println("  <lexicon file=\"lexicon.xml\"/>");
                gramOut.println("  <morphology file=\"morph.xml\"/>");
                gramOut.println("  <rules file=\"rules.xml\"/>");
                gramOut.println("<tokenizer replacement-sem-classes=\"DATE LOCATION MONEY ORGANIZATION PERCENT PERSON TIME\"/>");
                gramOut.println("<LF-from-XML>");
                gramOut.println("<transform file=\"convert-to-hlds.xsl\"/>");
                gramOut.println("<transform file=\"add-chunks.xsl\"/>");
                gramOut.println("</LF-from-XML>");
                gramOut.println("<LF-to-XML>");
                gramOut.println("<transform file=\"raise-nodes.xsl\"/>");
                gramOut.println("<transform file=\"convert-to-graph.xsl\"/>");
                gramOut.println("</LF-to-XML>");
                gramOut.println("</grammar>");
                gramOut.close();
            }
        }
        catch (IOException io) {
            throw new BuildException("problem generating grammar.xml", (Throwable)io, this.getLocation());
        }
        if (this.testbed != null) {
            this.log("Creating testbed ...");
            try {
                Testbed ct = new Testbed(this.ccgBankTaskSources, this.target, this.testbed);
                ct.createTestFiles();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BuildException("problem generating testbed: " + e.getMessage(), (Throwable)e, this.getLocation());
            }
        }
    }

    Templates loadTemplates(String resourceName) throws BuildException {
        try {
            SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
            return tf.newTemplates(new StreamSource(new BufferedInputStream(this.getResource(resourceName))));
        }
        catch (TransformerConfigurationException e) {
            throw new BuildException("Problem loading template " + resourceName + ": " + e.getMessage(), (Throwable)e, this.getLocation());
        }
    }

    InputStream getResource(String resourceName) {
        return this.getClass().getClassLoader().getResourceAsStream(resourceName);
    }
}

