/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank.extract;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import opennlp.ccgbank.extract.ExtractGrammar;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.jdom.JDOMException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MorphExtract {
    public static void extractMorph(ExtractGrammar.ExtractionProperties extractProps) throws TransformerException, TransformerConfigurationException, SAXException, IOException, JDOMException {
        System.out.println("Extracting morph:");
        System.out.println("Generating morph.xml");
        TransformerFactory tFactory = TransformerFactory.newInstance();
        File morphFile = new File(new File(extractProps.destDir), "morph.xml");
        File tempFile = new File(new File(extractProps.tempDir), "temp.xml");
        if (tFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") && tFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
            SAXTransformerFactory saxTFactory = (SAXTransformerFactory)tFactory;
            ArrayList<XMLFilter> filterChain = new ArrayList<XMLFilter>();
            ArrayList<String> xslChain = new ArrayList<String>();
            if (extractProps.macroSpecs.length() > 0) {
                // empty if block
            }
            MorphExtract.addTransforms(xslChain, extractProps.macroSpecs);
            for (String xslFile : xslChain) {
                filterChain.add(saxTFactory.newXMLFilter(ExtractGrammar.getSource(xslFile)));
            }
            XMLReader reader = XMLReaderFactory.createXMLReader();
            XMLFilter xmlFilter0 = (XMLFilter)filterChain.get(0);
            xmlFilter0.setParent(reader);
            for (int i = 1; i < filterChain.size(); ++i) {
                XMLFilter xmlFilterPrev = (XMLFilter)filterChain.get(i - 1);
                XMLFilter xmlFilterCurr = (XMLFilter)filterChain.get(i);
                xmlFilterCurr.setParent(xmlFilterPrev);
            }
            XMLFilter xmlFilter = (XMLFilter)filterChain.get(filterChain.size() - 1);
            Properties xmlProps = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
            xmlProps.setProperty("indent", "yes");
            xmlProps.setProperty("standalone", "no");
            xmlProps.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            Serializer serializer = SerializerFactory.getSerializer((Properties)xmlProps);
            serializer.setOutputStream((OutputStream)new FileOutputStream(morphFile));
            xmlFilter.setContentHandler(serializer.asContentHandler());
            xmlFilter.parse(new InputSource(tempFile.getPath()));
        }
    }

    public static void addTransforms(ArrayList<String> xslChain, String macroSpecs) {
        xslChain.add("opennlp.ccgbank/transform/morphExtr.xsl");
        if (macroSpecs.length() == 0) {
            xslChain.add("opennlp.ccgbank/transform/macroInsert.xsl");
        }
        if (macroSpecs.contains("agr")) {
            System.out.println("Inserting a macro to check agreement in the copula");
            xslChain.add("opennlp.ccgbank/transform/agr-macroInsert.xsl");
        }
        if (macroSpecs.contains("anim")) {
            System.out.println("Inserting a macro to check animacy constraints");
            xslChain.add("opennlp.ccgbank/transform/anim-macroInsert.xsl");
        }
    }
}

