/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank.extract;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import opennlp.ccgbank.extract.ExtractGrammar;
import opennlp.ccgbank.extract.RulesTally;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.jdom.JDOMException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class RulesExtract {
    public static void extractRules(ExtractGrammar.ExtractionProperties extractProps) throws TransformerException, TransformerConfigurationException, SAXException, IOException, JDOMException {
        System.out.println("Extracting rule info:");
        File rulesFile = new File(new File(extractProps.destDir), "rules.xml");
        File tempFile = new File(new File(extractProps.tempDir), "temp-rules.xml");
        PrintWriter tempOut = new PrintWriter(new FileOutputStream(tempFile), true);
        File ccgbankDir = new File(extractProps.srcDir);
        Object[] ccgbankSections = ccgbankDir.listFiles();
        Arrays.sort(ccgbankSections);
        RulesTally.RULE_FREQ_CUTOFF = extractProps.ruleFreqCutoff;
        RulesTally.KEEP_UNMATCHED = !extractProps.skipUnmatched;
        tempOut.println("<rules>");
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(ExtractGrammar.getSource("opennlp.ccgbank/transform/rulesExtr.xsl"));
        for (int i = extractProps.startSection; i <= extractProps.endSection; ++i) {
            Object[] files = ((File)ccgbankSections[i]).listFiles();
            Arrays.sort(files);
            int fileStart = 0;
            int fileLimit = files.length;
            if (extractProps.fileNum >= 0) {
                fileStart = extractProps.fileNum;
                fileLimit = extractProps.fileNum + 1;
            }
            for (int j = fileStart; j < fileLimit; ++j) {
                String inputFile = ((File)files[j]).getAbsolutePath();
                if (j == fileStart) {
                    System.out.print(((File)files[j]).getName() + " ");
                } else if (j == fileLimit - 1) {
                    System.out.println(" " + ((File)files[j]).getName());
                } else {
                    System.out.print(".");
                }
                if (fileStart == fileLimit - 1) {
                    System.out.println();
                }
                try {
                    transformer.transform(new StreamSource(inputFile), new StreamResult(tempOut));
                }
                catch (Exception exc) {
                    System.out.println("Skipping: " + inputFile);
                    System.out.println(exc.toString());
                }
                tempOut.flush();
            }
        }
        tempOut.flush();
        tempOut.println("</rules>");
        tempOut.close();
        RulesTally.printTally(extractProps);
        System.out.println("Generating rules.xml");
        if (tFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") && tFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
            SAXTransformerFactory saxTFactory = (SAXTransformerFactory)tFactory;
            XMLFilter xmlFilter1 = saxTFactory.newXMLFilter(ExtractGrammar.getSource("opennlp.ccgbank/transform/ccgRules.xsl"));
            XMLReader reader = XMLReaderFactory.createXMLReader();
            xmlFilter1.setParent(reader);
            Properties xmlProps = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
            xmlProps.setProperty("indent", "yes");
            xmlProps.setProperty("standalone", "no");
            xmlProps.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            Serializer serializer = SerializerFactory.getSerializer((Properties)xmlProps);
            serializer.setOutputStream((OutputStream)new FileOutputStream(rulesFile));
            XMLFilter xmlFilter = xmlFilter1;
            xmlFilter.setContentHandler(serializer.asContentHandler());
            xmlFilter.parse(new InputSource(tempFile.getPath()));
        }
    }
}

