/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.alignment;

public enum IndexBase {
    ZERO,
    ONE;

    final Integer start = this.ordinal();
    final Integer nullValue = this.start - 1;

    public Integer getStart() {
        return this.start;
    }

    public Integer getNullValue() {
        return this.nullValue;
    }

    public boolean isValidIndex(Integer index) {
        return index != null && this.nullValue <= index;
    }

    public Integer translate(Integer index, IndexBase target) {
        if (!this.isValidIndex(index)) {
            throw new IllegalArgumentException("invalid index for index base " + this.name() + ": " + index);
        }
        if (target == this) {
            return index;
        }
        return index + (target.start - this.start);
    }
}

