/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo;

import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.grammar.Types;
import opennlp.ccg.hylo.Box;
import opennlp.ccg.hylo.Compacter;
import opennlp.ccg.hylo.Converter;
import opennlp.ccg.hylo.Diamond;
import opennlp.ccg.hylo.Flattener;
import opennlp.ccg.hylo.HyloVar;
import opennlp.ccg.hylo.LexDependency;
import opennlp.ccg.hylo.ModeLabel;
import opennlp.ccg.hylo.ModeVar;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.hylo.NominalAtom;
import opennlp.ccg.hylo.NominalVar;
import opennlp.ccg.hylo.Op;
import opennlp.ccg.hylo.Proposition;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.lexicon.Lexicon;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.LexSemOrigin;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.unify.SimpleType;
import opennlp.ccg.unify.UnifyFailure;
import org.jdom.Content;
import org.jdom.Element;

public class HyloHelper {
    private static final Comparator<LF> predComparator = new Comparator<LF>(){

        @Override
        public int compare(LF lf1, LF lf2) {
            Integer rel2Index;
            int nomCompare = HyloHelper.getPrincipalNominal(lf1).compareTo(HyloHelper.getPrincipalNominal(lf2));
            if (nomCompare != 0) {
                return nomCompare;
            }
            int typeCompare = HyloHelper.epType(lf1).compareTo(HyloHelper.epType(lf2));
            if (typeCompare != 0) {
                return typeCompare;
            }
            if (HyloHelper.isLexPred(lf1)) {
                return HyloHelper.getLexPred(lf1).compareToIgnoreCase(HyloHelper.getLexPred(lf2));
            }
            String rel1 = HyloHelper.getRel(lf1);
            String rel2 = HyloHelper.getRel(lf2);
            Lexicon theLexicon = Grammar.theGrammar.lexicon;
            Integer rel1Index = theLexicon.getRelationSortIndex(rel1);
            int relIndexCompare = rel1Index.compareTo(rel2Index = theLexicon.getRelationSortIndex(rel2));
            if (relIndexCompare != 0) {
                return relIndexCompare;
            }
            int relCompare = rel1.compareToIgnoreCase(rel2);
            if (relCompare != 0) {
                return relCompare;
            }
            if (HyloHelper.isRelPred(lf1)) {
                return HyloHelper.getSecondaryNominal(lf1).compareTo(HyloHelper.getSecondaryNominal(lf2));
            }
            return 0;
        }
    };
    private static Integer LEX_PRED = new Integer(1);
    private static Integer ATTR_PRED = new Integer(2);
    private static Integer REL_PRED = new Integer(3);

    public static LF getLF(Element e) {
        String chunks;
        String name;
        LF retval = null;
        String type = e.getName();
        if (type.equals("op")) {
            retval = new Op(e);
        } else if (type.equals("var")) {
            name = HyloHelper.getName(e);
            retval = new HyloVar(HyloHelper.prefix(name), HyloHelper.type(name));
        } else if (type.equals("nomvar")) {
            name = HyloHelper.getName(e);
            boolean shared = "true".equals(e.getAttributeValue("shared"));
            retval = new NominalVar(HyloHelper.prefix(name), HyloHelper.type(name), shared);
        } else if (type.equals("nom")) {
            name = HyloHelper.getName(e);
            boolean shared = "true".equals(e.getAttributeValue("shared"));
            retval = new NominalAtom(HyloHelper.prefix(name), HyloHelper.type(name), shared);
        } else if (type.equals("prop")) {
            name = HyloHelper.getName(e);
            retval = new Proposition(name, HyloHelper.existingType(name));
        } else if (type.equals("satop")) {
            retval = new SatOp(e);
        } else if (type.equals("box") || type.equals("b")) {
            retval = new Box(e);
        } else if (type.equals("diamond") || type.equals("d")) {
            retval = new Diamond(e);
        } else if (type.equals("mode")) {
            name = HyloHelper.getName(e);
            retval = new ModeLabel(name);
        } else if (type.equals("modevar")) {
            name = HyloHelper.getName(e);
            retval = new ModeVar(name);
        } else if (type.equals("lf")) {
            retval = HyloHelper.getLF_FromChildren(e);
        } else {
            System.out.println("Invalid hybrid logic LF type: " + type);
        }
        if (retval != null && (chunks = e.getAttributeValue("chunks")) != null) {
            retval.setChunks(HyloHelper.convertChunks(chunks));
        }
        return retval;
    }

    private static String getName(Element e) {
        String name = e.getAttributeValue("name");
        if (name == null) {
            name = e.getAttributeValue("n");
        }
        return name;
    }

    private static SimpleType existingType(String name) {
        Types types = Grammar.theGrammar.types;
        if (types.containsSimpleType(name)) {
            return types.getSimpleType(name);
        }
        return null;
    }

    protected static String prefix(String name) {
        int index = name.indexOf(":");
        if (index >= 0) {
            return name.substring(0, index);
        }
        return name;
    }

    protected static SimpleType type(String name) {
        String suffix;
        int index = name.indexOf(":");
        String string = suffix = index >= 0 && index + 1 < name.length() ? name.substring(index + 1) : null;
        if (suffix != null) {
            return Grammar.theGrammar.types.getSimpleType(suffix);
        }
        return null;
    }

    public static LF getLF_FromChildren(Element e) {
        List children = e.getChildren();
        if (children.size() > 1) {
            ArrayList<LF> preds = new ArrayList<LF>(children.size());
            for (int i = 0; i < children.size(); ++i) {
                preds.add(HyloHelper.getLF((Element)children.get(i)));
            }
            Op conj = new Op("conj", preds);
            return conj;
        }
        return HyloHelper.getLF((Element)children.get(0));
    }

    public static Element toXml(LF lf) {
        Element retval = new Element("lf");
        retval.addContent((Content)lf.toXml());
        HyloHelper.removeConjOps(retval);
        return retval;
    }

    public static void processChunks(Element e) {
        HyloHelper.processChunks(e, null, 0);
        HyloHelper.removeChunkElts(e);
    }

    private static int processChunks(Element e, String chunks, int count) {
        if (e.getName().equals("chunk")) {
            chunks = chunks == null ? "" + count : chunks + " " + count;
            ++count;
        } else if (chunks != null) {
            e.setAttribute("chunks", chunks);
        }
        List children = e.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            count = HyloHelper.processChunks((Element)children.get(i), chunks, count);
        }
        return count;
    }

    private static TIntArrayList convertChunks(String chunks) {
        String[] tokens = chunks.split("\\s+");
        TIntArrayList retval = new TIntArrayList(tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            retval.add(Integer.parseInt(tokens[i]));
        }
        return retval;
    }

    private static void removeElts(Element elt, ElementTest eltTest) {
        List children = elt.getChildren();
        ArrayList newChildren = new ArrayList(children.size());
        newChildren.addAll(children);
        ListIterator<Element> li = newChildren.listIterator();
        while (li.hasNext()) {
            Element nextElt = (Element)li.next();
            HyloHelper.removeElts(nextElt, eltTest);
            if (!eltTest.test(nextElt)) continue;
            li.remove();
            Iterator it = nextElt.getChildren().iterator();
            while (it.hasNext()) {
                Element childElt = (Element)it.next();
                it.remove();
                li.add(childElt);
            }
        }
        elt.removeContent();
        elt.setContent(newChildren);
    }

    private static void removeConjOps(Element lfElt) {
        HyloHelper.removeElts(lfElt, new ElementTest(){

            @Override
            boolean test(Element elt) {
                return elt.getName().equals("op") && elt.getAttributeValue("name").equals("conj");
            }
        });
    }

    private static void removeChunkElts(Element lfElt) {
        HyloHelper.removeElts(lfElt, new ElementTest(){

            @Override
            boolean test(Element elt) {
                return elt.getName().equals("chunk");
            }
        });
    }

    public static boolean isElementaryPredication(LF lf) {
        return HyloHelper.isLexPred(lf) || HyloHelper.isRelPred(lf) || HyloHelper.isAttrPred(lf);
    }

    public static boolean isLexPred(LF pred) {
        if (!(pred instanceof SatOp)) {
            return false;
        }
        SatOp satOp = (SatOp)pred;
        LF arg = satOp.getArg();
        return arg instanceof Proposition;
    }

    public static boolean isRelPred(LF pred) {
        if (!(pred instanceof SatOp)) {
            return false;
        }
        SatOp satOp = (SatOp)pred;
        LF arg = satOp.getArg();
        if (!(arg instanceof Diamond)) {
            return false;
        }
        Diamond d = (Diamond)arg;
        return d.getArg() instanceof Nominal;
    }

    public static boolean isAttrPred(LF pred) {
        if (!(pred instanceof SatOp)) {
            return false;
        }
        SatOp satOp = (SatOp)pred;
        LF arg = satOp.getArg();
        return HyloHelper.isAttr(arg);
    }

    public static boolean isAttr(LF arg) {
        if (!(arg instanceof Diamond)) {
            return false;
        }
        Diamond d = (Diamond)arg;
        LF dArg = d.getArg();
        return dArg instanceof Proposition || dArg instanceof HyloVar && !(dArg instanceof NominalVar);
    }

    public static String getLexPred(LF lf) {
        if (!HyloHelper.isLexPred(lf)) {
            return null;
        }
        LF arg = ((SatOp)lf).getArg();
        return ((Proposition)arg).toString();
    }

    public static String getRel(LF lf) {
        if (!HyloHelper.isRelPred(lf) && !HyloHelper.isAttrPred(lf)) {
            return null;
        }
        LF arg = ((SatOp)lf).getArg();
        return ((Diamond)arg).getMode().toString();
    }

    public static String getVal(LF lf) {
        if (!HyloHelper.isAttrPred(lf)) {
            return null;
        }
        LF arg = ((SatOp)lf).getArg();
        LF dArg = ((Diamond)arg).getArg();
        if (dArg instanceof Proposition) {
            return ((Proposition)dArg).getName();
        }
        return null;
    }

    public static Nominal getPrincipalNominal(LF lf) {
        if (!HyloHelper.isElementaryPredication(lf)) {
            return null;
        }
        return ((SatOp)lf).getNominal();
    }

    public static Nominal getSecondaryNominal(LF lf) {
        if (!HyloHelper.isRelPred(lf)) {
            return null;
        }
        LF arg = ((SatOp)lf).getArg();
        return (Nominal)((Diamond)arg).getArg();
    }

    public static LF flattenLF(LF lf) {
        List<LF> preds = HyloHelper.flatten(lf);
        if (preds.size() == 1) {
            return preds.get(0);
        }
        return new Op("conj", preds);
    }

    public static List<SatOp> getPreds(LF lf) {
        if (lf instanceof Op && ((Op)lf).getName().equals("conj")) {
            List<LF> args = ((Op)lf).getArguments();
            ArrayList<SatOp> retval = new ArrayList<SatOp>(args.size());
            for (LF arg : args) {
                retval.add((SatOp)arg);
            }
            return retval;
        }
        ArrayList<SatOp> retval = new ArrayList<SatOp>(1);
        retval.add((SatOp)lf);
        return retval;
    }

    public static SatOp getFirstPred(LF lf) {
        if (lf instanceof SatOp) {
            return (SatOp)lf;
        }
        if (lf instanceof Op && ((Op)lf).getName().equals("conj")) {
            List<LF> args = ((Op)lf).getArguments();
            return (SatOp)args.get(0);
        }
        return null;
    }

    public static List<SatOp> flatten(LF lf) {
        List<SatOp> retval = new Flattener().flatten(lf);
        HyloHelper.sort(retval);
        return retval;
    }

    public static LF firstEP(LF lf) {
        List<SatOp> preds = new Flattener().flatten(lf);
        return preds.get(0);
    }

    public static void setOrigin(LF lf, LexSemOrigin origin) {
        if (lf == null) {
            return;
        }
        if (lf instanceof SatOp) {
            ((SatOp)lf).setOrigin(origin);
        } else if (lf instanceof Op && ((Op)lf).getName().equals("conj")) {
            List<LF> args = ((Op)lf).getArguments();
            for (LF arg : args) {
                if (!(arg instanceof SatOp)) continue;
                ((SatOp)arg).setOrigin(origin);
            }
        }
    }

    public static Map<Nominal, Integer> nomIndex(List<SatOp> preds) {
        HashMap<Nominal, Integer> retval = new HashMap<Nominal, Integer>(preds.size() / 2);
        for (int i = 0; i < preds.size(); ++i) {
            SatOp pred = preds.get(i);
            Nominal nom = pred._nominal;
            if (retval.containsKey(nom)) continue;
            retval.put(nom, i);
        }
        return retval;
    }

    public static boolean isRoot(Nominal nom, List<SatOp> preds) {
        for (SatOp pred : preds) {
            Nominal child = HyloHelper.getSecondaryNominal(pred);
            if (child == null || !child.equals(nom)) continue;
            return false;
        }
        return true;
    }

    public static List<LexDependency> getUnfilledLexDeps(LF lf) {
        if (lf == null) {
            return Collections.emptyList();
        }
        return LexDependency.unfilledLexDeps(HyloHelper.getPreds(lf));
    }

    public static List<LexDependency> getFilledLexDeps(List<LexDependency> unfilled, LF lf) {
        if (lf == null) {
            return Collections.emptyList();
        }
        return LexDependency.filledLexDeps(unfilled, HyloHelper.getPreds(lf));
    }

    public static List<SatOp> getSemFeatsForHead(Nominal nominal, LF lf) {
        if (nominal == null || lf == null) {
            return Collections.emptyList();
        }
        ArrayList<SatOp> retval = new ArrayList<SatOp>(3);
        for (SatOp pred : HyloHelper.getPreds(lf)) {
            if (!nominal.equals(pred._nominal) || !HyloHelper.isAttrPred(pred)) continue;
            retval.add(pred);
        }
        return retval;
    }

    public static LF compactAndConvertNominals(LF lf, Nominal root) {
        LF retval = HyloHelper.compact(lf, root);
        HyloHelper.convertNominals(retval);
        return retval;
    }

    public static LF compactAndConvertNominals(LF lf, Nominal root, Sign rootSign) {
        root = HyloHelper.convertNominals(lf, rootSign, root);
        LF retval = HyloHelper.compact(lf, root);
        return retval;
    }

    public static LF compact(LF lf, Nominal root) {
        return Compacter.compact(lf, root);
    }

    public static void convertNominals(LF lf) {
        Converter.convertNominals(lf);
    }

    public static Nominal convertNominals(LF lf, Sign root, Nominal nominalRoot) {
        return Converter.convertNominals(lf, root, nominalRoot);
    }

    public static Nominal convertNominalsToVars(LF lf, Nominal nominalRoot) {
        return Converter.convertNominalsToVars(HyloHelper.getPreds(lf), nominalRoot);
    }

    public static LF append(LF lf1, LF lf2) {
        int size = 0;
        List<LF> args1 = null;
        if (lf1 instanceof Op && ((Op)lf1).getName().equals("conj")) {
            args1 = ((Op)lf1).getArguments();
            size += args1.size();
        } else if (lf1 != null) {
            ++size;
        }
        List<LF> args2 = null;
        if (lf2 instanceof Op && ((Op)lf2).getName().equals("conj")) {
            args2 = ((Op)lf2).getArguments();
            size += args2.size();
        } else if (lf2 != null) {
            ++size;
        }
        ArrayList<LF> combined = new ArrayList<LF>(size);
        if (args1 != null) {
            combined.addAll(args1);
        } else if (lf1 != null) {
            combined.add(lf1);
        }
        if (args2 != null) {
            combined.addAll(args2);
        } else if (lf2 != null) {
            combined.add(lf2);
        }
        if (combined.isEmpty()) {
            return null;
        }
        if (combined.size() == 1) {
            return (LF)combined.get(0);
        }
        return new Op("conj", combined);
    }

    public static void sort(LF lf) {
        if (lf instanceof Op && ((Op)lf).getName().equals("conj")) {
            HyloHelper.sort(((Op)lf).getArguments());
        }
    }

    public static void sort(List<? extends LF> preds) {
        Collections.sort(preds, predComparator);
    }

    private static Integer epType(LF lf) {
        if (HyloHelper.isLexPred(lf)) {
            return LEX_PRED;
        }
        if (HyloHelper.isAttrPred(lf)) {
            return ATTR_PRED;
        }
        if (HyloHelper.isRelPred(lf)) {
            return REL_PRED;
        }
        return null;
    }

    public static void check(LF lf) throws UnifyFailure {
        if (lf instanceof Op && ((Op)lf).getName().equals("conj")) {
            HyloHelper.check(((Op)lf).getArguments());
        }
    }

    private static void check(List<LF> preds) throws UnifyFailure {
        for (int i = 0; i < preds.size() - 1; ++i) {
            LF lf1 = preds.get(i);
            LF lf2 = preds.get(i + 1);
            if (!HyloHelper.isLexPred(lf1) || !HyloHelper.isLexPred(lf2) || !HyloHelper.getPrincipalNominal(lf1).equals(HyloHelper.getPrincipalNominal(lf2))) continue;
            throw new UnifyFailure();
        }
    }

    private static abstract class ElementTest {
        private ElementTest() {
        }

        abstract boolean test(Element var1);
    }
}

