/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo.graph;

import java.util.List;
import java.util.Map;
import opennlp.ccg.hylo.Diamond;
import opennlp.ccg.hylo.Flattener;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.hylo.Proposition;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.hylo.graph.DefaultLFEdgeFactory;
import opennlp.ccg.hylo.graph.LFEdgeFactory;
import opennlp.ccg.hylo.graph.LFEdgeLabel;
import opennlp.ccg.hylo.graph.LFGraph;
import opennlp.ccg.hylo.graph.LFVertex;
import opennlp.ccg.realize.Realizer;
import opennlp.ccg.synsem.LF;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;

public class LFGraphFactory {
    public static final LFEdgeFactory DEFAULT_EDGE_FACTORY = new DefaultLFEdgeFactory();
    static final DOMBuilder DOM_BUILDER = new DOMBuilder();
    static final Flattener FLATTENER = new Flattener();

    private LFGraphFactory() {
    }

    public static LFGraph newGraphFrom(org.w3c.dom.Element lfElement) {
        return LFGraphFactory.newGraphFrom(DOM_BUILDER.build(lfElement));
    }

    public static LFGraph newGraphFrom(Element lfElement) {
        return LFGraphFactory.newGraphFrom(Realizer.getLfFromElt(lfElement));
    }

    public static LFGraph newGraphFrom(LF lf) {
        if (lf == null) {
            throw new IllegalArgumentException("lf is null");
        }
        LFGraph g = new LFGraph(DEFAULT_EDGE_FACTORY);
        Flattener f = new Flattener();
        List<SatOp> satOps = f.flatten(lf);
        Map<Nominal, Nominal> ancestorMap = f.getHighestParentMap();
        for (SatOp so : satOps) {
            if (!HyloHelper.isLexPred(so)) continue;
            g.addVertex(new LFVertex(so.getNominal(), (Proposition)so.getArg()));
        }
        for (SatOp so : satOps) {
            Diamond d;
            if (!HyloHelper.isElementaryPredication(so)) continue;
            Nominal soNom = so.getNominal();
            LFVertex source = g.findVertexByNominal(soNom);
            if (source == null) {
                source = new LFVertex(soNom);
                g.addVertex(source);
            }
            if (HyloHelper.isLexPred(so)) {
                Nominal parent = ancestorMap.get(source.nominal);
                if (parent == null) continue;
                g.highestAncestorMap.put(source, g.findVertexByNominal(parent));
                continue;
            }
            if (HyloHelper.isRelPred(so)) {
                d = (Diamond)so.getArg();
                Nominal dArg = (Nominal)d.getArg();
                LFVertex target = g.findVertexByNominal(dArg);
                if (target == null) {
                    target = new LFVertex(dArg);
                    g.addVertex(target);
                }
                g.addLabeledEdge(source, target, LFEdgeLabel.forMode(d.getMode()));
                continue;
            }
            if (!HyloHelper.isAttrPred(so)) continue;
            d = (Diamond)so.getArg();
            source.addAttribute(d.getMode(), (Proposition)d.getArg());
        }
        return g;
    }
}

