/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.lexicon;

import java.util.List;
import java.util.Set;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.lexicon.MacroItem;
import opennlp.ccg.synsem.AtomCat;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.unify.FeatureStructure;
import opennlp.ccg.unify.ModFcn;
import opennlp.ccg.unify.Mutable;
import opennlp.ccg.util.IntHashSetMap;

public class MacroAdder {
    private IntHashSetMap _specificMacros;
    private List<MacroItem> _macroItems;
    private ModFcn addIndexedFeatures = new ModFcn(){

        @Override
        public void modify(Mutable c) {
            if (c instanceof AtomCat) {
                FeatureStructure fs = ((AtomCat)c).getFeatureStructure();
                int fsIndex = fs.getIndex();
                Set featStrucs = (Set)MacroAdder.this._specificMacros.get(fsIndex);
                if (null == featStrucs) {
                    return;
                }
                FeatureStructure $fs = fs.copy();
                for (FeatureStructure macroFS : featStrucs) {
                    $fs = $fs.inherit(macroFS);
                }
                ((AtomCat)c).setFeatureStructure($fs);
            }
        }
    };

    public MacroAdder(IntHashSetMap sm, List<MacroItem> macroItems) {
        this._specificMacros = sm;
        this._macroItems = macroItems;
    }

    public void addMacros(Category cat) {
        cat.deepMap(this.addIndexedFeatures);
        LF lf = cat.getLF();
        for (int i = 0; i < this._macroItems.size(); ++i) {
            MacroItem mi = this._macroItems.get(i);
            LF[] preds = mi.getPreds();
            for (int j = 0; j < preds.length; ++j) {
                LF pred = preds[j].copy();
                if (!HyloHelper.isElementaryPredication(pred)) {
                    System.out.println("Warning: ignoring LF macro pred, which is not an elementary predication: " + pred);
                    continue;
                }
                lf = HyloHelper.append(lf, pred);
            }
        }
        HyloHelper.sort(lf);
        cat.setLF(lf);
    }
}

