/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.ngrams;

import java.util.List;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.ngrams.NgramScorer;
import opennlp.ccg.perceptron.Alphabet;
import opennlp.ccg.perceptron.FeatureExtractor;
import opennlp.ccg.perceptron.FeatureList;
import opennlp.ccg.perceptron.FeatureMap;
import opennlp.ccg.perceptron.FeatureVector;
import opennlp.ccg.synsem.Sign;

public class LinearNgramScorerCombo
extends NgramScorer
implements FeatureExtractor {
    protected NgramScorer[] models;
    protected double[] weights;
    protected boolean useInterpLogProb = true;

    public LinearNgramScorerCombo(NgramScorer[] models) {
        this(models, LinearNgramScorerCombo.rankOrderCentroidWeights(models.length));
    }

    public LinearNgramScorerCombo(NgramScorer[] models, double[] weights) {
        this.models = models;
        this.weights = weights;
        for (int i = 0; i < models.length; ++i) {
            models[i].shareWordsToScore(this.wordsToScore);
            this.order = Math.max(this.order, models[i].order);
        }
    }

    @Override
    public void setReverse(boolean reverse) {
        super.setReverse(reverse);
        for (int i = 0; i < this.models.length; ++i) {
            this.models[i].setReverse(reverse);
        }
    }

    @Override
    protected void shareWordsToScore(List<Word> wordsToScore) {
        this.wordsToScore = wordsToScore;
        for (int i = 0; i < this.models.length; ++i) {
            this.models[i].shareWordsToScore(wordsToScore);
        }
    }

    @Override
    protected void prepareToScoreWords() {
        for (int i = 0; i < this.models.length; ++i) {
            this.models[i].prepareToScoreWords();
        }
    }

    @Override
    protected float logProbFromNgram(int i, int order) {
        double prob = 0.0;
        for (int j = 0; j < this.models.length; ++j) {
            prob += LinearNgramScorerCombo.convertToProb(this.models[j].logProbFromNgram(i, order)) * this.weights[j];
        }
        return (float)LinearNgramScorerCombo.convertToLogProb(prob);
    }

    @Override
    protected void incNgrams(FeatureMap featmap, int i, int order) {
        for (int j = 0; j < this.models.length; ++j) {
            if (!this.models[j].useNgramFeatures) continue;
            this.models[j].incNgrams(featmap, i, order);
        }
    }

    public void setInterpLogProb(boolean useInterpLogProb) {
        this.useInterpLogProb = useInterpLogProb;
    }

    @Override
    public FeatureVector extractLogProbs(Sign sign, boolean complete) {
        Alphabet.Feature f;
        FeatureList retval = new FeatureList(this.models.length + 1);
        if (this.useInterpLogProb && (f = this.alphabet.index("$ngram")) != null) {
            retval.add(f, Float.valueOf((float)this.logprob(sign, complete)));
        }
        for (int i = 0; i < this.models.length; ++i) {
            Alphabet.Feature f2 = this.alphabet.index("$ngram" + i);
            if (f2 == null) continue;
            retval.add(f2, Float.valueOf((float)this.models[i].logprob(sign, complete)));
        }
        return retval;
    }

    @Override
    public void setAlphabet(Alphabet alphabet) {
        super.setAlphabet(alphabet);
        for (NgramScorer scorer : this.models) {
            scorer.setAlphabet(alphabet);
        }
    }
}

