/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.grammar.Rule;
import opennlp.ccg.grammar.TypeChangingRule;
import opennlp.ccg.synsem.Sign;

public class DerivationHistory
implements Serializable,
Comparable<DerivationHistory> {
    private static final long serialVersionUID = 2867339743258182859L;
    private Sign[] _inputs;
    private Sign _output;
    private Rule _rule;
    private boolean _noHistory = false;
    private transient int _complexity = -1;

    public DerivationHistory(Sign output) {
        this._noHistory = true;
        this._output = output;
    }

    public DerivationHistory(Sign[] inputs, Sign output, Rule rule) {
        this._inputs = new Sign[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            this._inputs[i] = inputs[i];
        }
        this._output = output;
        this._rule = rule;
    }

    public boolean isEmpty() {
        return this._noHistory;
    }

    public Sign[] getInputs() {
        return this._inputs;
    }

    public Sign getOutput() {
        return this._output;
    }

    public Rule getRule() {
        return this._rule;
    }

    public String toString() {
        return this.toString(this.maxRuleLen());
    }

    private String toString(int maxRuleLen) {
        int i;
        StringBuffer sb = new StringBuffer();
        if (this._noHistory) {
            sb.append("(lex) ");
            for (int i2 = 5; i2 < maxRuleLen; ++i2) {
                sb.append(' ');
            }
            sb.append(this._output.toString()).append('\n');
            return sb.toString();
        }
        for (int i3 = 0; i3 < this._inputs.length; ++i3) {
            sb.append(this._inputs[i3].getDerivationHistory().toString(maxRuleLen));
        }
        String ruleName = this._rule.name();
        TypeChangingRule tcr = Grammar.theGrammar.rules.getTypeChangingRule(ruleName);
        if (tcr != null) {
            sb.append("(gram) ");
            for (i = 6; i < maxRuleLen; ++i) {
                sb.append(' ');
            }
            sb.append(tcr.toString()).append('\n');
        }
        sb.append('(').append(ruleName).append(") ");
        for (i = ruleName.length() + 2; i < maxRuleLen; ++i) {
            sb.append(' ');
        }
        sb.append(this._output.toString()).append('\n');
        return sb.toString();
    }

    private int maxRuleLen() {
        if (this._noHistory) {
            return 6;
        }
        int max = 0;
        for (int i = 0; i < this._inputs.length; ++i) {
            max = Math.max(max, this._inputs[i].getDerivationHistory().maxRuleLen());
        }
        max = Math.max(max, this._rule.name().length() + 2);
        return max;
    }

    public int complexity() {
        if (this._complexity > 0) {
            return this._complexity;
        }
        if (this._noHistory) {
            return 0;
        }
        int retval = 1;
        String ruleName = this._rule.name();
        if (!(ruleName.length() <= 1 || ruleName.charAt(0) != '>' && ruleName.charAt(0) != '<' || ruleName.charAt(1) != 'B' && ruleName.charAt(1) != 'S')) {
            ++retval;
            if (ruleName.length() == 3 && ruleName.charAt(2) == 'x') {
                ++retval;
            }
        }
        for (int i = 0; i < this._inputs.length; ++i) {
            retval += this._inputs[i].getDerivationHistory().complexity();
        }
        this._complexity = retval;
        return retval;
    }

    public boolean containsCycle() {
        if (this._noHistory || this._inputs.length != 1) {
            return false;
        }
        ArrayList<Rule> rulesSeen = new ArrayList<Rule>(4);
        rulesSeen.add(this._rule);
        return this._inputs[0].getDerivationHistory().containsCycle(rulesSeen);
    }

    private boolean containsCycle(List<Rule> rulesSeen) {
        if (this._noHistory || this._inputs.length != 1) {
            return false;
        }
        if (rulesSeen.contains(this._rule)) {
            return true;
        }
        rulesSeen.add(this._rule);
        return this._inputs[0].getDerivationHistory().containsCycle(rulesSeen);
    }

    @Override
    public int compareTo(DerivationHistory dh) {
        int c2;
        int c1 = this.complexity();
        if (c1 < (c2 = dh.complexity())) {
            return -1;
        }
        if (c1 > c2) {
            return 1;
        }
        if (this._noHistory) {
            return 0;
        }
        if (this._inputs.length < dh._inputs.length) {
            return -1;
        }
        if (this._inputs.length > dh._inputs.length) {
            return 1;
        }
        for (int i = 0; i < this._inputs.length; ++i) {
            int cmp = this._inputs[i].getDerivationHistory().compareTo(dh._inputs[i].getDerivationHistory());
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }
}

