/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.postagger.ml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import opennlp.ccg.lexicon.DefaultTokenizer;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.ngrams.ConditionalProbabilityTable;
import opennlp.ccg.parse.supertagger.util.ProbPairComparator;
import opennlp.ccg.parse.tagger.io.SRILMFactoredBundleCorpusIterator;
import opennlp.ccg.util.Interner;
import opennlp.ccg.util.Pair;

public class POSPriorModel
extends ConditionalProbabilityTable {
    public static final String WORD = "W";
    public static final String POS_TAG = "P";
    private Interner<Pair<String, String>> pairs = new Interner();
    public List<Pair<String, String>> attrVals = new ArrayList<Pair<String, String>>(5);
    private ProbPairComparator ppcomp = new ProbPairComparator();
    List<Pair<Double, String>> priors = new ArrayList<Pair<Double, String>>(1000);
    private String[] posVocab = null;

    public POSPriorModel(String flmFile, String vocabFile) throws IOException {
        super(flmFile);
        String post = null;
        BufferedReader br = new BufferedReader(new FileReader(new File(vocabFile)));
        post = br.readLine().trim();
        while (post != null && !post.trim().startsWith("P-")) {
            post = br.readLine();
        }
        if (post != null) {
            post = post.trim().split("-")[1];
        }
        HashSet<String> allSupertags = new HashSet<String>();
        int cnt = 0;
        while (post != null) {
            ++cnt;
            allSupertags.add(post);
            while (post != null && !post.trim().startsWith("P-")) {
                post = br.readLine();
            }
            if (post == null) continue;
            post = post.trim().split("-")[1];
        }
        this.posVocab = new String[cnt];
        cnt = 0;
        for (String posTag : allSupertags) {
            this.posVocab[cnt++] = posTag.intern();
        }
        br.close();
    }

    public double getPriorOf(String pos, String word) {
        this.attrVals.clear();
        Pair<String, String> surfaceForm = this.pairs.intern(new Pair<String, String>(WORD, word.intern()));
        this.attrVals.add(surfaceForm);
        Pair<String, String> partOfSpeech = this.pairs.intern(new Pair<String, String>(POS_TAG, pos.intern()));
        this.attrVals.add(partOfSpeech);
        return this.score(this.attrVals);
    }

    public List<Pair<Double, String>> getPriors(Word w) {
        ArrayList<Pair<Double, String>> sortedTags = new ArrayList<Pair<Double, String>>(this.posVocab.length);
        for (String postag : this.posVocab) {
            sortedTags.add(new Pair<Double, String>(this.getPriorOf(postag, w.getForm()), postag));
        }
        Collections.sort(sortedTags, this.ppcomp);
        return sortedTags;
    }

    public List<Pair<Double, String>> getPriors(String s) {
        s.intern();
        ArrayList<Pair<Double, String>> sortedTags = new ArrayList<Pair<Double, String>>(this.posVocab.length);
        for (String postag : this.posVocab) {
            sortedTags.add(new Pair<Double, String>(this.getPriorOf(postag, s), postag));
        }
        Collections.sort(sortedTags, this.ppcomp);
        return sortedTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String usage = "\nPOSPriorModel -vocab <vocabfile> (-c <corpus> [default = <stdin>]) (-o <output> [default = <stdout>])\n";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println(usage);
            System.exit(0);
        }
        SRILMFactoredBundleCorpusIterator in = null;
        BufferedWriter out = null;
        BufferedWriter voc = null;
        try {
            String inputCorp = "<stdin>";
            String output = "<stdout>";
            String vocabFile = "vocab.voc";
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-c")) {
                    inputCorp = args[++i];
                    continue;
                }
                if (args[i].equals("-o")) {
                    output = args[++i];
                    continue;
                }
                if (args[i].equals("-vocab")) {
                    vocabFile = args[++i];
                    continue;
                }
                System.out.println("Unrecognized option: " + args[i]);
            }
            try {
                in = new SRILMFactoredBundleCorpusIterator(inputCorp.equals("<stdin>") ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(new File(inputCorp))));
            }
            catch (FileNotFoundException ex) {
                System.err.print("Input corpus " + inputCorp + " not found.  Exiting...");
                Logger.getLogger(POSPriorModel.class.getName()).log(Level.SEVERE, null, ex);
                System.exit(-1);
            }
            try {
                out = output.equals("<stdout>") ? new BufferedWriter(new OutputStreamWriter(System.out)) : new BufferedWriter(new FileWriter(new File(output)));
            }
            catch (IOException ex) {
                System.err.print("Output file " + output + " not found.  Exiting...");
                Logger.getLogger(POSPriorModel.class.getName()).log(Level.SEVERE, null, ex);
                System.exit(-1);
            }
            try {
                voc = new BufferedWriter(new FileWriter(new File(vocabFile)));
            }
            catch (IOException ex) {
                Logger.getLogger(POSPriorModel.class.getName()).log(Level.SEVERE, null, ex);
            }
            HashMap<String, Integer> vocab = new HashMap<String, Integer>();
            for (List<Word> inLine : in) {
                for (Word w : inLine) {
                    String pos = "P-" + DefaultTokenizer.escape(w.getPOS());
                    String wform = "W-" + DefaultTokenizer.escape(w.getForm());
                    vocab.put(pos, vocab.get(pos) == null ? 1 : (Integer)vocab.get(pos) + 1);
                    vocab.put(wform, vocab.get(wform) == null ? 1 : (Integer)vocab.get(wform) + 1);
                    out.write(wform + ":" + pos + " ");
                }
                out.write(System.getProperty("line.separator"));
            }
            out.flush();
            for (String str : vocab.keySet()) {
                voc.write(str + System.getProperty("line.separator"));
            }
            voc.flush();
        }
        finally {
            try {
                out.close();
                in.close();
                voc.close();
            }
            catch (IOException ex) {
                Logger.getLogger(POSPriorModel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

