/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.supertagger.ml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.parse.postagger.POSTagger;
import opennlp.ccg.parse.supertagger.ml.FeatureExtractor;
import opennlp.ccg.parse.supertagger.ml.STPriorModel;
import opennlp.ccg.parse.tagger.Constants;
import opennlp.ccg.parse.tagger.TaggedWord;
import opennlp.ccg.parse.tagger.io.SRILMFactoredBundleCorpusIterator;
import opennlp.ccg.util.Pair;

public class STFex
implements FeatureExtractor {
    private boolean useMultiPOS = false;
    public static final String LEX = "X";
    public static final String POS = "P";
    public static final String prevP = "P-1=";
    public static final String prevPrevP = "P-2=";
    public static final String nextP = "P+1=";
    public static final String nextNextP = "P+2=";
    public static final String curP = "P=";
    public static final String prevL = "X-1=";
    public static final String prevPrevL = "X-2=";
    public static final String nextL = "X+1=";
    public static final String nextNextL = "X+2=";
    public static final String curL = "X=";
    public static final String priorST = "PST=";
    public static final String wordPOSPriorST = "WPosPST=";
    public static final String wordPriorST = "WPST=";
    public static final String POSPriorST = "PosPST=";
    public static final String antiPriorST = "APST=";
    public static final String wordPOSAntiPriorST = "WPosAPST=";
    public static final String wordAntiPriorST = "WAPST=";
    public static final String POSAntiPriorST = "PosAPST=";
    public static final TaggedWord outOfBounds = Constants.OOB;
    private static final String[] lxfLabs = new String[]{"X-2", "X-1", "X", "X+1", "X+2"};
    private static final String[] posfLabs = new String[]{"P-2", "P-1", "P", "P+1", "P+2"};
    protected STPriorModel priorMod;

    public STFex() {
        this.priorMod = null;
    }

    public STFex(STPriorModel priorMod) {
        this.priorMod = priorMod;
    }

    public void useMultiPOS(boolean trueOrFalse) {
        this.useMultiPOS = trueOrFalse;
    }

    @Override
    public Collection<Pair<String, Double>> getFeatures(Map<Integer, TaggedWord> sentence, Integer wordIndex, boolean training) {
        TaggedWord nextNext;
        TaggedWord next;
        TaggedWord prevPrev;
        TaggedWord prev;
        ArrayList<Pair<String, Double>> result = new ArrayList<Pair<String, Double>>(30);
        TaggedWord current = sentence.get(wordIndex);
        int wind = wordIndex;
        if (wind > 1) {
            prev = sentence.get(wind - 1);
            prevPrev = sentence.get(wind - 2);
        } else if (wind > 0) {
            prev = sentence.get(wind - 1);
            prevPrev = outOfBounds;
        } else {
            prev = prevPrev = outOfBounds;
        }
        int tempSize = sentence.size();
        if (tempSize - (wind + 1) >= 2) {
            next = sentence.get(wind + 1);
            nextNext = sentence.get(wind + 2);
        } else if (tempSize - (wind + 1) >= 1) {
            next = sentence.get(wind + 1);
            nextNext = outOfBounds;
        } else {
            next = nextNext = outOfBounds;
        }
        Double activation = new Double(1.0);
        if (training) {
            result.add(new Pair<String, Double>(current.getSupertag(), activation));
        }
        result.add(new Pair<String, Double>(curL + current.getForm(), activation));
        if (this.useMultiPOS) {
            for (Pair<Double, String> tg : current.getPOSTagging()) {
                result.add(new Pair(curP + (String)tg.b, tg.a));
            }
        } else {
            result.add(new Pair<String, Double>(curP + current.getPOS(), activation));
        }
        result.add(new Pair<String, Double>(prevL + prev.getForm(), activation));
        if (this.useMultiPOS && prev != Constants.OOB) {
            for (Pair<Double, String> tg : prev.getPOSTagging()) {
                result.add(new Pair(prevP + (String)tg.b, tg.a));
            }
        } else {
            result.add(new Pair<String, Double>(prevP + prev.getPOS(), activation));
        }
        result.add(new Pair<String, Double>(prevPrevL + prevPrev.getForm(), activation));
        if (this.useMultiPOS && prevPrev != Constants.OOB) {
            for (Pair<Double, String> tg : prevPrev.getPOSTagging()) {
                result.add(new Pair(prevPrevP + (String)tg.b, tg.a));
            }
        } else {
            result.add(new Pair<String, Double>(prevPrevP + prevPrev.getPOS(), activation));
        }
        result.add(new Pair<String, Double>(nextL + next.getForm(), activation));
        if (this.useMultiPOS && next != Constants.OOB) {
            for (Pair<Double, String> tg : next.getPOSTagging()) {
                result.add(new Pair(nextP + (String)tg.b, tg.a));
            }
        } else {
            result.add(new Pair<String, Double>(nextP + next.getPOS(), activation));
        }
        result.add(new Pair<String, Double>(nextNextL + nextNext.getForm(), activation));
        if (this.useMultiPOS && nextNext != Constants.OOB) {
            for (Pair<Double, String> tg : nextNext.getPOSTagging()) {
                result.add(new Pair(nextNextP + (String)tg.b, tg.a));
            }
        } else {
            result.add(new Pair<String, Double>(nextNextP + nextNext.getPOS(), activation));
        }
        TaggedWord[] wds = new TaggedWord[]{prevPrev, prev, current, next, nextNext};
        for (int j = 1; j < wds.length; ++j) {
            result.add(new Pair<String, Double>(lxfLabs[j - 1] + "|" + lxfLabs[j] + "=" + wds[j - 1].getForm() + "|" + wds[j].getForm(), activation));
            result.add(new Pair<String, Double>(posfLabs[j - 1] + "|" + posfLabs[j] + "=" + wds[j - 1].getPOS() + "|" + wds[j].getPOS(), activation));
            if (j != 2) continue;
            result.add(new Pair<String, Double>(lxfLabs[j - 1] + "|" + lxfLabs[j + 1] + "=" + wds[j - 1].getForm() + "|" + wds[j + 1].getForm(), activation));
            result.add(new Pair<String, Double>(posfLabs[j - 1] + "|" + posfLabs[j + 1] + "=" + wds[j - 1].getPOS() + "|" + wds[j + 1].getPOS(), activation));
        }
        if (this.priorMod != null) {
            this.priorMod.computePriors(current.getWord());
            for (Pair<String, Double> priorClassActivationPair : this.priorMod.getRestrictedBetaBestPriors(current.getWord(), 0.1)) {
                double act = Math.log((Double)priorClassActivationPair.b);
                String wd = current.getForm().intern();
                String pos = current.getPOS().intern();
                result.add(new Pair<String, Double>(priorST + ((String)priorClassActivationPair.a).intern(), act));
                result.add(new Pair<String, Double>(wordPriorST + ((String)priorClassActivationPair.a).intern() + "_" + wd, act));
                result.add(new Pair<String, Double>(wordPOSPriorST + ((String)priorClassActivationPair.a).intern() + "_" + wd + "_" + pos, act));
                result.add(new Pair<String, Double>(POSPriorST + ((String)priorClassActivationPair.a).intern() + "_" + pos, act));
                result.add(new Pair<String, Double>(antiPriorST + ((String)priorClassActivationPair.a).intern(), Math.log(1.0 - Math.exp(act))));
            }
        }
        return result;
    }

    @Override
    public List<Collection<Pair<String, Double>>> getSentenceFeatures(Map<Integer, TaggedWord> sentence, boolean training) {
        ArrayList<Collection<Pair<String, Double>>> res = new ArrayList<Collection<Pair<String, Double>>>(sentence.size());
        ArrayList<Integer> keys = new ArrayList<Integer>(sentence.keySet().size());
        for (Integer i : sentence.keySet()) {
            keys.add(i);
        }
        Collections.sort(keys);
        for (Integer wordIndex : keys) {
            res.add(this.getFeatures(sentence, wordIndex, training));
        }
        return res;
    }

    @Override
    public Collection<Pair<String, Double>> getFeatures(Map<Integer, TaggedWord> sentence, Integer wordIndex) {
        return this.getFeatures(sentence, wordIndex, false);
    }

    @Override
    public List<Collection<Pair<String, Double>>> getSentenceFeatures(Map<Integer, TaggedWord> sentence) {
        return this.getSentenceFeatures(sentence, false);
    }

    public static void main(String[] args) {
        POSTagger posT;
        String usage = "\n<stdin> | STFex (-h [gets this message]) (-r <priorSTModelF> -v <priorSTModelVocabF>) (-p <postaggerConfigFile>) | <stdout>";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println(usage);
            System.exit(0);
        }
        String priorModF = null;
        String priorVocab = null;
        String posConfig = null;
        for (int j = 0; j < args.length; ++j) {
            if (args[j].equals("-r")) {
                priorModF = args[++j];
                continue;
            }
            if (args[j].equals("-v")) {
                priorVocab = args[++j];
                continue;
            }
            if (args[j].equals("-p")) {
                posConfig = args[++j];
                continue;
            }
            System.err.println("Unrecognized option: " + args[j]);
        }
        SRILMFactoredBundleCorpusIterator corp = new SRILMFactoredBundleCorpusIterator(new BufferedReader(new InputStreamReader(System.in)));
        STPriorModel stPriorMod = null;
        if (priorModF != null) {
            try {
                stPriorMod = new STPriorModel(priorModF, priorVocab);
            }
            catch (IOException ex) {
                Logger.getLogger(STFex.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        STFex fexer = new STFex(stPriorMod);
        POSTagger pOSTagger = posT = posConfig == null ? null : POSTagger.posTaggerFactory(posConfig);
        if (posT != null) {
            fexer.useMultiPOS(true);
        } else {
            fexer.useMultiPOS(false);
        }
        for (List<Word> sentence : corp) {
            HashMap<Integer, TaggedWord> sent = new HashMap<Integer, TaggedWord>(sentence.size());
            int index = 0;
            if (posT == null) {
                for (Word w : sentence) {
                    sent.put(index++, new TaggedWord(w));
                }
            } else {
                List<TaggedWord> posTagging = posT.tagSentence(sentence);
                for (TaggedWord taggedWord : posTagging) {
                    sent.put(index++, taggedWord);
                }
            }
            List<Collection<Pair<String, Double>>> ftss = fexer.getSentenceFeatures(sent, true);
            for (Collection collection : ftss) {
                index = 0;
                for (Pair ft : collection) {
                    if (index == 0) {
                        System.out.print((String)ft.a);
                    } else {
                        System.out.print(" " + (String)ft.a + ":" + ft.b);
                    }
                    ++index;
                }
                System.out.println();
            }
        }
    }
}

