/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.realize.hypertagger;

import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opennlp.ccg.hylo.Diamond;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.hylo.NominalVar;
import opennlp.ccg.hylo.Proposition;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.realize.hypertagger.FeatureExtractionException;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.util.Pair;

public abstract class TagExtractor {
    public static int LFID = 0;
    protected LfGraphNode lfGraph;
    protected HashMap<String, LfGraphNode> nomTable;
    protected HashMap<String, LfGraphNode> varTable;
    protected HashMap<LfGraphNode, String> lexpairs;
    protected HashMap<LfGraphNode, String> pospairs;
    protected LF lf;
    protected List<SatOp> preds;
    protected List<SatOp> flatLF;
    protected int maxIndex;
    protected Map<String, String> argNameMap = new HashMap<String, String>();

    public void setLF(LF lf) throws FeatureExtractionException {
        ++LFID;
        HyloHelper.convertNominals(lf);
        this.setLF(HyloHelper.getPreds(lf));
    }

    public void setLF(List<SatOp> preds) throws FeatureExtractionException {
        this.preds = preds;
        LfGraphNode curNode = null;
        curNode = null;
        this.nomTable = new HashMap();
        this.varTable = new HashMap();
        int i = 0;
        for (SatOp s : preds) {
            if (s == null) {
                throw new FeatureExtractionException();
            }
            if (s.getArg() instanceof Proposition) {
                LfGraphNode thisNode = new LfGraphNode(s.getNominal().toString(), i);
                thisNode.setPredicateName(((Proposition)s.getArg()).getName());
                thisNode.setID(s.getNominal().toString());
                thisNode.setPred(s);
                if (this.lfGraph == null) {
                    this.lfGraph = thisNode;
                }
                this.nomTable.put(thisNode.getID(), thisNode);
            }
            ++i;
        }
        this.maxIndex = i;
        i = 0;
        for (SatOp s : preds) {
            LfGraphLink ln;
            LfGraphNode target;
            if (s == null) {
                throw new FeatureExtractionException();
            }
            if (s.getArg() instanceof Proposition) {
                curNode = this.nomTable.get(s.getNominal().toString());
                ++i;
                continue;
            }
            Diamond d = (Diamond)s.getArg();
            if (d == null || d.getArg() == null) {
                throw new FeatureExtractionException();
            }
            if (d.getArg() instanceof NominalVar) {
                target = this.nomTable.get(d.getArg().toString());
                ln = new LfGraphLink(d.getMode().toString(), null, target);
                ln.setSource(curNode);
            } else if (d.getArg() instanceof Nominal) {
                target = this.nomTable.get(d.getArg().toString());
                ln = new LfGraphLink(d.getMode().toString(), null, target);
                ln.setSource(curNode);
                if (target != null) {
                    target.setParentLink(ln);
                    target.addMultiParent(curNode);
                }
                if (curNode == null) {
                    throw new FeatureExtractionException();
                }
                curNode.addChild(ln);
            } else {
                try {
                    curNode.addAttribute(d.getMode().toString(), d.getArg().toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public LF getLF() {
        return this.lf;
    }

    protected abstract FeatureList getFeatures(LfGraphNode var1);

    public FeatureList getFeatures(int index) {
        for (LfGraphNode n : this.nomTable.values()) {
            if (n.getIndex() != index) continue;
            return this.getFeatures(n);
        }
        return null;
    }

    public String getSupertag(LfGraphNode n) {
        return this.lexpairs.get(n);
    }

    public String getSupertag(int index) {
        for (LfGraphNode n : this.nomTable.values()) {
            if (n.getIndex() != index) continue;
            return this.lexpairs.get(n);
        }
        return null;
    }

    public String getPOStag(LfGraphNode n) {
        return this.pospairs.get(n);
    }

    public String getPOStag(int index) {
        for (LfGraphNode n : this.nomTable.values()) {
            if (n.getIndex() != index) continue;
            return this.pospairs.get(n);
        }
        return null;
    }

    protected LfGraphNode findNode(int index) {
        for (LfGraphNode n : this.nomTable.values()) {
            if (n.getIndex() != index) continue;
            return n;
        }
        return null;
    }

    protected int numNodes() {
        return this.nomTable.size();
    }

    protected int maxIndex() {
        return this.maxIndex;
    }

    public static String join(ArrayList<String> a, String delimiter) {
        String out = new String();
        for (int i = 0; i < a.size(); ++i) {
            out = out.concat(a.get(i));
            if (i == a.size() - 1) continue;
            out = out.concat(delimiter);
        }
        return out;
    }

    public abstract void storeGoldStdPredInfo(String var1);

    public abstract String getAllFeaturesAndAnswer();

    public abstract void loadPriorModel(File var1, File var2);

    public void loadProtoModel(File hyperModelFile) {
    }

    protected void setArgNames(String argnames) {
        String[] nameslist;
        this.argNameMap.clear();
        if (argnames == null) {
            argnames = "Arg0:A0 Arg1:A1 Arg1a:A1a Arg1b:A1b Arg2:A2 Arg2a:A2a Arg2b:A2b Arg3:A3 Arg4:A4 Arg5:A5";
        }
        for (String argname : nameslist = argnames.split("\\s+")) {
            String[] namepair = argname.split(":");
            if (namepair.length == 2) {
                this.argNameMap.put(namepair[0], namepair[1]);
                continue;
            }
            if (namepair.length != 1) continue;
            this.argNameMap.put(namepair[0], namepair[1]);
        }
    }

    protected class FeatureList
    extends HashMap<String, ArrayList<String>> {
        private static final long serialVersionUID = 1L;
        int numFeatures = 0;

        protected FeatureList() {
        }

        protected void addFeature(String featureName, String value) {
            this.addFeatureWithProb(featureName, value);
        }

        protected void addFeatures(String featureName, ArrayList<Pair<String, Double>> values) {
            for (Pair<String, Double> v : values) {
                this.addFeatureWithProb(featureName, (String)v.a, (Double)v.b);
            }
        }

        protected void addFeatureWithProb(String featureName, String value, Double prob) {
            if (value == null) {
                return;
            }
            if (this.get(featureName) == null) {
                this.put(featureName.trim(), new ArrayList());
            }
            ArrayList feats = (ArrayList)this.get(featureName);
            feats.add(value.trim() + ":" + prob.toString());
            this.put(featureName.trim(), feats);
            ++this.numFeatures;
        }

        protected void addFeatureWithProb(String featureName, String value) {
            this.addFeatureWithProb(featureName, value, new Double(1.0));
        }

        protected ArrayList<String> getFeature(String featureName) {
            return (ArrayList)this.get(featureName);
        }

        protected String getSingleFeature(String featureName) {
            return (String)((ArrayList)this.get(featureName)).get(0);
        }

        protected String getAllFeatures() {
            String output = "";
            for (String k : this.keySet()) {
                for (String v : (ArrayList)this.get(k)) {
                    output = output.concat(k + "=" + v);
                    output = output.concat(" ");
                }
            }
            return output;
        }

        protected String[] getAllFeaturesForMaxent() {
            String[] out = new String[this.getNumFeatures()];
            int i = 0;
            for (String k : this.keySet()) {
                for (String v : (ArrayList)this.get(k)) {
                    out[i] = k + "=" + v;
                    ++i;
                }
            }
            return out;
        }

        protected int getNumFeatures() {
            return this.numFeatures;
        }
    }

    protected class LfGraphNode {
        String data;
        String predicateName;
        int index;
        SatOp pred;
        ArrayList<LfGraphLink> children;
        LfGraphLink parentLink;
        HashMap<String, String> attribs;
        protected String POS;
        protected String ST;
        ArrayList<Pair<String, Double>> POSList;
        Set<Pair<String, Double>> STList;
        ArrayList<LfGraphNode> multiparents;
        FeatureList features;
        private String id;

        public Set<Pair<String, Double>> getSTList() {
            return this.STList;
        }

        public void setSTList(Set<Pair<String, Double>> set) {
            this.STList = set;
        }

        protected FeatureList getFeatures() {
            return this.features;
        }

        protected void setFeatures(FeatureList features) {
            this.features = features;
        }

        public LfGraphNode(String s, int idx) {
            this.data = s;
            this.index = idx;
            this.children = new ArrayList();
            this.attribs = new HashMap();
            this.POS = null;
            this.multiparents = new ArrayList();
        }

        public String getData() {
            return this.data;
        }

        public void setData(String s) {
            this.data = s;
        }

        public void addAttribute(String name, String value) {
            this.attribs.put(name, value);
        }

        public void addChild(LfGraphLink link) {
            this.children.add(link);
        }

        public ArrayList<LfGraphLink> getChildren() {
            return this.children;
        }

        public int getNumChildren() {
            return this.children.size();
        }

        public boolean isLeafNode() {
            return this.children.isEmpty();
        }

        public LfGraphNode findNode(BitSet b) {
            if (b.get(this.index)) {
                return this;
            }
            for (LfGraphLink n : this.children) {
                n.getTarget().findNode(b);
            }
            return null;
        }

        public HashMap<String, String> getAttribs() {
            return this.attribs;
        }

        public void setAttribs(HashMap<String, String> attribs) {
            this.attribs = attribs;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void setChildren(ArrayList<LfGraphLink> children) {
            this.children = children;
        }

        public String getPredicateName() {
            return this.predicateName;
        }

        public void setPredicateName(String predicateName) {
            this.predicateName = predicateName;
        }

        public LfGraphLink getParentLink() {
            return this.parentLink;
        }

        public void setParentLink(LfGraphLink parentLink) {
            this.parentLink = parentLink;
        }

        public void addMultiParent(LfGraphNode parentNode) {
            if (parentNode == this) {
                return;
            }
            this.multiparents.add(parentNode);
        }

        public ArrayList<LfGraphNode> getMultiParents() {
            return this.multiparents;
        }

        public SatOp getPred() {
            return this.pred;
        }

        protected void setPred(SatOp pred) {
            this.pred = pred;
        }

        public String getPOS() {
            return this.POS;
        }

        public void setPOS(String pos) {
            this.POS = new String(pos);
        }

        public ArrayList<Pair<String, Double>> getPOSList() {
            return this.POSList;
        }

        public void setPOSList(ArrayList<Pair<String, Double>> plist) {
            this.POSList = plist;
        }

        public void setID(String string) {
            this.id = string;
        }

        public String getID() {
            return this.id;
        }
    }

    protected class LfGraphLink {
        String label;
        String arg;
        LfGraphNode target;
        LfGraphNode source;

        public LfGraphLink(String l, String a, LfGraphNode t) {
            this.label = l;
            this.arg = a;
            this.target = t;
        }

        public LfGraphNode getTarget() {
            return this.target;
        }

        public void setTarget(LfGraphNode t) {
            this.target = t;
        }

        public String getLabel() {
            return this.label;
        }

        public LfGraphNode getSource() {
            return this.source;
        }

        public void setSource(LfGraphNode source) {
            this.source = source;
        }
    }
}

