/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.util;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIdentityHashingStrategy;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

public class GroupMap<KeyType, ValType>
implements Serializable {
    private static final long serialVersionUID = -2995356057195571222L;
    private THashMap map;

    public GroupMap() {
        this(false);
    }

    public GroupMap(boolean useIdentityEquals) {
        this.map = useIdentityEquals ? new THashMap((TObjectHashingStrategy)new TObjectIdentityHashingStrategy()) : new THashMap();
    }

    public Object put(KeyType key, ValType value) {
        Object currentVal = this.map.get(key);
        if (currentVal == null) {
            this.map.put(key, value);
        } else if (currentVal instanceof Set) {
            Set set = (Set)currentVal;
            set.add(value);
        } else {
            THashSet set = new THashSet();
            set.add(currentVal);
            set.add(value);
            this.map.put(key, (Object)set);
        }
        return null;
    }

    public Set<ValType> get(KeyType key) {
        Object val = this.map.get(key);
        if (val == null || val instanceof Set) {
            return (Set)val;
        }
        THashSet set = new THashSet();
        set.add(val);
        this.map.put(key, (Object)set);
        return set;
    }

    public void putAll(KeyType key, Collection<ValType> vals) {
        for (ValType val : vals) {
            this.put(key, val);
        }
    }

    public int size() {
        return this.map.size();
    }

    public Set<KeyType> keySet() {
        return this.map.keySet();
    }

    public boolean containsKey(KeyType key) {
        return this.map.containsKey(key);
    }

    Set<ValType> remove(KeyType key) {
        Set<ValType> retval = this.get(key);
        this.map.remove(key);
        return retval;
    }
}

