/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import java.util.prefs.Preferences;
import opennlp.ccg.grammar.AbstractCompositionRule;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.lexicon.LexException;
import opennlp.ccg.ngrams.NgramPrecisionModel;
import opennlp.ccg.parse.ParseException;
import opennlp.ccg.parse.Parser;
import opennlp.ccg.realize.Chart;
import opennlp.ccg.realize.Realizer;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.test.RegressionInfo;
import opennlp.ccg.util.LineReader;
import opennlp.ccg.util.Visualizer;
import org.jdom.Document;
import org.jdom.Element;

public class TextCCG {
    public static final String SHOW_ALL_RESULTS = "Show All Results";
    public static final String SHOW_DERIVATIONS = "Show Derivations";
    public static final String SHOW_FEATURES = "Show Features";
    public static final String SHOW_SEMANTICS = "Show Semantics";
    public static final String FEATURES_TO_SHOW = "Features to Show";
    public static final String SHOW_TIMING = "Show Timing";
    public static final String SHOW_INCOMPLETE_EDGES = "Show Incomplete Edges";
    public static final String VISUALIZE = "Visualize";
    public static final String HISTORY = "Command Line History";

    public static void main(String[] args) throws IOException, LexException {
        String input;
        String usage = "java opennlp.ccg.TextCCG (<grammarfile>) | (-exportprefs <prefsfile>) | (-importprefs <prefsfile>)";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println("Usage: " + usage);
            System.exit(0);
        }
        String grammarfile = "grammar.xml";
        String prefsfile = null;
        boolean exportPrefs = false;
        boolean importPrefs = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-exportprefs")) {
                exportPrefs = true;
                prefsfile = args[++i];
                continue;
            }
            if (args[i].equals("-importprefs")) {
                importPrefs = true;
                prefsfile = args[++i];
                continue;
            }
            grammarfile = args[i];
        }
        Preferences prefs = Preferences.userNodeForPackage(TextCCG.class);
        try {
            if (exportPrefs) {
                System.out.println("Exporting preferences to prefsfile: " + prefsfile);
                prefs.exportNode(new FileOutputStream(prefsfile));
                return;
            }
            if (importPrefs) {
                System.out.println("Importing preferences from prefsfile: " + prefsfile);
                Preferences.importPreferences(new FileInputStream(prefsfile));
                return;
            }
        }
        catch (Exception exc) {
            throw (IOException)new IOException().initCause(exc);
        }
        URL grammarURL = new File(grammarfile).toURI().toURL();
        System.out.println("Loading grammar from URL: " + grammarURL);
        Grammar grammar = new Grammar(grammarURL);
        if (grammar.getName() != null) {
            System.out.println("Grammar '" + grammar.getName() + "' loaded.");
        }
        System.out.println();
        Parser parser = new Parser(grammar);
        Realizer realizer = new Realizer(grammar);
        Sign[] lastResults = null;
        LF[] lastLFs = null;
        String lastSentence = "";
        int lastReading = 0;
        String[] completions = new String[]{":sh", ":v", ":reset", ":feats", ":nofeats", ":foff", ":sem", ":nosem", ":all", ":notall", ":derivs", ":noderivs", ":doff", ":vison", ":visoff", ":wordpos", ":nowordpos", ":eisner", ":noeisner", ":ptl", ":noptl", ":pel", ":nopel", ":ppv", ":noppv", ":pcpv", ":nopcpv", ":plazy", ":noplazy", ":r", ":sel", ":2xml", ":2tb", ":2apml", ":tl", ":notl", ":el", ":noel", ":nbtl", ":nonbtl", ":pv", ":nopv", ":cpv", ":nocpv", ":upon", ":upoff", ":t", ":toff", ":inc", ":noinc", ":ion", ":ioff", ":mion", ":mioff", ":con", ":coff", ":flon", ":floff", ":ccon", ":ccoff", ":pon", ":poff", ":q", ":h"};
        LineReader lineReader = LineReader.createLineReader(completions);
        String historyKey = "Command Line History_" + grammar.getName();
        String histStr = prefs.get(historyKey, "");
        lineReader.setCommandHistory(histStr);
        System.out.println("Enter strings to parse.");
        System.out.println("Type ':r' to realize selected reading of previous parse.");
        System.out.println("Type ':h' for help on display options and ':q' to quit.");
        System.out.println("You can use the tab key for command completion, ");
        System.out.println("Ctrl-P (prev) and Ctrl-N (next) to access the command history, ");
        System.out.println("and emacs-style control keys to edit the line.");
        System.out.println();
        while ((input = lineReader.readLine("tccg> ")) != null) {
            String filename;
            String last;
            String[] tokens;
            if ((input = input.trim()).equals(":show settings") || input.equals(":sh")) {
                TextCCG.showSettings(prefs);
                continue;
            }
            if (input.equals(":v")) {
                prefs.putBoolean(SHOW_ALL_RESULTS, true);
                prefs.putBoolean(SHOW_DERIVATIONS, true);
                prefs.putBoolean(SHOW_FEATURES, true);
                prefs.putBoolean(SHOW_SEMANTICS, true);
                prefs.put(FEATURES_TO_SHOW, "");
                continue;
            }
            if (input.equals(":q")) break;
            if (input.equals(":h")) {
                TextCCG.showHelp();
                continue;
            }
            if (input.equals(":reset")) {
                prefs.putBoolean(SHOW_ALL_RESULTS, false);
                prefs.putBoolean(SHOW_DERIVATIONS, false);
                prefs.putBoolean(SHOW_TIMING, false);
                prefs.putBoolean(SHOW_INCOMPLETE_EDGES, false);
                prefs.putBoolean("Show Completeness", false);
                prefs.putBoolean("Show Bitset", false);
                prefs.putBoolean(SHOW_FEATURES, false);
                prefs.putBoolean(SHOW_SEMANTICS, false);
                prefs.put(FEATURES_TO_SHOW, "");
                prefs.putBoolean(VISUALIZE, false);
                prefs.put("VISFNAME", "");
                prefs.putBoolean("Use Word Positions To Convert Atoms", true);
                prefs.putBoolean("Use Eisner Constraints", true);
                AbstractCompositionRule.useEisnerConstraints = true;
                prefs.putInt("Parse Time Limit", 0);
                prefs.putInt("Parse Edge Limit", 0);
                prefs.putInt("Parse Pruning Value", 0);
                prefs.putInt("Parse Cell Pruning Value", 0);
                prefs.putBoolean("Parse Lazy Unpacking", true);
                prefs.putBoolean("Use Indexing", true);
                prefs.putBoolean("Allow Missing Index Combos", false);
                prefs.putBoolean("Use Chunks", true);
                prefs.putBoolean("Use Feature Licensing", true);
                prefs.putBoolean("Use Combos", true);
                prefs.putBoolean("Use Packing", false);
                prefs.putInt("Time Limit", 0);
                prefs.putDouble("New Best Time Limit", 0.0);
                prefs.putInt("Edge Limit", 0);
                prefs.putInt("Pruning Value", 0);
                prefs.putInt("Cell Pruning Value", 0);
                prefs.putBoolean("Do Unpacking", true);
                continue;
            }
            if (input.equals(":show feats") || input.equals(":feats") || input.equals(":f")) {
                prefs.putBoolean(SHOW_FEATURES, true);
                prefs.put(FEATURES_TO_SHOW, "");
                Grammar.theGrammar.prefs.showFeats = true;
                Grammar.theGrammar.prefs.featsToShow = "";
                continue;
            }
            if (input.startsWith(":show feats ") || input.startsWith(":feats ") || input.startsWith(":f ")) {
                prefs.putBoolean(SHOW_FEATURES, true);
                String s = input.substring(input.indexOf(32) + 1);
                if (s.startsWith("feats ")) {
                    s = s.substring(6);
                }
                prefs.put(FEATURES_TO_SHOW, s);
                Grammar.theGrammar.prefs.showFeats = true;
                Grammar.theGrammar.prefs.featsToShow = s;
                continue;
            }
            if (input.equals(":nofeats") || input.equals(":foff")) {
                prefs.putBoolean(SHOW_FEATURES, false);
                prefs.put(FEATURES_TO_SHOW, "");
                Grammar.theGrammar.prefs.showFeats = false;
                Grammar.theGrammar.prefs.featsToShow = "";
                continue;
            }
            if (input.equals(":show semantics") || input.equals(":sem") || input.equals(":s")) {
                prefs.putBoolean(SHOW_SEMANTICS, true);
                Grammar.theGrammar.prefs.showSem = true;
                continue;
            }
            if (input.equals(":nosem") || input.equals(":soff")) {
                prefs.putBoolean(SHOW_SEMANTICS, false);
                Grammar.theGrammar.prefs.showSem = false;
                continue;
            }
            if (input.equals(":show all") || input.equals(":all") || input.equals(":a")) {
                prefs.putBoolean(SHOW_ALL_RESULTS, true);
                continue;
            }
            if (input.equals(":notall") || input.equals(":aoff")) {
                prefs.putBoolean(SHOW_ALL_RESULTS, false);
                continue;
            }
            if (input.equals(":show derivs") || input.equals(":derivs") || input.equals(":d")) {
                prefs.putBoolean(SHOW_DERIVATIONS, true);
                continue;
            }
            if (input.equals(":noderivs") || input.equals(":doff")) {
                prefs.putBoolean(SHOW_DERIVATIONS, false);
                continue;
            }
            if (input.startsWith(":time limit") || input.startsWith(":tl")) {
                tokens = input.split("\\s+");
                last = tokens[tokens.length - 1];
                try {
                    int limit = Integer.parseInt(last);
                    prefs.putInt("Time Limit", limit);
                }
                catch (NumberFormatException exc) {
                    System.out.println("Expecting a time limit in ms, rather than: " + last);
                }
                continue;
            }
            if (input.startsWith(":no time limit") || input.startsWith(":notl")) {
                prefs.putInt("Time Limit", 0);
                continue;
            }
            if (input.startsWith(":nbtl")) {
                tokens = input.split("\\s+");
                last = tokens[tokens.length - 1];
                try {
                    double limit = Double.parseDouble(last);
                    prefs.putDouble("New Best Time Limit", limit);
                }
                catch (NumberFormatException exc) {
                    System.out.println("Expecting a time limit in ms, rather than: " + last);
                }
                continue;
            }
            if (input.startsWith(":nonbtl")) {
                prefs.putDouble("New Best Time Limit", 0.0);
                continue;
            }
            if (input.startsWith(":edge limit") || input.startsWith(":el")) {
                tokens = input.split("\\s+");
                last = tokens[tokens.length - 1];
                try {
                    int limit = Integer.parseInt(last);
                    prefs.putInt("Edge Limit", limit);
                }
                catch (NumberFormatException exc) {
                    System.out.println("Expecting an edge limit, rather than: " + last);
                }
                continue;
            }
            if (input.startsWith(":no edge limit") || input.startsWith(":noel")) {
                prefs.putInt("Edge Limit", 0);
                continue;
            }
            if (input.startsWith(":pruning value") || input.startsWith(":pv")) {
                tokens = input.split("\\s+");
                last = tokens[tokens.length - 1];
                try {
                    int val = Integer.parseInt(last);
                    prefs.putInt("Pruning Value", val);
                }
                catch (NumberFormatException exc) {
                    System.out.println("Expecting an integer pruning value, rather than: " + last);
                }
                continue;
            }
            if (input.startsWith(":no pruning value") || input.startsWith(":nopv")) {
                prefs.putInt("Pruning Value", 0);
                continue;
            }
            if (input.startsWith(":cell pruning value") || input.startsWith(":cpv")) {
                tokens = input.split("\\s+");
                last = tokens[tokens.length - 1];
                try {
                    int val = Integer.parseInt(last);
                    prefs.putInt("Cell Pruning Value", val);
                }
                catch (NumberFormatException exc) {
                    System.out.println("Expecting an integer cell pruning value, rather than: " + last);
                }
                continue;
            }
            if (input.startsWith(":no cell pruning value") || input.startsWith(":nocpv")) {
                prefs.putInt("Cell Pruning Value", 0);
                continue;
            }
            if (input.equals(":upon")) {
                prefs.putBoolean("Do Unpacking", true);
                continue;
            }
            if (input.equals(":upoff")) {
                prefs.putBoolean("Do Unpacking", false);
                continue;
            }
            if (input.startsWith(":select reading") || input.startsWith(":sel")) {
                tokens = input.split("\\s+");
                last = tokens[tokens.length - 1];
                try {
                    int reading = Integer.parseInt(last);
                    if (reading > lastResults.length) {
                        System.out.println("Only " + lastResults.length + " parses found.");
                        continue;
                    }
                    if (lastLFs[reading - 1] == null) {
                        System.out.println("LF not available, use :all command and reparse.");
                        continue;
                    }
                    lastReading = reading - 1;
                }
                catch (NumberFormatException exc) {
                    System.out.println("Expecting a reading number, rather than: " + last);
                }
                continue;
            }
            if (input.equals(":timing on") || input.equals(":ton") || input.equals(":t")) {
                prefs.putBoolean(SHOW_TIMING, true);
                continue;
            }
            if (input.equals(":timing off") || input.equals(":toff")) {
                prefs.putBoolean(SHOW_TIMING, false);
                continue;
            }
            if (input.equals(":show incomplete") || input.equals(":inc")) {
                prefs.putBoolean(SHOW_INCOMPLETE_EDGES, true);
                prefs.putBoolean("Show Completeness", true);
                continue;
            }
            if (input.equals(":noinc")) {
                prefs.putBoolean(SHOW_INCOMPLETE_EDGES, false);
                prefs.putBoolean("Show Completeness", false);
                continue;
            }
            if (input.equals(":indexing on") || input.equals(":ion")) {
                prefs.putBoolean("Use Indexing", true);
                continue;
            }
            if (input.equals(":indexing off") || input.equals(":ioff")) {
                prefs.putBoolean("Use Indexing", false);
                continue;
            }
            if (input.equals(":missing index combos on") || input.equals(":mion")) {
                prefs.putBoolean("Allow Missing Index Combos", true);
                continue;
            }
            if (input.equals(":missing index combos off") || input.equals(":mioff")) {
                prefs.putBoolean("Allow Missing Index Combos", false);
                continue;
            }
            if (input.equals(":chunks on") || input.equals(":con")) {
                prefs.putBoolean("Use Chunks", true);
                continue;
            }
            if (input.equals(":chunks off") || input.equals(":coff")) {
                prefs.putBoolean("Use Chunks", false);
                continue;
            }
            if (input.equals(":feature licensing on") || input.equals(":flon")) {
                prefs.putBoolean("Use Feature Licensing", true);
                continue;
            }
            if (input.equals(":feature licensing off") || input.equals(":floff")) {
                prefs.putBoolean("Use Feature Licensing", false);
                continue;
            }
            if (input.equals(":combos on") || input.equals(":ccon")) {
                prefs.putBoolean("Use Combos", true);
                continue;
            }
            if (input.equals(":combos off") || input.equals(":ccoff")) {
                prefs.putBoolean("Use Combos", false);
                continue;
            }
            if (input.equals(":pon")) {
                prefs.putBoolean("Use Packing", true);
                continue;
            }
            if (input.equals(":poff")) {
                prefs.putBoolean("Use Packing", false);
                continue;
            }
            if (input.startsWith(":realize") || input.startsWith(":r")) {
                NgramPrecisionModel ngramScorer;
                LF lf;
                block129: {
                    int space = input.indexOf(" ");
                    if (space != -1) {
                        String filename2 = TextCCG.readFilename(input.substring(space));
                        if (filename2 == null) {
                            System.out.println("Expecting a filename to read from.");
                            continue;
                        }
                        try {
                            Document doc = grammar.loadFromXml(filename2);
                            lf = Realizer.getLfFromDoc(doc);
                            List targetElts = doc.getRootElement().getChildren("target");
                            String[] targets = new String[targetElts.size()];
                            for (int i = 0; i < targetElts.size(); ++i) {
                                String target;
                                Element ex = (Element)targetElts.get(i);
                                targets[i] = target = ex.getText();
                            }
                            ngramScorer = new NgramPrecisionModel(targets);
                            break block129;
                        }
                        catch (IOException exc) {
                            System.out.println("Unable to read: " + filename2);
                            System.out.println(exc.toString());
                            continue;
                        }
                    }
                    if (lastLFs == null || lastLFs[lastReading] == null) {
                        System.out.println("Nothing to realize!");
                        continue;
                    }
                    lf = grammar.transformLF((LF)lastLFs[lastReading]);
                    String[] targets = new String[]{lastSentence};
                    ngramScorer = new NgramPrecisionModel(targets);
                }
                realizer.realize(lf, ngramScorer);
                Chart chart = realizer.getChart();
                boolean showIncompleteEdges = prefs.getBoolean(SHOW_INCOMPLETE_EDGES, false);
                boolean showTiming = prefs.getBoolean(SHOW_TIMING, false);
                if (showIncompleteEdges) {
                    chart.printEdges();
                } else {
                    chart.printEdges(true, true);
                }
                if (!showTiming) continue;
                chart.printTiming();
                continue;
            }
            if (input.startsWith(":2xml")) {
                if (lastLFs == null || lastLFs[lastReading] == null) {
                    System.out.println("Nothing to save!");
                    continue;
                }
                filename = TextCCG.readFilename(input.substring(5));
                if (filename == null) {
                    System.out.println("Expecting a filename to save to.");
                    continue;
                }
                grammar.saveToXml((LF)lastLFs[lastReading], lastSentence, filename);
                System.out.println("Wrote LF to \"" + filename + "\"");
                continue;
            }
            if (input.startsWith(":2tb")) {
                if (lastLFs == null || lastLFs[lastReading] == null) {
                    System.out.println("Nothing to save!");
                    continue;
                }
                filename = TextCCG.readFilename(input.substring(4));
                if (filename == null) {
                    filename = "testbed.xml";
                }
                RegressionInfo.addToTestbed(grammar, (Sign)lastResults[lastReading], lastResults.length, (LF)lastLFs[lastReading], filename);
                System.out.println("Added test item to \"" + filename + "\"");
                continue;
            }
            if (input.startsWith(":2apml")) {
                if (lastSentence.length() == 0) {
                    System.out.println("Nothing to save!");
                    continue;
                }
                filename = TextCCG.readFilename(input.substring(6));
                if (filename == null) {
                    System.out.println("Expecting a filename to save to.");
                    continue;
                }
                grammar.saveToApml((Sign)lastResults[lastReading], filename);
                System.out.println("Wrote \"" + lastSentence + "\" to \"" + filename + "\" as APML");
                continue;
            }
            if (input.startsWith(":vison")) {
                prefs.putBoolean(VISUALIZE, true);
                if (input.startsWith(":vison ") && input.length() >= 8) {
                    String fname = input.substring(7);
                    if (fname.lastIndexOf(46) != -1) {
                        System.out.println("Filename should not contain a suffix. Suffixes .tex and .dvi are assumed.");
                        prefs.put("VISFNAME", "");
                        continue;
                    }
                    prefs.put("VISFNAME", fname);
                    continue;
                }
                prefs.put("VISFNAME", "");
                continue;
            }
            if (input.equals(":visoff")) {
                prefs.putBoolean(VISUALIZE, false);
                prefs.put("VISFNAME", "");
                continue;
            }
            if (input.equals(":wordpos")) {
                prefs.putBoolean("Use Word Positions To Convert Atoms", true);
                continue;
            }
            if (input.equals(":nowordpos")) {
                prefs.putBoolean("Use Word Positions To Convert Atoms", false);
                continue;
            }
            if (input.equals(":eisner")) {
                prefs.putBoolean("Use Eisner Constraints", true);
                AbstractCompositionRule.useEisnerConstraints = true;
                continue;
            }
            if (input.equals(":noeisner")) {
                prefs.putBoolean("Use Eisner Constraints", false);
                AbstractCompositionRule.useEisnerConstraints = false;
                continue;
            }
            if (input.startsWith(":parse time limit") || input.startsWith(":ptl")) {
                tokens = input.split("\\s+");
                last = tokens[tokens.length - 1];
                try {
                    int limit = Integer.parseInt(last);
                    prefs.putInt("Parse Time Limit", limit);
                }
                catch (NumberFormatException exc) {
                    System.out.println("Expecting a time limit in ms, rather than: " + last);
                }
                continue;
            }
            if (input.startsWith(":no parse time limit") || input.startsWith(":noptl")) {
                prefs.putInt("Parse Time Limit", 0);
                continue;
            }
            if (input.startsWith(":parse edge limit") || input.startsWith(":pel")) {
                tokens = input.split("\\s+");
                last = tokens[tokens.length - 1];
                try {
                    int limit = Integer.parseInt(last);
                    prefs.putInt("Parse Edge Limit", limit);
                }
                catch (NumberFormatException exc) {
                    System.out.println("Expecting an edge limit, rather than: " + last);
                }
                continue;
            }
            if (input.startsWith(":no parse edge limit") || input.startsWith(":nopel")) {
                prefs.putInt("Parse Edge Limit", 0);
                continue;
            }
            if (input.startsWith(":parse pruning value") || input.startsWith(":ppv")) {
                tokens = input.split("\\s+");
                last = tokens[tokens.length - 1];
                try {
                    int val = Integer.parseInt(last);
                    prefs.putInt("Parse Pruning Value", val);
                }
                catch (NumberFormatException exc) {
                    System.out.println("Expecting an integer pruning value, rather than: " + last);
                }
                continue;
            }
            if (input.startsWith(":no parse pruning value") || input.startsWith(":noppv")) {
                prefs.putInt("Parse Pruning Value", 0);
                continue;
            }
            if (input.startsWith(":parse cell pruning value") || input.startsWith(":pcpv")) {
                tokens = input.split("\\s+");
                last = tokens[tokens.length - 1];
                try {
                    int val = Integer.parseInt(last);
                    prefs.putInt("Parse Cell Pruning Value", val);
                }
                catch (NumberFormatException exc) {
                    System.out.println("Expecting an integer cell pruning value, rather than: " + last);
                }
                continue;
            }
            if (input.startsWith(":no parse cell pruning value") || input.startsWith(":nopcpv")) {
                prefs.putInt("Parse Cell Pruning Value", 0);
                continue;
            }
            if (input.equals(":plazy")) {
                prefs.putBoolean("Parse Lazy Unpacking", true);
                continue;
            }
            if (input.equals(":noplazy")) {
                prefs.putBoolean("Parse Lazy Unpacking", false);
                continue;
            }
            try {
                if (input.length() == 0) {
                    if (lastSentence.length() > 0) {
                        input = lastSentence;
                    } else {
                        System.out.println("Nothing to parse!");
                        continue;
                    }
                }
                parser.parse(input);
                List<Sign> parses = parser.getResult();
                Sign[] results = new Sign[parses.size()];
                parses.toArray(results);
                int resLength = results.length;
                switch (resLength) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        System.out.println(resLength + " parse found.\n");
                        break;
                    }
                    default: {
                        System.out.println(resLength + " parses found.\n");
                    }
                }
                lastResults = results;
                lastLFs = new LF[resLength];
                if (input.length() > 0) {
                    lastSentence = input;
                }
                lastReading = 0;
                boolean showall = prefs.getBoolean(SHOW_ALL_RESULTS, false);
                boolean showderivs = prefs.getBoolean(SHOW_DERIVATIONS, false);
                boolean showsem = prefs.getBoolean(SHOW_SEMANTICS, true);
                boolean visualize = prefs.getBoolean(VISUALIZE, false);
                boolean showfeats = prefs.getBoolean(SHOW_FEATURES, false);
                String feats_to_show = prefs.get(FEATURES_TO_SHOW, "");
                Visualizer vis = null;
                String baseFileName = null;
                grammar.prefs.showSem = showsem;
                grammar.prefs.showFeats = showfeats;
                grammar.prefs.featsToShow = feats_to_show;
                if (visualize) {
                    vis = new Visualizer();
                    baseFileName = prefs.get("VISFNAME", "").equals("") ? vis.getTempFileName() : prefs.get("VISFNAME", "");
                    vis.writeHeader(baseFileName + ".tex");
                }
                int numToShow = showall ? resLength : 1;
                for (int i = 0; i < numToShow; ++i) {
                    Category cat = results[i].getCategory();
                    LF convertedLF = null;
                    if (cat.getLF() != null) {
                        cat = cat.copy();
                        Nominal index = cat.getIndexNominal();
                        Sign rootSign = results[i];
                        lastLFs[i] = convertedLF = HyloHelper.compactAndConvertNominals(cat.getLF(), index, rootSign);
                        cat.setLF(null);
                    }
                    String parseNum = resLength == 1 ? "Parse: " : "Parse " + (i + 1) + ": ";
                    System.out.print(parseNum + cat.toString());
                    if (showsem && convertedLF != null) {
                        System.out.println(" : ");
                        System.out.println("  " + convertedLF.prettyPrint("  "));
                    } else {
                        System.out.println();
                    }
                    if (showderivs) {
                        System.out.println("------------------------------");
                        System.out.println(results[i].getDerivationHistory());
                    }
                    if (!visualize) continue;
                    vis.saveTeXFile(results[i], baseFileName + ".tex");
                }
                if (!visualize) continue;
                vis.writeFooter(baseFileName + ".tex");
                vis.show(baseFileName);
                if (prefs.get("VISFNAME", "").equals("")) {
                    vis.cleanFiles(baseFileName);
                } else {
                    vis.cleanAuxFiles(baseFileName);
                    System.out.println("Saved to files " + baseFileName + ".tex and " + baseFileName + ".dvi");
                }
                vis = null;
            }
            catch (ParseException pe) {
                System.out.println(pe);
            }
        }
        prefs.put(historyKey, lineReader.getCommandHistory());
        System.out.println("Exiting tccg.");
        System.exit(0);
    }

    private static String readFilename(String s) throws IOException {
        StreamTokenizer st = new StreamTokenizer(new StringReader(s));
        st.wordChars(47, 47);
        st.wordChars(92, 92);
        st.wordChars(58, 58);
        st.nextToken();
        return st.sval;
    }

    public static void showHelp() {
        System.out.println();
        System.out.println("Commands for tccg (otherwise input is parsed):");
        System.out.println();
        System.out.println("  :sh\t\t\tshow current preference settings");
        System.out.println("  :v\t\t\tverbose output");
        System.out.println("  :reset\t\treset options to defaults");
        System.out.println("  :feats (L)\t\tshow features (or just show features in list L)");
        System.out.println("  :nofeats\t\tdon't show features");
        System.out.println("  :sem\t\t\tshow semantics");
        System.out.println("  :nosem\t\tdon't show semantics");
        System.out.println("  :all\t\t\tshow all parse results");
        System.out.println("  :notall\t\tdon't show all parse results");
        System.out.println("  :derivs\t\tshow derivations");
        System.out.println("  :noderivs\t\tdon't show derivations");
        System.out.println("  :vison (FN)\t\tturn visualization on (saving to file with name FN)");
        System.out.println("  :visoff\t\tturn visualization off");
        System.out.println("  :wordpos\t\tuse word positions to name converted nominals");
        System.out.println("  :nowordpos\t\tdon't use word positions to name converted nominals");
        System.out.println("  :eisner\t\tuse Eisner constraints on composition");
        System.out.println("  :noeisner\t\tturn off Eisner constraints on composition");
        System.out.println();
        System.out.println("  :ptl N\t\tset parse time limit to N ms");
        System.out.println("  :noptl\t\tset parse time limit to none");
        System.out.println("  :pel N\t\tset parse edge limit to N");
        System.out.println("  :nopel\t\tset parse edge limit to none");
        System.out.println("  :ppv N\t\tset parse pruning value to N");
        System.out.println("  :noppv\t\tset parse pruning value to none");
        System.out.println("  :pcpv N\t\tset parse cell pruning value to N");
        System.out.println("  :nopcpv\t\tset parse cell pruning value to none");
        System.out.println("  :plazy\t\tturn lazy unpacking on in parser");
        System.out.println("  :noplazy\t\tturn lazy unpacking off in parser");
        System.out.println();
        System.out.println("  :r (FN)\t\trealize selected reading (or from XML file with name FN)");
        System.out.println("  :sel N\t\tselect reading N for realization or saving");
        System.out.println("  :2xml FN\t\tsave last input and LF to XML file with name FN");
        System.out.println("  :2tb (FN)\t\tadd last input and LF as a test item (to file with name FN)");
        System.out.println("  :2apml FN\t\tsave last input to APML file with name FN");
        System.out.println();
        System.out.println("  :tl N\t\t\tset realization time limit to N ms");
        System.out.println("  :notl\t\t\tset realization time limit to none");
        System.out.println("  :nbtl N\t\tset realization new best time limit to N ms | N < 1 of first");
        System.out.println("  :nonbtl\t\tset realization new best time limit to none");
        System.out.println("  :el N\t\t\tset realization edge limit to N");
        System.out.println("  :noel\t\t\tset realization edge limit to none");
        System.out.println("  :pv N\t\t\tset realization pruning value to N");
        System.out.println("  :nopv\t\t\tset realization pruning value to none");
        System.out.println("  :cpv N\t\tset realization cell pruning value to N");
        System.out.println("  :nocpv\t\tset realization cell pruning value to none");
        System.out.println("  :upon\t\t\tturn unpacking on");
        System.out.println("  :upoff\t\tturn unpacking off");
        System.out.println("  :t\t\t\tturn realization timing on");
        System.out.println("  :toff\t\t\tturn realization timing off");
        System.out.println("  :inc\t\t\tshow incomplete realization edges");
        System.out.println("  :noinc\t\tdon't show incomplete realization edges");
        System.out.println();
        System.out.println("  :ion\t\t\tturn index filtering on");
        System.out.println("  :ioff\t\t\tturn index filtering off");
        System.out.println("  :mion\t\t\tturn missing index combos on");
        System.out.println("  :mioff\t\tturn missing index combos off");
        System.out.println("  :con\t\t\tturn LF chunks on");
        System.out.println("  :coff\t\t\tturn LF chunks off");
        System.out.println("  :flon\t\t\tturn feature licensing on");
        System.out.println("  :floff\t\tturn feature licensing off");
        System.out.println("  :ccon\t\t\tturn collected combos on");
        System.out.println("  :ccoff\t\tturn collected combos off");
        System.out.println("  :pon\t\t\tturn packing on");
        System.out.println("  :poff\t\t\tturn packing off");
        System.out.println();
        System.out.println("  :q\t\t\tquit tccg");
        System.out.println("  :h\t\t\tshow this message");
        System.out.println();
    }

    public static void showSettings(Preferences prefs) {
        System.out.println();
        System.out.println("Current preference settings:");
        System.out.println();
        boolean showfeats = prefs.getBoolean(SHOW_FEATURES, false);
        boolean showsem = prefs.getBoolean(SHOW_SEMANTICS, true);
        String feats = prefs.get(FEATURES_TO_SHOW, "");
        System.out.println("  show feats:\t\t" + showfeats);
        System.out.println("  show semantics:\t" + showsem);
        if (showfeats) {
            System.out.println("  feats to show:\t" + (feats.length() > 0 ? feats : "all"));
        }
        boolean showall = prefs.getBoolean(SHOW_ALL_RESULTS, false);
        boolean showderivs = prefs.getBoolean(SHOW_DERIVATIONS, false);
        System.out.println("  show all:\t\t" + showall);
        System.out.println("  show derivs:\t\t" + showderivs);
        boolean visualize = prefs.getBoolean(VISUALIZE, false);
        String visfname = prefs.get("VISFNAME", "");
        System.out.println("  visualize:\t\t" + (visualize ? "on" : "off"));
        if (visfname.length() > 0) {
            System.out.println("  vis file name:\t" + visfname);
        }
        boolean wordpos = prefs.getBoolean("Use Word Positions To Convert Atoms", true);
        System.out.println("  word pos:\t\t" + (wordpos ? "on" : "off"));
        boolean eisner = prefs.getBoolean("Use Eisner Constraints", true);
        System.out.println("  Eisner constraints:\t" + (eisner ? "on" : "off"));
        System.out.println();
        int ptl = prefs.getInt("Parse Time Limit", 0);
        System.out.println("  parse time limit:\t" + (ptl == 0 ? "none" : "" + ptl + " ms"));
        int pel = prefs.getInt("Parse Edge Limit", 0);
        System.out.println("  parse edge limit:\t" + (pel == 0 ? "none" : "" + pel));
        int ppv = prefs.getInt("Parse Pruning Value", 0);
        System.out.println("  parse pruning value:\t" + (ppv == 0 ? "none" : "" + ppv));
        int pcpv = prefs.getInt("Parse Cell Pruning Value", 0);
        System.out.println("  parse cell prune val:\t" + (pcpv == 0 ? "none" : "" + pcpv));
        boolean plazy = prefs.getBoolean("Parse Lazy Unpacking", true);
        System.out.println("  lazy unpacking:\t" + (plazy ? "on" : "off"));
        System.out.println();
        int tl = prefs.getInt("Time Limit", 0);
        System.out.println("  time limit:\t\t" + (tl == 0 ? "none" : "" + tl + " ms"));
        double nbtl = prefs.getDouble("New Best Time Limit", 0.0);
        String nbtlStr = nbtl >= 1.0 ? (int)nbtl + " ms" : nbtl + " of first";
        System.out.println("  new best time limit:\t" + (nbtl == 0.0 ? "none" : nbtlStr));
        int el = prefs.getInt("Edge Limit", 0);
        System.out.println("  edge limit:\t\t" + (el == 0 ? "none" : "" + el));
        int pv = prefs.getInt("Pruning Value", 0);
        System.out.println("  pruning value:\t" + (pv == 0 ? "none" : "" + pv));
        int cpv = prefs.getInt("Cell Pruning Value", 0);
        System.out.println("  cell pruning value:\t" + (cpv == 0 ? "none" : "" + cpv));
        boolean unpacking = prefs.getBoolean("Do Unpacking", true);
        System.out.println("  unpacking:\t\t" + (unpacking ? "on" : "off"));
        boolean showtiming = prefs.getBoolean(SHOW_TIMING, false);
        System.out.println("  timing:\t\t" + (showtiming ? "on" : "off"));
        boolean showinc = prefs.getBoolean(SHOW_INCOMPLETE_EDGES, false);
        System.out.println("  show incomplete:\t" + (showinc ? "on" : "off"));
        System.out.println();
        boolean indexing = prefs.getBoolean("Use Indexing", true);
        boolean missingIndexCombos = prefs.getBoolean("Allow Missing Index Combos", false);
        boolean chunks = prefs.getBoolean("Use Chunks", true);
        boolean licensing = prefs.getBoolean("Use Feature Licensing", true);
        boolean combos = prefs.getBoolean("Use Combos", true);
        boolean packing = prefs.getBoolean("Use Packing", false);
        System.out.println("  index filtering:\t" + (indexing ? "on" : "off"));
        System.out.println("  missing index combos:\t" + (missingIndexCombos ? "on" : "off"));
        System.out.println("  chunks:\t\t" + (chunks ? "on" : "off"));
        System.out.println("  licensing:\t\t" + (licensing ? "on" : "off"));
        System.out.println("  combos:\t\t" + (combos ? "on" : "off"));
        System.out.println("  packing:\t\t" + (packing ? "on" : "off"));
        System.out.println();
    }
}

