/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.alignment;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.Queue;
import opennlp.ccg.alignment.Mapping;
import opennlp.ccg.alignment.MappingFormat;
import opennlp.ccg.alignment.MappingGroup;

public class MappingReader
extends FilterReader {
    final MappingFormat format;
    private MappingGroup currentGroup;
    private Queue<Mapping> mappingQueue;
    private int mappingCount = 0;
    private boolean skipLF = false;

    public MappingReader(Reader r, MappingFormat format) {
        super(r);
        if (format == null) {
            throw new IllegalArgumentException("format is null");
        }
        this.format = format;
        this.mappingQueue = new LinkedList<Mapping>();
    }

    public MappingFormat getFormat() {
        return this.format;
    }

    public MappingGroup nextGroup() throws IOException {
        this.checkMappingCount();
        this.mappingCount = 0;
        MappingGroup previous = this.currentGroup == null ? null : this.currentGroup;
        int newCount = this.mappingQueue.size();
        this.currentGroup = newCount == 0 ? null : new MappingGroup(this.mappingQueue.peek().phraseNumber, newCount);
        boolean eog = false;
        while (!eog) {
            int i;
            StringBuilder sb = new StringBuilder();
            while ((i = this.in.read()) != -1) {
                char c = (char)i;
                if (this.skipLF) {
                    this.skipLF = false;
                    if (c == '\n') continue;
                }
                if (c == '\r') {
                    this.skipLF = true;
                }
                if (this.format.encodingScheme.isMappingDelimiter(Character.valueOf(c))) break;
                if (this.format.encodingScheme.isGroupDelimiter(Character.valueOf(c))) {
                    eog = true;
                    break;
                }
                sb.append(c);
            }
            if (sb.length() == 0) break;
            Mapping a = null;
            try {
                a = this.format.parseMapping(sb.toString());
            }
            catch (ParseException pe) {
                throw new IOException((this.currentGroup == null ? "" : "group " + this.currentGroup.phraseNumber + ": ") + "problem formatting mapping " + sb.toString() + " at offset " + pe.getErrorOffset() + ": " + pe.getMessage(), pe);
            }
            if (this.currentGroup == null) {
                Integer I = a.phraseNumber == null ? (previous == null ? this.format.encodingScheme.getPhraseNumberBase().start : previous.phraseNumber + 1) : a.phraseNumber;
                this.currentGroup = new MappingGroup(I, 0);
            }
            if (a.phraseNumber == null) {
                a = a.copyWithPhraseNumber(this.currentGroup.phraseNumber);
            }
            if (!this.currentGroup.phraseNumber.equals(a.phraseNumber)) {
                eog = true;
            } else {
                ++newCount;
            }
            if (this.mappingQueue.offer(a)) continue;
            throw new IOException("unable to read mapping");
        }
        if (this.currentGroup != null) {
            this.currentGroup.length = newCount;
        }
        return this.currentGroup == null || this.currentGroup.length == 0 ? null : this.currentGroup;
    }

    public boolean canRead() {
        return this.currentGroup != null && this.mappingCount < this.currentGroup.length;
    }

    @Override
    public int read() throws IOException {
        this.checkRead();
        int c = super.read();
        if (this.skipLF) {
            this.skipLF = false;
            if (c == 10) {
                c = super.read();
            }
        }
        return c;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.checkRead();
        if (len < 1) {
            return 0;
        }
        if (this.skipLF) {
            int c = this.read();
            this.skipLF = false;
            if (c == -1) {
                return c;
            }
            if (c != 10) {
                cbuf[off++] = (char)c;
                --len;
            }
        }
        return super.read(cbuf, off, len);
    }

    @Override
    public boolean ready() throws IOException {
        return this.canRead();
    }

    public Mapping readMapping() throws IOException {
        this.checkRead();
        Mapping a = this.mappingQueue.poll();
        if (a != null) {
            ++this.mappingCount;
        }
        return a;
    }

    @Override
    public void close() throws IOException {
        try {
            this.checkMappingCount();
        }
        finally {
            super.close();
        }
    }

    void checkRead() throws IOException {
        if (!this.canRead()) {
            throw new IOException("no mappings available");
        }
    }

    void checkMappingCount() throws IOException {
        if (this.currentGroup == null && this.mappingCount > 0 || this.currentGroup != null && this.mappingCount != this.currentGroup.length) {
            throw new IOException(this.currentGroup == null ? "" : "group " + this.currentGroup.phraseNumber + ": mapping count does not match: expected " + (this.currentGroup == null ? 0 : this.currentGroup.length) + ", but was " + this.mappingCount);
        }
    }
}

