/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.disjunctivizer;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import opennlp.ccg.alignment.PhrasePosition;
import opennlp.ccg.disjunctivizer.EdgeMatchFilter;
import opennlp.ccg.disjunctivizer.FilteredLFEdgeSet;
import opennlp.ccg.disjunctivizer.LFGraphDifference;
import opennlp.ccg.disjunctivizer.LabelMatchFilter;
import opennlp.ccg.disjunctivizer.MatchType;
import opennlp.ccg.hylo.Mode;
import opennlp.ccg.hylo.Proposition;
import opennlp.ccg.hylo.graph.LFEdge;
import opennlp.ccg.hylo.graph.LFEdgeLabel;
import opennlp.ccg.hylo.graph.LFGraph;
import opennlp.ccg.hylo.graph.LFVertex;
import opennlp.ccg.util.DelegatedFilter;
import opennlp.ccg.util.Filter;
import opennlp.ccg.util.FilteredSet;
import opennlp.ccg.util.MembershipFilter;
import opennlp.ccg.util.VisitedFilter;
import org.jgrapht.Graph;
import org.jgrapht.traverse.DepthFirstIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Disjunctivizer {
    public static final String ATTS_TAG = "atts";
    public static final String CHOICE_TAG = "one-of";
    public static final String DLF_TAG = "dlf";
    public static final String NODE_TAG = "node";
    public static final String OPTIONAL_TAG = "opt";
    public static final String RELATION_TAG = "rel";
    public static final String ID_ATTR = "id";
    public static final String IDREF_ATTR = "idref";
    public static final String NAME_ATTR = "name";
    public static final String PRED_ATTR = "pred";
    public static final String SHARED_ATTR = "shared";
    public static final String FOREIGN_SUFFIX = "f";
    Document document;
    boolean processingInserts;
    boolean processingDeletes;
    boolean processingSubstitutions;
    private Element disjunctiveLF;
    private LFGraphDifference graphDifference;
    private Set<LFVertex> importedVertices = null;
    private Map<LFVertex, LFVertex> vertexAliases = null;
    private Map<LFVertex, LFVertex> foreignAlignedSubgraphRoots = null;

    public Disjunctivizer() throws ParserConfigurationException {
        this(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
    }

    public Disjunctivizer(Document document) {
        this(document, true, true, true);
    }

    public Disjunctivizer(Document document, boolean processingInserts, boolean processingDeletes, boolean processingSubstitutions) {
        if (document == null) {
            throw new IllegalArgumentException("document is null");
        }
        this.document = document;
        this.processingInserts = processingInserts;
        this.processingDeletes = processingDeletes;
        this.processingSubstitutions = processingSubstitutions;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public boolean isProcessingInserts() {
        return this.processingInserts;
    }

    public void setProcessingInserts(boolean processingInserts) {
        if (this.processingInserts != processingInserts) {
            this.processingInserts = processingInserts;
            this.resetDisjunctiveLF();
        }
    }

    public boolean isProcessingDeletes() {
        return this.processingDeletes;
    }

    public void setProcessingDeletes(boolean processingDeletes) {
        if (this.processingDeletes != processingDeletes) {
            this.processingDeletes = processingDeletes;
            this.resetDisjunctiveLF();
        }
    }

    public boolean isProcessingSubstitutions() {
        return this.processingSubstitutions;
    }

    public void setProcessingSubstitutions(boolean processingSubstitutions) {
        if (this.processingSubstitutions != processingSubstitutions) {
            this.processingSubstitutions = processingSubstitutions;
            this.resetDisjunctiveLF();
        }
    }

    private void resetDisjunctiveLF() {
        this.disjunctiveLF = null;
    }

    public Element buildDisjunctiveLFFor(LFGraphDifference graphDifference) {
        if (graphDifference == null) {
            throw new IllegalArgumentException("graph difference is null");
        }
        if (this.disjunctiveLF == null || !this.graphDifference.equals(graphDifference)) {
            this.graphDifference = graphDifference;
            if (this.foreignAlignedSubgraphRoots != null) {
                this.foreignAlignedSubgraphRoots = null;
            }
            if (this.importedVertices == null) {
                this.importedVertices = new HashSet<LFVertex>();
            } else {
                this.importedVertices.clear();
            }
            if (this.vertexAliases == null) {
                this.vertexAliases = new HashMap<LFVertex, LFVertex>();
            } else {
                this.vertexAliases.clear();
            }
            this.disjunctiveLF = this.document.createElement(DLF_TAG);
            for (LFVertex p : graphDifference.a.highestLFAncestors()) {
                this.disjunctiveLF.appendChild(this.createDisjunctiveElement(new DLFContext(PhrasePosition.A, p, this.disjunctiveLF)));
            }
        }
        return this.disjunctiveLF;
    }

    private void findForeignAlignedSubgraphRoots() {
        this.foreignAlignedSubgraphRoots = new HashMap<LFVertex, LFVertex>();
        LFGraphIterator rootIterator = new LFGraphIterator(this.graphDifference.b);
        Map<Integer, Set<Integer>> mappings = this.graphDifference.alignment.asMap(PhrasePosition.B);
        while (rootIterator.hasNext()) {
            LFVertex vertex = (LFVertex)rootIterator.next();
            if (this.foreignAlignedSubgraphRoots.containsKey(vertex) || !mappings.containsKey(vertex.getIndex())) continue;
            LFGraphIterator subgraphIterator = new LFGraphIterator(this.graphDifference.b, vertex);
            while (subgraphIterator.hasNext()) {
                this.foreignAlignedSubgraphRoots.put((LFVertex)subgraphIterator.next(), vertex);
            }
        }
    }

    private Element createDisjunctiveElement(DLFContext context) {
        LFVertex alias = this.vertexAliases.get(context.vertex);
        String vertexName = this.nameFor(context.vertex);
        boolean imported = this.importedVertices.contains(context.vertex);
        Element newNode = this.document.createElement(NODE_TAG);
        context.parent.appendChild(newNode);
        DLFContext localContext = context.copy();
        localContext.parent = newNode;
        Set<LFVertex> locals = localContext.getVertices(VertexType.LOCAL_ANCESTOR);
        Set<LFVertex> visited = localContext.getVertices(VertexType.VISITED);
        if (locals.contains(localContext.vertex) || alias != null && visited.contains(localContext.vertex)) {
            LFVertex v = alias == null ? localContext.vertex : alias;
            localContext.parent.setAttribute(IDREF_ATTR, this.nameFor(v));
            if (visited.contains(localContext.vertex) && localContext.getVertices(VertexType.SHARED).contains(v) && !locals.contains(v)) {
                localContext.parent.setAttribute(SHARED_ATTR, "true");
            }
        } else {
            LFGraph graph;
            Set outgoingEdges;
            localContext.parent.setAttribute(ID_ATTR, alias == null ? vertexName : this.nameFor(alias));
            visited.add(localContext.vertex);
            locals.add(localContext.vertex);
            this.addNonPredAttributes(localContext);
            if (!imported && this.processingInserts) {
                this.processInserts(localContext);
            }
            if (!imported && this.processingDeletes) {
                this.processDeletes(localContext);
            }
            Set set = outgoingEdges = (graph = localContext.getGraph()).containsVertex(localContext.vertex) ? graph.outgoingEdgesOf(localContext.vertex) : Collections.EMPTY_SET;
            if (outgoingEdges.isEmpty()) {
                this.setPredicateName(localContext);
            } else if (!imported && this.processingSubstitutions) {
                this.processSubstitutions(localContext);
            } else {
                for (LFEdge out : outgoingEdges) {
                    if (imported) {
                        this.importedVertices.add(out.getTarget());
                    }
                    this.processNonsubstitutedEdge(localContext, out);
                }
            }
        }
        this.fixLabelReferences(newNode);
        return newNode;
    }

    private String nameFor(LFVertex vertex) {
        String vn = vertex.getName();
        return this.importedVertices.contains(vertex) ? vn + FOREIGN_SUFFIX : vn;
    }

    private void processInserts(DLFContext context) {
        Object optional = null;
        for (LFEdge ins : this.graphDifference.insertsFor(context.vertex)) {
            if (this.foreignAlignedSubgraphRoots == null) {
                this.findForeignAlignedSubgraphRoots();
            }
            if (this.foreignAlignedSubgraphRoots.containsKey(ins.getTarget())) continue;
            DLFContext ctxt = context.copy();
            ctxt.graphPosition = PhrasePosition.B;
            if (optional == null) {
                ctxt.parent = this.addOptional(context);
            }
            this.importedVertices.add(ins.getTarget());
            this.doInsertDelete(ctxt, ins);
        }
    }

    private void processDeletes(DLFContext context) {
        Object optional = null;
        for (LFEdge del : this.graphDifference.deletesFor(context.vertex)) {
            DLFContext ctxt = context.copy();
            if (optional == null) {
                ctxt.parent = this.addOptional(context);
            }
            this.doInsertDelete(ctxt.copy(), del);
        }
    }

    private void doInsertDelete(DLFContext context, LFEdge edge) {
        LFVertex trg = edge.getTarget();
        DLFContext ctxt = context.copy();
        ctxt.vertex = trg;
        ctxt.parent = this.addRelation(ctxt, edge.getLabel());
        ctxt.addVertex(trg, VertexType.OPTIONAL);
        ctxt.parent.appendChild(this.createDisjunctiveElement(ctxt));
    }

    private void processSubstitutions(DLFContext context) {
        for (LFEdge outgoing : context.getGraph().outgoingEdgesOf(context.vertex)) {
            if (this.graphDifference.substitutionsFor(outgoing).isEmpty()) {
                this.processNonsubstitutedEdge(context.copy(), outgoing);
                continue;
            }
            this.processSubstitutedEdge(context.copy(), outgoing);
        }
    }

    private void processNonsubstitutedEdge(DLFContext context, LFEdge outgoing) {
        if (!context.getVertices(VertexType.PREDICATES).contains(context.vertex)) {
            this.setPredicateName(context);
        }
        LFVertex trg = outgoing.getTarget();
        FilteredSet<LFVertex> similarTargets = new FilteredSet<LFVertex>(context.getVertices(VertexType.OPTIONAL), new SimilarTargetVertexFilter(trg));
        if (similarTargets.isEmpty()) {
            DLFContext ctxt = context.copy();
            ctxt.vertex = trg;
            ctxt.parent = this.addRelation(context, outgoing.getLabel());
            ctxt.parent.appendChild(this.createDisjunctiveElement(ctxt));
        } else {
            for (LFVertex similar : similarTargets) {
                this.assimilateAttributes(context.copy(), trg, similar);
            }
        }
    }

    private void processSubstitutedEdge(DLFContext context, LFEdge outgoing) {
        this.processSubstitutedSimilarTarget(context.copy(), outgoing);
        if (!context.getVertices(VertexType.PREDICATES).contains(context.vertex)) {
            this.processSubstitutedPredicates(context.copy(), outgoing);
        }
        Map<LFVertex, Set<LFEdge>> subsBySource = this.graphDifference.substitutionsBySourceFor(outgoing);
        EdgeMatchFilter predicateFilter = null;
        for (LFVertex subSource : subsBySource.keySet()) {
            Set<LFEdge> subEdges = subsBySource.get(subSource);
            if (predicateFilter == null) {
                predicateFilter = new EdgeMatchFilter(outgoing, MatchType.TARGET_PREDICATE_MISMATCH);
            } else {
                predicateFilter.setBasis(outgoing);
            }
            FilteredLFEdgeSet identicals = new FilteredLFEdgeSet((Set<? extends LFEdge>)subEdges, new MembershipFilter(context.getGraph().outgoingEdgesOf(context.vertex)));
            FilteredLFEdgeSet matchingLabels = new FilteredLFEdgeSet((Set<? extends LFEdge>)subEdges, new LabelMatchFilter(outgoing.getLabel()));
            FilteredSet<LFVertex> differentPredicates = new FilteredSet<LFVertex>(new FilteredLFEdgeSet(matchingLabels, predicateFilter).targetView(), new VisitedFilter());
            subEdges.removeAll(matchingLabels);
            differentPredicates.removeAll(identicals.targetView());
            subEdges.removeAll(identicals);
            if (subEdges.isEmpty() && differentPredicates.isEmpty()) {
                DLFContext ctxt = context.copyWithVertexMask(VertexType.LOCAL_ANCESTOR, VertexType.PREDICATES);
                this.fixOptions(ctxt, outgoing.getLabel());
                ctxt.parent = this.addRelation(context, outgoing.getLabel());
                ctxt.vertex = outgoing.getTarget();
                ctxt.parent.appendChild(this.createDisjunctiveElement(ctxt));
                continue;
            }
            if (!differentPredicates.isEmpty()) {
                this.processDifferentPredicates(context.copy(), outgoing, differentPredicates);
            }
            if (subEdges.isEmpty()) continue;
            this.processSubstitutedEdges(context.copy(), outgoing, subEdges);
        }
    }

    private void processDifferentPredicates(DLFContext context, LFEdge outgoing, Set<LFVertex> differentPredicates) {
        boolean terminal;
        LFEdgeLabel label = outgoing.getLabel();
        boolean bl = terminal = context.getGraph().outDegreeOf(context.vertex) == 0;
        if (!terminal) {
            boolean bl2 = terminal = !new FilteredSet<LFVertex>(differentPredicates, new TerminalFilter(this.graphDifference.b)).isEmpty();
        }
        if (terminal) {
            DLFContext ctxt = context.copy();
            ctxt.vertex = outgoing.getTarget();
            if (differentPredicates.size() == 1) {
                this.processSingletonDifferentPredicate(ctxt, outgoing, differentPredicates.iterator().next());
            } else {
                this.processMultipleDifferentPredicates(ctxt, outgoing, differentPredicates);
            }
        } else {
            DLFContext ctxt = context.copyWithVertexMask(VertexType.LOCAL_ANCESTOR, VertexType.PREDICATES);
            ctxt.vertex = outgoing.getTarget();
            ctxt.parent = this.addRelation(ctxt, label);
            ctxt.parent.appendChild(this.createDisjunctiveElement(ctxt));
        }
    }

    private void processSingletonDifferentPredicate(DLFContext context, LFEdge outgoing, LFVertex differentPredicate) {
        Element choiceElement;
        Element newRel;
        LFEdgeLabel label = outgoing.getLabel();
        context.parent = newRel = this.addRelation(context, label);
        context.parent = choiceElement = this.addChoice(context);
        Element targetElement = this.createDisjunctiveElement(context.copy(true));
        if (!this.vertexAliases.containsKey(differentPredicate)) {
            this.vertexAliases.put(differentPredicate, outgoing.getTarget());
        }
        context.vertex = differentPredicate;
        context.parent.appendChild(this.createDisjunctiveElement(context.copy(true)));
        NodeList newNodes = newRel.getElementsByTagName(NODE_TAG);
        for (int j = 0; j < newNodes.getLength(); ++j) {
            if (newNodes.item(j).getAttributes().getNamedItem(IDREF_ATTR) != null) continue;
            return;
        }
        newRel.replaceChild(targetElement, choiceElement);
    }

    private void processMultipleDifferentPredicates(DLFContext context, LFEdge outgoing, Set<LFVertex> differentPredicates) {
        Element choiceElement;
        LFEdgeLabel label = outgoing.getLabel();
        context.parent = choiceElement = this.addChoice(context);
        context.parent = this.addRelation(context, label);
        context.parent.appendChild(this.createDisjunctiveElement(context.copy(true)));
        context.parent = choiceElement;
        Element atts = this.addElement(context, ATTS_TAG);
        boolean aliased = false;
        for (LFVertex d : differentPredicates) {
            context.parent = atts;
            if (!aliased && !this.vertexAliases.containsKey(d)) {
                this.vertexAliases.put(d, outgoing.getTarget());
                aliased = true;
            }
            context.parent = this.addRelation(context, label);
            context.vertex = d;
            context.parent.appendChild(this.createDisjunctiveElement(context.copy(true)));
        }
    }

    private void processSubstitutedEdges(DLFContext context, LFEdge outgoing, Set<LFEdge> substituedEdges) {
        Element choiceElement;
        LFEdgeLabel label = outgoing.getLabel();
        boolean singleton = substituedEdges.size() == 1;
        context.parent = choiceElement = this.addChoice(context);
        Element toAppendTo = singleton ? choiceElement : this.addElement(context, ATTS_TAG);
        context.parent = this.addRelation(context, label);
        DLFContext ctxt = context.copy(true);
        ctxt.vertex = outgoing.getTarget();
        ctxt.parent.appendChild(this.createDisjunctiveElement(ctxt));
        boolean aliased = false;
        context.parent = toAppendTo;
        for (LFEdge s : substituedEdges) {
            LFVertex t = s.getTarget();
            String vPred = context.vertex.getPredicate();
            String tPred = t.getPredicate();
            LFEdgeLabel l = s.getLabel();
            context.parent = this.addRelation(context, l);
            if (vPred != null && vPred.equals(tPred) && !label.equals(l)) {
                Element subNode = this.addElement(context, NODE_TAG);
                subNode.setAttribute(IDREF_ATTR, this.nameFor(context.vertex));
                LFVertex sAlias = this.vertexAliases.get(context.vertex);
                if (!context.getVertices(VertexType.VISITED).contains(sAlias) || !context.getVertices(VertexType.SHARED).contains(sAlias) || context.getVertices(VertexType.LOCAL_ANCESTOR).contains(sAlias)) continue;
                subNode.setAttribute(SHARED_ATTR, "true");
                continue;
            }
            if (!(!singleton && aliased || this.vertexAliases.containsKey(t))) {
                this.vertexAliases.put(t, outgoing.getTarget());
                aliased = true;
            }
            DLFContext c = context.copy(true);
            c.vertex = t;
            this.importedVertices.add(t);
            c.graphPosition = PhrasePosition.B;
            c.parent.appendChild(this.createDisjunctiveElement(c));
        }
    }

    private void processSubstitutedSimilarTarget(DLFContext context, LFEdge outgoing) {
        LFVertex target = outgoing.getTarget();
        Map<LFVertex, Set<LFEdge>> subsBySource = this.graphDifference.substitutionsBySourceFor(outgoing);
        DLFContext ctxt = context.copy();
        for (LFVertex subSource : subsBySource.keySet()) {
            FilteredLFEdgeSet similarTargetEdges = new FilteredLFEdgeSet((Set<? extends LFEdge>)subsBySource.get(subSource), new SimilarTargetEdgeFilter(ctxt.vertex, outgoing.getLabel()));
            if (similarTargetEdges.isEmpty()) continue;
            if (similarTargetEdges.size() > 1) {
                System.err.println("more than one similar target edge for " + ctxt.vertex + ": " + similarTargetEdges);
            }
            this.assimilateAttributes(ctxt, target, ((LFEdge)similarTargetEdges.iterator().next()).getTarget());
            LFVertex hp = ctxt.getGraph().highestLFAncestorOf(target);
            if (hp != null && !hp.equals(outgoing.getSource())) continue;
            context.getVertices(VertexType.SHARED).add(target);
            ctxt.vertex = target;
            ctxt.vertices = context.copyVertices(VertexType.LOCAL_ANCESTOR, VertexType.PREDICATES);
            ctxt.parent.appendChild(this.createDisjunctiveElement(ctxt));
            return;
        }
    }

    private void processSubstitutedPredicates(DLFContext context, LFEdge outgoing) {
        final String predicate = context.vertex.getPredicate();
        if (predicate != null) {
            FilteredSet<LFVertex> alternates = new FilteredSet<LFVertex>(this.graphDifference.substitutionsBySourceFor(outgoing).keySet(), new DelegatedFilter<LFVertex, String>((Filter)new Filter<String>(){

                @Override
                public boolean allows(String s) {
                    return !predicate.equals(s);
                }
            }){

                @Override
                public String delegateValueFor(LFVertex e) {
                    return e.getPredicate();
                }
            });
            if (alternates.isEmpty()) {
                this.setPredicateName(context);
            } else {
                DLFContext ctxt = context.copy();
                ctxt.getVertices(VertexType.PREDICATES).add(ctxt.vertex);
                ctxt.parent = this.addChoice(ctxt);
                this.addAttributes(ctxt, PRED_ATTR, predicate);
                for (LFVertex ap : alternates) {
                    this.addAttributes(ctxt, PRED_ATTR, ap.getPredicate());
                }
            }
        }
    }

    private Element addRelation(DLFContext context, LFEdgeLabel label) {
        Element newRel = this.addElement(context, RELATION_TAG);
        newRel.setAttribute(NAME_ATTR, label.getName());
        return newRel;
    }

    private Element addOptional(DLFContext context) {
        return this.addElement(context, OPTIONAL_TAG);
    }

    private Element addChoice(DLFContext context) {
        return this.addElement(context, CHOICE_TAG);
    }

    private Element addElement(DLFContext context, String elementName) {
        Element newEl = this.document.createElement(elementName);
        context.parent.appendChild(newEl);
        return newEl;
    }

    private Element addAttributes(DLFContext context, String name, String value) {
        Element newAtts = this.document.createElement(ATTS_TAG);
        context.parent.appendChild(newAtts);
        newAtts.setAttribute(name, value);
        return newAtts;
    }

    private Element addAttributes(DLFContext context, Map<Mode, Proposition> attributes) {
        Element newAtts = this.document.createElement(ATTS_TAG);
        context.parent.appendChild(newAtts);
        for (Mode m : attributes.keySet()) {
            String n = m.getName();
            if (n.equals(PRED_ATTR)) continue;
            newAtts.setAttribute(n, attributes.get(m).getName());
        }
        return newAtts;
    }

    private void fixLabelReferences(Element newNode) {
        NodeList rels = newNode.getChildNodes();
        int rlen = rels.getLength();
        HashMap<String, String> refRels = new HashMap<String, String>(rlen);
        for (int k = 0; k < rlen; ++k) {
            Element ne;
            Node m;
            Node n = rels.item(k);
            if (n == null || n.getNodeType() != 1 || !n.getNodeName().equals(RELATION_TAG) || (m = (ne = (Element)n).getFirstChild()) == null || m.getNodeType() != 1 || !m.getNodeName().equals(NODE_TAG)) continue;
            Element me = (Element)m;
            String l = ne.getAttribute(NAME_ATTR);
            String idref = me.getAttribute(IDREF_ATTR);
            if (idref == null || idref.length() == 0) {
                String id = me.getAttribute(ID_ATTR);
                if (id == null || id.length() <= 0) continue;
                refRels.put(l, id);
                continue;
            }
            if (idref.equals(refRels.get(l))) {
                newNode.removeChild(n);
                continue;
            }
            refRels.put(l, idref);
        }
    }

    private void fixOptions(DLFContext context, LFEdgeLabel label) {
        String cPred = context.vertex.getPredicate();
        if (cPred == null) {
            return;
        }
        NodeList ncs = context.parent.getChildNodes();
        block0: for (int j = 0; j < ncs.getLength(); ++j) {
            Node c = ncs.item(j);
            if (c == null || c.getNodeType() != 1 || !c.getNodeName().equals(OPTIONAL_TAG)) continue;
            NodeList rs = c.getChildNodes();
            for (int k = 0; k < rs.getLength(); ++k) {
                Node d;
                Node r = rs.item(k);
                if (r == null || r.getNodeType() != 1 || !r.getNodeName().equals(RELATION_TAG)) continue;
                Element re = (Element)r;
                if (!label.getName().equals(re.getAttribute(NAME_ATTR)) || (d = re.getFirstChild()) == null || d.getNodeType() != 1 || !d.getNodeName().equals(NODE_TAG) || !cPred.equals(((Element)d).getAttribute(PRED_ATTR))) continue;
                context.parent.removeChild(c);
                continue block0;
            }
        }
    }

    private void setPredicateName(DLFContext context) {
        String p = context.vertex.getPredicate();
        if (p != null) {
            context.parent.setAttribute(PRED_ATTR, p);
            context.getVertices(VertexType.PREDICATES).add(context.vertex);
        }
    }

    private void addNonPredAttributes(DLFContext context) {
        for (Mode m : context.vertex.attributeNames()) {
            String n = m.getName();
            if (n.equals(PRED_ATTR)) continue;
            context.parent.setAttribute(n, context.vertex.getAttributeValue(m).getName());
        }
    }

    private void assimilateAttributes(DLFContext context, LFVertex one, LFVertex two) {
        DLFContext ctxt;
        HashMap<Mode, Proposition> oneAttrs = new HashMap<Mode, Proposition>(one.getAttributeMap());
        HashMap<Mode, Proposition> twoAttrs = new HashMap<Mode, Proposition>(two.getAttributeMap());
        Iterator i = oneAttrs.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Set tes = twoAttrs.entrySet();
            if (!tes.contains(e)) continue;
            context.parent.setAttribute(((Mode)e.getKey()).getName(), ((Proposition)e.getValue()).getName());
            i.remove();
            tes.remove(e);
        }
        if (oneAttrs.isEmpty()) {
            if (!twoAttrs.isEmpty()) {
                ctxt = context.copy(true);
                ctxt.parent = this.addOptional(context);
                this.addAttributes(ctxt, twoAttrs);
            }
        } else if (twoAttrs.isEmpty()) {
            this.addAttributes(context.copy(), oneAttrs);
        } else {
            ctxt = context.copy(true);
            ctxt.parent = this.addChoice(context);
            this.addAttributes(ctxt, oneAttrs);
            this.addAttributes(ctxt, twoAttrs);
        }
    }

    static class LFGraphIterator
    extends DepthFirstIterator<LFVertex, LFEdge> {
        LFGraphIterator(LFGraph graph) {
            super((Graph)graph);
        }

        LFGraphIterator(LFGraph graph, LFVertex startVertex) {
            super((Graph)graph, (Object)startVertex);
        }
    }

    class DLFContext {
        PhrasePosition graphPosition;
        LFVertex vertex;
        Element parent;
        private Map<VertexType, Set<LFVertex>> vertices;

        DLFContext(PhrasePosition graphPosition, LFVertex vertex, Element parent) {
            this(graphPosition, vertex, parent, new EnumMap<VertexType, Set<LFVertex>>(VertexType.class));
        }

        DLFContext(PhrasePosition graphPosition, LFVertex vertex, Element parent, Map<VertexType, Set<LFVertex>> vertices) {
            this.graphPosition = graphPosition;
            this.vertex = vertex;
            this.parent = parent;
            this.vertices = vertices;
        }

        LFGraph getGraph() {
            return Disjunctivizer.this.graphDifference.get(this.graphPosition);
        }

        DLFContext copy() {
            return this.copy(false);
        }

        DLFContext copy(boolean copyVertices) {
            return copyVertices ? this.copyWithVertexMask(VertexType.values()) : new DLFContext(this.graphPosition, this.vertex, this.parent, this.vertices);
        }

        DLFContext copyWithVertexMask(VertexType ... vertexType) {
            return new DLFContext(this.graphPosition, this.vertex, this.parent, this.copyVertices(vertexType));
        }

        Map<VertexType, Set<LFVertex>> copyVertices() {
            return this.copyVertices(VertexType.values());
        }

        Map<VertexType, Set<LFVertex>> copyVertices(VertexType ... vertexType) {
            EnumMap<VertexType, Set<LFVertex>> m = new EnumMap<VertexType, Set<LFVertex>>(this.vertices);
            m.keySet().retainAll(Arrays.asList(vertexType));
            return m;
        }

        Set<LFVertex> getVertices(VertexType vertexType) {
            Set<LFVertex> vs = this.vertices.get((Object)vertexType);
            if (vs == null) {
                vs = new HashSet<LFVertex>();
                this.vertices.put(vertexType, vs);
            }
            return vs;
        }

        boolean addVertex(LFVertex vertex, VertexType vertexType) {
            return this.getVertices(vertexType).add(vertex);
        }
    }

    static enum VertexType {
        LOCAL_ANCESTOR,
        OPTIONAL,
        PREDICATES,
        SHARED,
        VISITED;

    }

    class TerminalFilter
    implements Filter<LFVertex> {
        LFGraph graph;

        TerminalFilter(LFGraph graph) {
            this.graph = graph;
        }

        @Override
        public boolean allows(LFVertex e) {
            return this.graph.outDegreeOf(e) == 0;
        }
    }

    static class SimilarTargetEdgeFilter
    extends DelegatedFilter<LFEdge, LFVertex> {
        LFEdgeLabel label;

        SimilarTargetEdgeFilter(LFVertex vertex, LFEdgeLabel label) {
            super(new SimilarTargetVertexFilter(vertex));
            this.label = label;
        }

        @Override
        public boolean allows(LFEdge e) {
            return super.allows(e) && this.label.equals(e.getLabel());
        }

        @Override
        public LFVertex delegateValueFor(LFEdge e) {
            return e.getTarget();
        }
    }

    static class SimilarTargetVertexFilter
    implements Filter<LFVertex> {
        LFVertex vertex;

        SimilarTargetVertexFilter(LFVertex vertex) {
            this.vertex = vertex;
        }

        @Override
        public boolean allows(LFVertex v) {
            String p = this.vertex.getPredicate();
            return p != null && p.equals(v.getPredicate());
        }
    }
}

