/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.grammar;

import java.util.ArrayList;
import java.util.List;
import opennlp.ccg.grammar.AbstractApplicationRule;
import opennlp.ccg.synsem.ArgStack;
import opennlp.ccg.synsem.BasicArg;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.ComplexCat;
import opennlp.ccg.synsem.Slash;
import opennlp.ccg.unify.GSubstitution;
import opennlp.ccg.unify.GUnifier;
import opennlp.ccg.unify.UnifyFailure;
import org.jdom.Element;

public abstract class AbstractSubstitutionRule
extends AbstractApplicationRule {
    private static final long serialVersionUID = 1L;
    protected boolean _isHarmonic;
    protected Slash _argSlash;

    @Override
    public Element toXml(String dir) {
        Element retval = new Element("substitution");
        retval.setAttribute("dir", dir);
        retval.setAttribute("harmonic", Boolean.toString(this._isHarmonic));
        return retval;
    }

    @Override
    protected List<Category> apply(Category xyzCat, Category yzCat) throws UnifyFailure {
        if (xyzCat instanceof ComplexCat && yzCat instanceof ComplexCat) {
            ComplexCat xyzCC = (ComplexCat)xyzCat;
            ComplexCat yzCC = (ComplexCat)yzCat;
            if (xyzCC.arity() < 2 || xyzCC.containsDollarArg() || xyzCC.containsSetArg() || yzCC.containsSetArg() || yzCC.containsDollarArg()) {
                throw new UnifyFailure();
            }
            ArgStack primaryStack = xyzCC.getArgStack();
            int size = primaryStack.size();
            BasicArg primaryArgY = (BasicArg)primaryStack.get(size - 2);
            primaryArgY.unifySlash(this._functorSlash);
            BasicArg primaryArgZ = (BasicArg)primaryStack.get(size - 1);
            primaryArgZ.unifySlash(this._argSlash);
            BasicArg secondaryArgZ = (BasicArg)yzCC.getOuterArg();
            secondaryArgZ.unifySlash(this._argSlash);
            Category secondaryY = yzCC.getResult();
            GSubstitution sub = new GSubstitution();
            GUnifier.unify(primaryArgZ.getCat(), secondaryArgZ.getCat(), sub);
            GUnifier.unify(primaryArgY.getCat(), secondaryY, sub);
            Category result = new ComplexCat(xyzCC.getTarget(), primaryStack.copyWithout(size - 2));
            sub.condense();
            result = (Category)result.fill(sub);
            ((ComplexCat)result).getOuterArg().setSlashModifier(false);
            this.appendLFs(xyzCat, yzCat, result, sub);
            ArrayList<Category> results = new ArrayList<Category>(1);
            this._headCats.clear();
            results.add(result);
            this._headCats.add(primaryArgY.getSlash().isModifier() ? yzCat : xyzCat);
            return results;
        }
        throw new UnifyFailure();
    }
}

