/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.grammardoc;

import java.util.EnumMap;
import java.util.Map;
import opennlp.ccg.grammardoc.Documenter;
import opennlp.ccg.grammardoc.DocumenterName;
import opennlp.ccg.grammardoc.DocumenterNotFoundException;

public class DocumenterFactory {
    private static final Map<DocumenterName, Documenter> documenters = new EnumMap<DocumenterName, Documenter>(DocumenterName.class);
    static final DocumenterFactory documenterFactory = new DocumenterFactory();

    private DocumenterFactory() {
    }

    public static DocumenterFactory newInstance() {
        return documenterFactory;
    }

    public Documenter newDocumenter() throws DocumenterNotFoundException {
        return this.newDocumenter(DocumenterName.DEFAULT);
    }

    public Documenter newDocumenter(String name) throws DocumenterNotFoundException {
        try {
            DocumenterName nm = DocumenterName.valueOf(name);
            return this.newDocumenter(nm);
        }
        catch (IllegalArgumentException iae) {
            throw new DocumenterNotFoundException(name);
        }
    }

    public synchronized Documenter newDocumenter(DocumenterName name) throws DocumenterNotFoundException {
        Documenter d = documenters.get((Object)name);
        if (d == null) {
            try {
                d = name.documenterClass.newInstance();
            }
            catch (InstantiationException ie) {
                throw new DocumenterNotFoundException(name, (Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                throw new DocumenterNotFoundException(name, (Throwable)iae);
            }
            documenters.put(name, d);
        }
        return d;
    }
}

