/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.synsem.LexSemOrigin;
import opennlp.ccg.synsem.Sign;

public class LexDependency {
    public Sign lexHead;
    public String rel;
    public Sign lexDep;

    public LexDependency(Sign lexHead, String rel, Sign lexDep) {
        this.lexHead = lexHead;
        this.rel = rel;
        this.lexDep = lexDep;
    }

    public int hashCode() {
        int retval = this.rel.hashCode();
        if (this.lexHead != null) {
            retval += 31 * this.lexHead.hashCode();
        }
        if (this.lexDep != null) {
            retval += 7 * this.lexDep.hashCode();
        }
        return retval;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LexDependency)) {
            return false;
        }
        LexDependency dep = (LexDependency)obj;
        return this.lexHead == dep.lexHead && this.lexDep == dep.lexDep && this.rel.equals(dep.rel);
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        if (this.lexHead == null) {
            retval.append("null");
        } else {
            retval.append(this.lexHead.getOrthography());
        }
        retval.append('<').append(this.rel).append('>');
        if (this.lexDep == null) {
            retval.append("null");
        } else {
            retval.append(this.lexDep.getOrthography());
        }
        return retval.toString();
    }

    public boolean filled() {
        return this.lexHead != null && this.lexDep != null;
    }

    public static List<LexDependency> unfilledLexDeps(List<SatOp> preds) {
        ArrayList<LexDependency> retval = new ArrayList<LexDependency>(4);
        Map<Nominal, Integer> nomIndex = HyloHelper.nomIndex(preds);
        Set<Nominal> nominals = nomIndex.keySet();
        if (nominals.size() == 1 && !HyloHelper.isLexPred(preds.get(0))) {
            Sign lexHead = null;
            LexSemOrigin origin = preds.get(0).getOrigin();
            if (!(origin instanceof Sign)) {
                return retval;
            }
            lexHead = (Sign)origin;
            for (SatOp pred : preds) {
                String rel = HyloHelper.getRel(pred);
                if (rel == null) continue;
                retval.add(new LexDependency(null, rel, lexHead));
                if (!HyloHelper.isRelPred(pred)) continue;
                retval.add(new LexDependency(lexHead, rel, null));
            }
            return retval;
        }
        for (Nominal root : nominals) {
            LexSemOrigin origin;
            if (!HyloHelper.isRoot(root, preds)) continue;
            Sign lexHead = null;
            int rootIndex = nomIndex.get(root);
            SatOp rootPred = preds.get(rootIndex);
            if (HyloHelper.isLexPred(rootPred) && (origin = rootPred.getOrigin()) instanceof Sign) {
                lexHead = (Sign)origin;
            }
            for (int i = ++rootIndex; i < preds.size() && HyloHelper.getPrincipalNominal(preds.get(i)).equals(root); ++i) {
                rootPred = preds.get(i);
                Nominal dep = HyloHelper.getSecondaryNominal(rootPred);
                if (dep == null) continue;
                String rel = HyloHelper.getRel(rootPred);
                LexDependency.addUnfilledLexDep(dep, lexHead, rel, preds, nomIndex, retval);
            }
        }
        return retval;
    }

    private static void addUnfilledLexDep(Nominal dep, Sign lexHead, String rel, List<SatOp> preds, Map<Nominal, Integer> nomIndex, List<LexDependency> retval) {
        if (!nomIndex.containsKey(dep)) {
            retval.add(new LexDependency(lexHead, rel, null));
            return;
        }
        int depIndex = nomIndex.get(dep);
        SatOp depPred = preds.get(depIndex);
        if (lexHead == null) {
            Sign lexDep = null;
            LexSemOrigin origin = depPred.getOrigin();
            if (origin instanceof Sign) {
                lexDep = (Sign)origin;
                retval.add(new LexDependency(lexHead, rel, lexDep));
            }
            lexHead = lexDep;
            rel = null;
        }
        for (int i = depIndex; i < preds.size() && HyloHelper.getPrincipalNominal(preds.get(i)).equals(dep); ++i) {
            depPred = preds.get(i);
            Nominal depdep = HyloHelper.getSecondaryNominal(depPred);
            if (depdep == null) continue;
            String relrel = rel == null ? HyloHelper.getRel(depPred) : rel + "." + HyloHelper.getRel(depPred);
            LexDependency.addUnfilledLexDep(depdep, lexHead, relrel, preds, nomIndex, retval);
        }
    }

    public static List<LexDependency> filledLexDeps(List<LexDependency> unfilled, List<SatOp> preds) {
        ArrayList<LexDependency> retval = new ArrayList<LexDependency>(unfilled.size());
        Map<Nominal, Integer> nomIndex = HyloHelper.nomIndex(preds);
        Iterator<LexDependency> it = unfilled.iterator();
        while (it.hasNext()) {
            SatOp headPred;
            SatOp ancestorPred;
            Nominal headnom;
            SatOp relPred;
            LexDependency udep = it.next();
            String[] rels = udep.rel.split("\\.");
            if (udep.lexDep == null) {
                SatOp depPred;
                relPred = LexDependency.findPred(udep.lexHead, rels[0], preds);
                SatOp descendantPred = LexDependency.findDescendantPred(relPred, 0, rels, preds, nomIndex);
                Nominal depnom = HyloHelper.getSecondaryNominal(descendantPred);
                if (!nomIndex.containsKey(depnom) || !HyloHelper.isLexPred(depPred = preds.get(nomIndex.get(depnom)))) continue;
                it.remove();
                if (!(depPred.getOrigin() instanceof Sign)) continue;
                Sign lexDep = (Sign)depPred.getOrigin();
                retval.add(new LexDependency(udep.lexHead, udep.rel, lexDep));
                continue;
            }
            if (udep.lexHead != null || !nomIndex.containsKey(headnom = HyloHelper.getPrincipalNominal(ancestorPred = LexDependency.findAncestorPred(relPred = LexDependency.findPred(udep.lexDep, rels[rels.length - 1], preds), rels.length - 1, rels, preds))) || !HyloHelper.isLexPred(headPred = preds.get(nomIndex.get(headnom)))) continue;
            it.remove();
            if (!(headPred.getOrigin() instanceof Sign)) continue;
            Sign lexHead = (Sign)headPred.getOrigin();
            retval.add(new LexDependency(lexHead, udep.rel, udep.lexDep));
        }
        return retval;
    }

    private static SatOp findPred(Sign origin, String rel, List<SatOp> preds) {
        for (SatOp pred : preds) {
            if (pred.getOrigin() != origin || !rel.equals(HyloHelper.getRel(pred))) continue;
            return pred;
        }
        return null;
    }

    private static SatOp findDescendantPred(SatOp current, int index, String[] rels, List<SatOp> preds, Map<Nominal, Integer> nomIndex) {
        if (index == rels.length - 1) {
            return current;
        }
        SatOp next = null;
        String rel = rels[++index];
        Nominal depnom = HyloHelper.getSecondaryNominal(current);
        for (int i = nomIndex.get(depnom).intValue(); i < preds.size() && HyloHelper.getPrincipalNominal(preds.get(i)).equals(depnom); ++i) {
            SatOp pred = preds.get(i);
            if (!rel.equals(HyloHelper.getRel(pred))) continue;
            next = pred;
            break;
        }
        if (next == null) {
            return null;
        }
        return LexDependency.findDescendantPred(next, index, rels, preds, nomIndex);
    }

    private static SatOp findAncestorPred(SatOp current, int index, String[] rels, List<SatOp> preds) {
        if (index == 0) {
            return current;
        }
        SatOp prev = null;
        String rel = rels[--index];
        Nominal headnom = HyloHelper.getPrincipalNominal(current);
        for (int i = 0; i < preds.size(); ++i) {
            SatOp pred = preds.get(i);
            if (!headnom.equals(HyloHelper.getSecondaryNominal(pred)) || !rel.equals(HyloHelper.getRel(pred))) continue;
            prev = pred;
            break;
        }
        if (prev == null) {
            return null;
        }
        return LexDependency.findAncestorPred(prev, index, rels, preds);
    }

    public static List<LexDependency> filterSameHead(List<LexDependency> deps1, List<LexDependency> deps2) {
        if (deps1.isEmpty() || deps2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LexDependency> retval = new ArrayList<LexDependency>(deps1.size());
        block0: for (LexDependency dep1 : deps1) {
            for (LexDependency dep2 : deps2) {
                if (dep1.lexHead != dep2.lexHead) continue;
                retval.add(dep1);
                continue block0;
            }
        }
        return retval;
    }
}

