/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo;

import opennlp.ccg.hylo.HyloVar;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.hylo.NominalAtom;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.unify.SimpleType;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.UnifyControl;
import opennlp.ccg.unify.UnifyFailure;
import org.jdom.Element;

public class NominalVar
extends HyloVar
implements Nominal {
    private static final long serialVersionUID = -2086362887254623273L;
    protected boolean shared = false;

    public NominalVar(String name) {
        super(name);
    }

    public NominalVar(String name, SimpleType st) {
        super(name, st);
    }

    public NominalVar(String name, SimpleType st, boolean shared) {
        super(name, st);
        this.shared = shared;
    }

    protected NominalVar(String name, int index, SimpleType st) {
        super(name, index, st);
    }

    protected NominalVar(String name, int index, SimpleType st, boolean shared) {
        super(name, index, st);
        this.shared = shared;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    @Override
    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public void setType(SimpleType st) {
        this._hashCode += st.getIndex() - this.type.getIndex();
        this.type = st;
    }

    @Override
    public LF copy() {
        return new NominalVar(this._name, this._index, this.type, this.shared);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof NominalVar)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(Nominal nom) {
        if (nom instanceof NominalVar) {
            return super.compareTo((NominalVar)nom);
        }
        int retval = this._name.compareTo(nom.getName());
        if (retval == 0) {
            retval = 1;
        }
        return retval;
    }

    @Override
    public Object unify(Object u, Substitution sub) throws UnifyFailure {
        if (this.equals(u)) {
            return this;
        }
        if (!(u instanceof LF)) {
            throw new UnifyFailure();
        }
        LF lf = (LF)u;
        if (lf.getType() == null) {
            throw new UnifyFailure();
        }
        SimpleType st = (SimpleType)this.type.unify(lf.getType(), sub);
        if (u instanceof NominalAtom) {
            return sub.makeSubstitution(this, u);
        }
        if (u instanceof NominalVar) {
            NominalVar u_nv = (NominalVar)u;
            if (this.type.equals(u_nv.getType())) {
                if (super.compareTo(u_nv) >= 0) {
                    return sub.makeSubstitution(this, u_nv);
                }
                return sub.makeSubstitution(u_nv, this);
            }
            if (this.type.equals(st)) {
                return sub.makeSubstitution(u_nv, this);
            }
            if (u_nv.getType().equals(st)) {
                return sub.makeSubstitution(this, u_nv);
            }
            String name = super.compareTo(u_nv) >= 0 ? u_nv._name + u_nv._index : this._name + this._index;
            NominalVar nv_st = new NominalVar(name, UnifyControl.getUniqueVarIndex(), st);
            sub.makeSubstitution(u_nv, nv_st);
            return sub.makeSubstitution(this, nv_st);
        }
        if (u instanceof HyloVar) {
            HyloVar u_hv = (HyloVar)u;
            if (this.type.equals(st)) {
                return sub.makeSubstitution(u_hv, this);
            }
            NominalVar nv_st = new NominalVar(this._name, UnifyControl.getUniqueVarIndex(), st);
            sub.makeSubstitution(u_hv, nv_st);
            return sub.makeSubstitution(this, nv_st);
        }
        throw new UnifyFailure();
    }

    @Override
    public Object fill(Substitution sub) throws UnifyFailure {
        Object val = sub.getValue(this);
        if (val != null) {
            return val;
        }
        return this;
    }

    @Override
    public Element toXml() {
        Element retval = new Element("nomvar");
        retval.setAttribute("name", this.nameWithType());
        return retval;
    }
}

