/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo;

import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.util.List;
import opennlp.ccg.hylo.Alt;
import opennlp.ccg.hylo.HyloFormula;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.hylo.NominalAtom;
import opennlp.ccg.hylo.NominalVar;
import opennlp.ccg.hylo.Op;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.LexSemOrigin;
import opennlp.ccg.unify.ModFcn;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.Unifier;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.unify.Variable;
import org.jdom.Content;
import org.jdom.Element;

public class SatOp
extends HyloFormula {
    private static final long serialVersionUID = -4953978442971984002L;
    protected List<Alt> alts = null;
    protected TIntArrayList opts = null;
    protected LexSemOrigin _origin = null;
    protected Nominal _nominal;
    protected LF _arg;

    public List<Alt> getAlts() {
        return this.alts;
    }

    public TIntArrayList getOpts() {
        return this.opts;
    }

    public LexSemOrigin getOrigin() {
        return this._origin;
    }

    public void setOrigin(LexSemOrigin origin) {
        this._origin = origin;
    }

    public SatOp(Element e) {
        boolean shared = "true".equals(e.getAttributeValue("shared"));
        String nom = e.getAttributeValue("nom");
        if (nom != null) {
            this._nominal = new NominalAtom(HyloHelper.prefix(nom), HyloHelper.type(nom), shared);
        } else {
            nom = e.getAttributeValue("nomvar");
            if (nom != null) {
                this._nominal = new NominalVar(HyloHelper.prefix(nom), HyloHelper.type(nom), shared);
            } else {
                throw new RuntimeException("Satop must have a nom or nomvar.");
            }
        }
        this._arg = HyloHelper.getLF_FromChildren(e);
    }

    public SatOp(Nominal nom, LF arg) {
        this._nominal = nom;
        this._arg = arg;
    }

    public Nominal getNominal() {
        return this._nominal;
    }

    public void setNominal(Nominal nominal) {
        this._nominal = nominal;
    }

    public LF getArg() {
        return this._arg;
    }

    public void setArg(LF arg) {
        this._arg = arg;
    }

    @Override
    public LF copy() {
        SatOp retval = new SatOp((Nominal)this._nominal.copy(), this._arg.copy());
        retval._origin = this._origin;
        return retval;
    }

    @Override
    public void deepMap(ModFcn mf) {
        this._nominal.deepMap(mf);
        this._arg.deepMap(mf);
        mf.modify(this);
    }

    @Override
    public boolean occurs(Variable var) {
        return this._nominal.occurs(var) || this._arg.occurs(var);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof SatOp && this._nominal.equals(((SatOp)o)._nominal) && this._arg.equals(((SatOp)o)._arg);
    }

    @Override
    public Object unify(Object u, Substitution sub) throws UnifyFailure {
        if (u instanceof HyloFormula) {
            if (u instanceof SatOp) {
                Nominal $nom = (Nominal)Unifier.unify(this._nominal, ((SatOp)u)._nominal, sub);
                LF $arg = (LF)Unifier.unify(this._arg, ((SatOp)u)._arg, sub);
                SatOp retval = new SatOp($nom, $arg);
                retval._origin = this._origin;
                return retval;
            }
            return super.unify(u, sub);
        }
        throw new UnifyFailure();
    }

    @Override
    public Object fill(Substitution sub) throws UnifyFailure {
        SatOp retval = new SatOp((Nominal)this._nominal.fill(sub), (LF)this._arg.fill(sub));
        retval._origin = this._origin;
        return retval;
    }

    public String toString() {
        boolean includeParens = !(this._arg instanceof Op);
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('@').append(this._nominal.toString());
        if (includeParens) {
            sbuf.append('(');
        }
        sbuf.append(this._arg.toString());
        if (includeParens) {
            sbuf.append(')');
        }
        return sbuf.toString();
    }

    @Override
    public String prettyPrint(String indent) {
        StringBuffer ibuf = new StringBuffer();
        ibuf.append(indent).append("  ");
        String nomStr = this._nominal.toString();
        for (int i = 0; i < nomStr.length(); ++i) {
            ibuf.append(' ');
        }
        String newIndent = ibuf.toString();
        boolean includeParens = !(this._arg instanceof Op);
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('@').append(nomStr);
        if (includeParens) {
            sbuf.append('(');
        }
        sbuf.append(this._arg.prettyPrint(newIndent));
        if (includeParens) {
            sbuf.append(')');
        }
        return sbuf.toString();
    }

    public int hashCode() {
        return this._nominal.hashCode() + this._arg.hashCode();
    }

    @Override
    public int hashCode(TObjectIntHashMap varMap) {
        return this._nominal.hashCode(varMap) + this._arg.hashCode(varMap);
    }

    @Override
    public boolean equals(Object obj, TObjectIntHashMap varMap, TObjectIntHashMap varMap2) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SatOp so = (SatOp)obj;
        return this._nominal.equals(so._nominal, varMap, varMap2) && this._arg.equals(so._arg, varMap, varMap2);
    }

    @Override
    public Element toXml() {
        Element retval = new Element("satop");
        if (this._nominal instanceof NominalAtom) {
            retval.setAttribute("nom", this._nominal.toString());
        } else {
            retval.setAttribute("nomvar", ((NominalVar)this._nominal).nameWithType());
        }
        Element argElt = this._arg.toXml();
        retval.addContent((Content)argElt);
        return retval;
    }
}

