/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.lexicon;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.datatype.Duration;

public class EnglishExpander {
    private static final DateFormat dateInMonthFormat = new SimpleDateFormat("dd", Locale.ENGLISH);
    private static final DateFormat monthFormat = new SimpleDateFormat("MMMM", Locale.ENGLISH);
    private static final DateFormat yearFormat = new SimpleDateFormat("yyyy", Locale.ENGLISH);
    private static final DateFormat hoursFormat = new SimpleDateFormat("hh", Locale.ENGLISH);
    private static final DateFormat minutesFormat = new SimpleDateFormat("mm", Locale.ENGLISH);
    private static final DateFormat amPmFormat = new SimpleDateFormat("a", Locale.ENGLISH);
    private static String[] durUnits = new String[]{"year", "month", "day", "hour", "minute", "second"};
    private static final String[] zeroToNine = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
    private static final String[] tenToNineteen = new String[]{"ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    private static final String[] zeroToNinety = new String[]{"zero", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    private static final String[] thousandToBillion = new String[]{"thousand", "million", "billion"};
    private static final String[] zerothToNinth = new String[]{"zeroth", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth"};
    private static final String[] tenthToNineteenth = new String[]{"tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", "sixteenth", "seventeenth", "eighteenth", "nineteenth"};
    private static final String[] zerothToNinetieth = new String[]{"zeroth", "tenth", "twentieth", "thirtieth", "fortieth", "fiftieth", "sixtieth", "seventieth", "eightieth", "ninetieth"};
    private static final String[] thousandthToBillionth = new String[]{"thousandth", "millionth", "billionth"};
    private static Map<String, String> ordinalMap = null;

    public static void expandDate(Date date, int style, List<String> list) {
        list.add("the");
        EnglishExpander.expandOrdinal(dateInMonthFormat.format(date), list);
        if (style == 2 || style == 1) {
            list.add("of");
            list.add(monthFormat.format(date));
        }
        if (style == 1) {
            list.add(",");
            String year = yearFormat.format(date);
            if (year.charAt(1) == '0' && year.charAt(2) == '0') {
                EnglishExpander.expandNumber(year, list);
            } else {
                EnglishExpander.expandNumber(year.substring(0, 2), list);
                EnglishExpander.expandNumber(year.substring(2), list);
            }
        }
    }

    public static void expandTime(Date time, List<String> list) {
        String hours = hoursFormat.format(time);
        EnglishExpander.expandNDigitNumber(hours, list);
        String minutes = minutesFormat.format(time);
        if (minutes.charAt(0) == '0' && minutes.charAt(1) != '0') {
            list.add("oh");
            EnglishExpander.expandNDigitNumber(minutes.substring(1), list);
        } else {
            EnglishExpander.expandNDigitNumber(minutes, list);
        }
        list.add(amPmFormat.format(time));
    }

    public static void expandAmount(String digitString, String currencyCode, List<String> list) {
        String currSing = null;
        String currPlur = null;
        String fracSing = null;
        String fracPlur = null;
        if (currencyCode.equals("GBP")) {
            currSing = "pound";
            currPlur = "pounds";
            fracSing = "penny";
            fracPlur = "pence";
        } else if (currencyCode.equals("USD")) {
            currSing = "dollar";
            currPlur = "dollars";
            fracSing = "cent";
            fracPlur = "cents";
        } else if (currencyCode.equals("EUR")) {
            currSing = "euro";
            currPlur = "euros";
            fracSing = "cent";
            fracPlur = "cents";
        }
        if (currSing == null) {
            EnglishExpander.expandNumber(digitString, list);
            list.add(currencyCode);
            return;
        }
        String whole = digitString;
        String frac = null;
        int dotIndex = digitString.indexOf(".");
        if (dotIndex != -1) {
            whole = digitString.substring(0, dotIndex);
            frac = digitString.substring(dotIndex + 1);
        }
        EnglishExpander.expandNumber(whole, list);
        if (whole.equals("1")) {
            list.add(currSing);
        } else {
            list.add(currPlur);
        }
        if (frac != null) {
            list.add("and");
            EnglishExpander.expandNDigitNumber(frac, list);
            if (frac.equals("01")) {
                list.add(fracSing);
            } else {
                list.add(fracPlur);
            }
        }
    }

    public static void expandDuration(Duration duration, List<String> list) {
        int i;
        int[] durationFields = new int[]{duration.getYears(), duration.getMonths(), duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds()};
        int counter = 0;
        for (i = 0; i < durationFields.length; ++i) {
            if (durationFields[i] <= 0) continue;
            ++counter;
        }
        for (i = 0; i < durationFields.length; ++i) {
            if (durationFields[i] <= 0) continue;
            --counter;
            String str = Integer.toString(durationFields[i]);
            EnglishExpander.expandNumber(str, list);
            String unit = durUnits[i];
            if (durationFields[i] != 1) {
                unit = unit + "s";
            }
            list.add(unit);
            if (counter > 1) {
                list.add(",");
            }
            if (counter != 1) continue;
            list.add("and");
        }
    }

    public static void expandDigits(String digitString, List<String> list) {
        for (int i = 0; i < digitString.length(); ++i) {
            list.add(zeroToNine[digitString.charAt(i) - 48]);
        }
    }

    public static void expandNumber(String digitString, List<String> list) {
        int dotIndex;
        if (digitString.length() == 0) {
            return;
        }
        char c0 = digitString.charAt(0);
        if (c0 == '+' || c0 == '-') {
            list.add(c0 == '+' ? "plus" : "minus");
            digitString = digitString.substring(1);
        }
        if ((dotIndex = digitString.indexOf(".")) != -1) {
            EnglishExpander.expandNDigitNumber(digitString.substring(0, dotIndex), list);
            list.add("point");
            EnglishExpander.expandDigits(digitString.substring(dotIndex + 1), list);
        } else {
            EnglishExpander.expandNDigitNumber(digitString, list);
        }
    }

    public static void expandOrdinal(String digitString, List<String> list) {
        EnglishExpander.expandNDigitNumber(digitString, list);
        int lastPos = list.size() - 1;
        String ordinal = EnglishExpander.getOrdinal(list.get(lastPos));
        list.set(lastPos, ordinal);
    }

    public static void expandNDigitNumber(String digitString, List<String> list) {
        int numDigits = digitString.length();
        if (numDigits == 2) {
            EnglishExpander.expand2DigitNumber(digitString, list);
        } else if (numDigits == 3) {
            EnglishExpander.expand3DigitNumber(digitString, list);
        } else if (numDigits >= 4 && numDigits <= 12) {
            EnglishExpander.expand4to12DigitNumber(digitString, list);
        } else {
            EnglishExpander.expandDigits(digitString, list);
        }
    }

    private static void expand2DigitNumber(String digitString, List<String> list) {
        if (digitString.charAt(0) == '0') {
            if (digitString.charAt(1) != '0') {
                EnglishExpander.expandDigits(digitString.substring(1), list);
            }
        } else if (digitString.charAt(0) == '1') {
            list.add(tenToNineteen[digitString.charAt(1) - 48]);
        } else {
            list.add(zeroToNinety[digitString.charAt(0) - 48]);
            if (digitString.charAt(1) != '0') {
                EnglishExpander.expandDigits(digitString.substring(1), list);
            }
        }
    }

    private static void expand3DigitNumber(String digitString, List<String> list) {
        if (digitString.charAt(0) != '0') {
            EnglishExpander.expandDigits(digitString.substring(0, 1), list);
            list.add("hundred");
        }
        if (digitString.charAt(1) != '0' || digitString.charAt(2) != '0') {
            list.add("and");
        }
        EnglishExpander.expand2DigitNumber(digitString.substring(1), list);
    }

    private static void expand4to12DigitNumber(String digitString, List<String> list) {
        int numDigitsModThree = digitString.length() % 3;
        int numInitialDigits = numDigitsModThree != 0 ? numDigitsModThree : 3;
        int unitsIndex = (digitString.length() - 1) / 3 - 1;
        EnglishExpander.expandNDigitNumber(digitString.substring(0, numInitialDigits), list);
        list.add(thousandToBillion[unitsIndex]);
        EnglishExpander.expandNDigitNumber(digitString.substring(numInitialDigits), list);
    }

    private static String getOrdinal(String number) {
        if (ordinalMap == null) {
            int i;
            ordinalMap = new HashMap<String, String>();
            for (i = 0; i < zeroToNine.length; ++i) {
                ordinalMap.put(zeroToNine[i], zerothToNinth[i]);
            }
            for (i = 0; i < tenToNineteen.length; ++i) {
                ordinalMap.put(tenToNineteen[i], tenthToNineteenth[i]);
            }
            for (i = 0; i < zeroToNinety.length; ++i) {
                ordinalMap.put(zeroToNinety[i], zerothToNinetieth[i]);
            }
            ordinalMap.put("hundred", "hundredth");
            for (i = 0; i < thousandToBillion.length; ++i) {
                ordinalMap.put(thousandToBillion[i], thousandthToBillionth[i]);
            }
        }
        return ordinalMap.get(number);
    }
}

