/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.ngrams;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.ccg.lexicon.ListPairWord;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.ngrams.FactoredNgramModelFamily;
import opennlp.ccg.ngrams.NgramScorer;
import opennlp.ccg.util.Pair;
import opennlp.ccg.util.SingletonList;

public class ConditionalProbabilityTable {
    protected FactoredNgramModelFamily model;

    public ConditionalProbabilityTable(String filename) throws IOException {
        this.model = new FactoredNgramModelFamily(filename, false);
        if (this.model.order != 1) {
            throw new RuntimeException("A conditional probability table must have n-gram order 1.");
        }
    }

    public void setDebug(boolean debugScore) {
        this.model.setDebug(debugScore);
    }

    public double score(List<Pair<String, String>> attrValList) {
        return NgramScorer.convertToProb(this.logprob(attrValList));
    }

    public double logprob(List<Pair<String, String>> attrValList) {
        return this.model.logprob(new SingletonList<Word>(new ListPairWord(attrValList)));
    }

    public static void main(String[] args) throws IOException {
        String usage = "Usage: java opennlp.ccg.ngrams.ConditionalProbabilityTable <specfile> <string of attr-val pairs>";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println(usage);
            System.exit(0);
        }
        String specfile = args[0];
        String tokens = args[1];
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        String[] tokenArray = tokens.split("\\s+");
        for (int i = 0; i < tokenArray.length; i += 2) {
            String attr = tokenArray[i].intern();
            String val = tokenArray[i + 1].intern();
            pairs.add(new Pair<String, String>(attr, val));
        }
        System.out.println("Loading conditional probability table from: " + specfile);
        ConditionalProbabilityTable table = new ConditionalProbabilityTable(specfile);
        FactoredNgramModelFamily lmFamily = table.model;
        System.out.println("primary child var: " + lmFamily.primaryGroup.childName);
        if (lmFamily.furtherGroups != null) {
            for (int i = 0; i < lmFamily.furtherGroups.length; ++i) {
                System.out.println("further child var: " + lmFamily.furtherGroups[i].childName);
            }
        }
        System.out.println("openVocab: " + lmFamily.openVocab);
        System.out.println();
        System.out.println("scoring: " + tokens);
        System.out.println();
        table.setDebug(true);
        double logprob = table.logprob(pairs);
        double score = NgramScorer.convertToProb(logprob);
        System.out.println("score: " + score);
        System.out.println("logprob: " + logprob);
    }
}

