/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.ngrams;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.ccg.lexicon.DefaultTokenizer;
import opennlp.ccg.lexicon.FactorKey;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.ngrams.NgramScorer;
import opennlp.ccg.util.TrieMap;

public class FactoredNgramModel
extends NgramScorer {
    public static Map<String, FactoredNgramModel> modelCache = new HashMap<String, FactoredNgramModel>();
    public final ModelVariable child;
    public final ModelVariable[] parents;

    public FactoredNgramModel(String child, String[] parents, String filename) throws IOException {
        this(child, parents, filename, true);
    }

    public FactoredNgramModel(String child, String[] parents, String filename, boolean useSemClasses) throws IOException {
        this.useSemClasses = useSemClasses;
        this.child = new ModelVariable(child);
        this.parents = new ModelVariable[parents.length];
        this.order = 1;
        for (int i = 0; i < parents.length; ++i) {
            this.parents[i] = new ModelVariable(parents[i]);
            this.order = Math.max(this.order, this.parents[i].position + 1);
        }
        this.numNgrams = new int[(int)Math.pow(2.0, parents.length)];
        FactoredNgramModel cachedModel = modelCache.get(filename);
        if (cachedModel != null) {
            this.numNgrams = cachedModel.numNgrams;
            this.openVocab = cachedModel.openVocab;
            this.trieMapRoot = cachedModel.trieMapRoot;
            this.cachedLogProbs = cachedModel.cachedLogProbs;
        } else {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            this.readModel(in);
            modelCache.put(filename, this);
        }
    }

    @Override
    protected List<String> ngram(int i, int order) {
        boolean ok = this.setKeysToNgram(i, order);
        if (!ok) {
            return null;
        }
        this.featureKeysList.clear();
        for (int j = 0; j < this.keysList.size(); ++j) {
            Object key = this.keysList.get(j);
            if (key instanceof String) {
                this.featureKeysList.add("W");
                this.featureKeysList.add((String)key);
                continue;
            }
            if (!(key instanceof FactorKey)) {
                throw new RuntimeException("Factor keys expected here!  key: " + key);
            }
            FactorKey fkey = (FactorKey)key;
            this.featureKeysList.add(fkey.factor);
            this.featureKeysList.add(fkey.val);
        }
        return this.featureKeysList;
    }

    @Override
    protected float logProbFromNgram(int i, int order) {
        int j;
        if (i == 0 && order == 1 && ((Word)this.wordsToScore.get(0)).getForm() == "<s>") {
            return 0.0f;
        }
        this.keysList.clear();
        int i0 = i + order - 1;
        int lastParentIndex = this.parents.length - 1;
        if (this.order > order) {
            for (j = 0; j < this.parents.length; ++j) {
                if (this.parents[j].position < order) continue;
                lastParentIndex = j - 1;
                break;
            }
        }
        for (j = lastParentIndex; j >= 0; --j) {
            int pos_j = i0 - this.parents[j].position;
            if (pos_j < i) continue;
            Word w = (Word)this.wordsToScore.get(pos_j);
            this.keysList.add(this.makeFactorKey(w, this.parents[j].name));
        }
        Word current = (Word)this.wordsToScore.get(i0);
        this.keysList.add(this.makeFactorKey(current, this.child.name));
        if (this.debugScore) {
            System.out.print("logp( " + this.keysList.get(this.keysList.size() - 1) + " | ");
            for (int j2 = this.keysList.size() - 2; j2 >= 0; --j2) {
                System.out.print(this.keysList.get(j2) + " ");
            }
            System.out.print(") = ");
        }
        float retval = this.logProb(0, this.keysList.size());
        if (current.getForm() == "</s>" && this.child.name != "W") {
            retval = 0.0f;
        }
        if (this.debugScore) {
            System.out.println("" + retval);
        }
        return retval;
    }

    private Object makeFactorKey(Word w, String attr) {
        String scr;
        String form = w.getForm();
        if (form == "<s>" || form == "</s>") {
            return FactorKey.getKey(attr, form);
        }
        String val = w.getVal(attr);
        if ((attr == "W" || attr == "S") && (scr = this.semClassReplacement(w)) != null) {
            val = scr;
        }
        Object retval = FactorKey.getKey(attr, val);
        if (this.openVocab && this.trieMapRoot.getChild(retval) == null) {
            val = "<unk>";
            retval = FactorKey.getKey(attr, val);
        }
        return retval;
    }

    private void readModel(Reader in) throws IOException {
        Object unkKey;
        StreamTokenizer tokenizer = FactoredNgramModel.initTokenizer(in);
        String[] tokens = new String[this.parents.length + 3];
        Object[] factorKeys = new Object[this.parents.length + 1];
        boolean foundData = false;
        int numParents = -1;
        int parentsInt = -1;
        ArrayList<Object> currentPrefix = new ArrayList<Object>();
        ArrayList<Object> currentKeys = null;
        ArrayList<TrieMap<Object, NgramScorer.NgramFloats>> currentChildren = null;
        while (tokenizer.ttype != -1) {
            int i;
            FactoredNgramModel.readLine(tokenizer, tokens);
            if (tokens[0] == null) continue;
            if (tokens[0].equals("\\data\\")) {
                foundData = true;
                continue;
            }
            if (!foundData) continue;
            if (tokens[0].equals("ngram")) {
                int total;
                int equalPos = tokens[1].indexOf("=");
                int n = Integer.decode(tokens[1].substring(0, equalPos));
                this.numNgrams[n] = total = Integer.parseInt(tokens[1].substring(equalPos + 1));
                if (currentChildren == null) {
                    currentChildren = new ArrayList<TrieMap<Object, NgramScorer.NgramFloats>>(total);
                    currentKeys = new ArrayList<Object>(total);
                }
                if (n != this.numNgrams.length - 1) continue;
                int totalNgrams = 0;
                for (int i2 = 0; i2 < this.numNgrams.length; ++i2) {
                    totalNgrams += this.numNgrams[i2];
                }
                continue;
            }
            if (tokens[0].equals("\\end\\")) {
                this.addTrieMapChildren(currentPrefix, currentKeys, currentChildren);
                break;
            }
            int gramsPos = -1;
            if (tokens[0].startsWith("\\") && (gramsPos = tokens[0].indexOf("-grams:")) > 0) {
                this.addTrieMapChildren(currentPrefix, currentKeys, currentChildren);
                parentsInt = Integer.decode(tokens[0].substring(1, gramsPos));
                numParents = this.numParents(parentsInt);
                continue;
            }
            if (numParents < 0) continue;
            int currentOrder = numParents + 1;
            float logprob = Float.parseFloat(tokens[0]);
            for (int i3 = 1; i3 < currentOrder + 1; ++i3) {
                String attr = i3 == currentOrder ? this.child.name : this.parents[currentOrder - i3 - 1].name;
                String val = tokens[i3];
                int hyphenPos = val.indexOf(45);
                if (hyphenPos > 0) {
                    String attrCheck = val.substring(0, hyphenPos).intern();
                    if (attr != attrCheck) {
                        System.err.println("Warning: expected attr " + attr + " rather than " + attrCheck + " in " + tokens[i3]);
                    }
                    val = val.substring(hyphenPos + 1);
                }
                if ((val = DefaultTokenizer.unescape(val)) != null) {
                    val = val.intern();
                }
                factorKeys[i3 - 1] = FactorKey.getKey(attr, val);
            }
            boolean samePrefix = currentPrefix.size() == currentOrder - 1;
            for (i = 0; samePrefix && i < currentOrder - 1; ++i) {
                if (factorKeys[i] == currentPrefix.get(i)) continue;
                samePrefix = false;
            }
            if (!samePrefix) {
                this.addTrieMapChildren(currentPrefix, currentKeys, currentChildren);
                for (i = 0; i < currentOrder - 1; ++i) {
                    currentPrefix.add(factorKeys[i]);
                }
            }
            Object key = factorKeys[currentOrder - 1];
            currentKeys.add(key);
            currentChildren.add(new TrieMap(new NgramScorer.NgramFloats(logprob, 0.0f)));
            if (tokens[currentOrder + 1] == null) continue;
            float bow = Float.parseFloat(tokens[currentOrder + 1]);
            TrieMap prefixNode = this.trieMapRoot.findChildFromList(currentPrefix);
            NgramScorer.NgramFloats nfloats = (NgramScorer.NgramFloats)prefixNode.data;
            if (nfloats != null) {
                nfloats.bow = bow;
                continue;
            }
            prefixNode.data = new NgramScorer.NgramFloats(0.0f, bow);
        }
        this.openVocab = this.trieMapRoot.getChild(unkKey = FactorKey.getKey(this.child.name, "<unk>")) != null;
    }

    private int numParents(int parentsInt) {
        int retval = 0;
        for (int i = 0; i < this.parents.length; ++i) {
            if ((parentsInt & 1) != 0) {
                ++retval;
            }
            parentsInt >>= 1;
        }
        return retval;
    }

    public static void main(String[] args) throws IOException {
        String usage = "Usage: java opennlp.ccg.ngrams.FactoredNgramModel <child> <parents> <lmfile> <tokens>";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println(usage);
            System.exit(0);
        }
        String child = args[0];
        String[] parents = args[1].split("\\s+");
        String lmfile = args[2];
        String tokens = args[3];
        System.out.println("Loading n-gram model from: " + lmfile);
        FactoredNgramModel lm = new FactoredNgramModel(child, parents, lmfile, true);
        System.out.println("child var: " + lm.child.name);
        for (int i = 0; i < lm.parents.length; ++i) {
            System.out.println("parent var: (" + lm.parents[i].name + "," + lm.parents[i].position + ")");
        }
        System.out.println("order: " + lm.order);
        System.out.println("openVocab: " + lm.openVocab);
        System.out.println();
        DefaultTokenizer tokenizer = new DefaultTokenizer();
        List<Word> words = tokenizer.tokenize(tokens, true);
        System.out.println("scoring: ");
        for (int i = 0; i < words.size(); ++i) {
            System.out.println(words.get(i).toString());
        }
        System.out.println();
        lm.debugScore = true;
        lm.setWordsToScore(words, true);
        lm.prepareToScoreWords();
        double logprob = lm.logprob();
        double score = FactoredNgramModel.convertToProb(logprob);
        System.out.println();
        System.out.println("score: " + score);
        System.out.println("logprob: " + logprob);
        System.out.println("ppl: " + NgramScorer.convertToPPL(logprob / (double)(words.size() - 1)));
    }

    public class ModelVariable {
        public final String name;
        public final int position;

        public ModelVariable(String str) {
            int leftparen = str.indexOf("(");
            if (leftparen > 0) {
                this.name = str.substring(0, leftparen).intern();
                int rightparen = str.indexOf(")");
                this.position = Math.abs(Integer.parseInt(str.substring(leftparen + 1, rightparen)));
            } else {
                this.name = str.intern();
                this.position = 0;
            }
        }
    }
}

